/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.function.Function;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.GrepOptionsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.command.chatgpt.functions.AbstractExecutableFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.TableDecriptionFunctionParameters;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptionsBuilder;
import schemacrawler.tools.options.Config;

public final class TableDecriptionFunctionDefinition
extends AbstractExecutableFunctionDefinition<TableDecriptionFunctionParameters> {
    public TableDecriptionFunctionDefinition() {
        super("Gets the details and description of database tables or views, including columns, foreign keys, indexes and triggers.", TableDecriptionFunctionParameters.class);
    }

    @Override
    protected Config createAdditionalConfig(TableDecriptionFunctionParameters args) {
        TableDecriptionFunctionParameters.TableDescriptionScope scope = args.getDescriptionScope();
        SchemaTextOptionsBuilder schemaTextOptionsBuilder = SchemaTextOptionsBuilder.builder();
        if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.DEFAULT) {
            if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.COLUMNS) {
                schemaTextOptionsBuilder.noTableColumns();
            }
            if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.PRIMARY_KEY) {
                schemaTextOptionsBuilder.noPrimaryKeys();
            }
            if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.FOREIGN_KEYS) {
                schemaTextOptionsBuilder.noForeignKeys();
                schemaTextOptionsBuilder.noWeakAssociations();
            }
            if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.INDEXES) {
                schemaTextOptionsBuilder.noIndexes();
            }
            if (scope != TableDecriptionFunctionParameters.TableDescriptionScope.TRIGGERS) {
                schemaTextOptionsBuilder.noTriggers();
            }
        }
        ((SchemaTextOptionsBuilder)((SchemaTextOptionsBuilder)schemaTextOptionsBuilder.noTableConstraints()).noAlternateKeys()).noInfo();
        return schemaTextOptionsBuilder.toConfig();
    }

    @Override
    protected SchemaCrawlerOptions createSchemaCrawlerOptions(TableDecriptionFunctionParameters args) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().includeSynonyms((InclusionRule)new ExcludeAll()).includeSequences((InclusionRule)new ExcludeAll()).includeRoutines((InclusionRule)new ExcludeAll());
        Pattern grepTablesPattern = this.makeNameInclusionPattern(args.getTableName());
        GrepOptionsBuilder grepOptionsBuilder = GrepOptionsBuilder.builder().includeGreppedTables(grepTablesPattern);
        return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions()).withGrepOptions(grepOptionsBuilder.toOptions());
    }

    @Override
    protected String getCommand() {
        return "schema";
    }

    @Override
    protected Function<Catalog, Boolean> getResultsChecker(TableDecriptionFunctionParameters args) {
        return catalog -> !catalog.getTables().isEmpty();
    }
}

