/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.function.Function;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.command.chatgpt.functions.AbstractExecutableFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.DatabaseObjectListFunctionParameters;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptionsBuilder;
import schemacrawler.tools.options.Config;

public final class DatabaseObjectListFunctionDefinition
extends AbstractExecutableFunctionDefinition<DatabaseObjectListFunctionParameters> {
    public DatabaseObjectListFunctionDefinition() {
        super("Lists database objects like tables, routines (that is, functions and stored procedures), sequences, or synonyms.", DatabaseObjectListFunctionParameters.class);
    }

    @Override
    protected Config createAdditionalConfig(DatabaseObjectListFunctionParameters args) {
        DatabaseObjectListFunctionParameters.DatabaseObjectType databaseObjectType = args.getDatabaseObjectType();
        SchemaTextOptionsBuilder schemaTextOptionsBuilder = SchemaTextOptionsBuilder.builder();
        if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.ALL) {
            if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.TABLES) {
                schemaTextOptionsBuilder.noTables();
            }
            if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.ROUTINES) {
                schemaTextOptionsBuilder.noRoutines();
            }
            if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.SEQUENCES) {
                schemaTextOptionsBuilder.noSequences();
            }
            if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.SYNONYMS) {
                schemaTextOptionsBuilder.noSynonyms();
            }
        }
        schemaTextOptionsBuilder.noInfo();
        return schemaTextOptionsBuilder.toConfig();
    }

    @Override
    protected SchemaCrawlerOptions createSchemaCrawlerOptions(DatabaseObjectListFunctionParameters args) {
        DatabaseObjectListFunctionParameters.DatabaseObjectType databaseObjectType = args.getDatabaseObjectType();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        if (databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.TABLES && databaseObjectType != DatabaseObjectListFunctionParameters.DatabaseObjectType.ALL) {
            limitOptionsBuilder.includeTables((InclusionRule)new ExcludeAll());
        }
        if (databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.ROUTINES || databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.ALL) {
            limitOptionsBuilder.includeAllRoutines();
        }
        if (databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.SEQUENCES || databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.ALL) {
            limitOptionsBuilder.includeAllSequences();
        }
        if (databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.SYNONYMS || databaseObjectType == DatabaseObjectListFunctionParameters.DatabaseObjectType.ALL) {
            limitOptionsBuilder.includeAllSynonyms();
        }
        return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions());
    }

    @Override
    protected String getCommand() {
        return "list";
    }

    @Override
    protected Function<Catalog, Boolean> getResultsChecker(DatabaseObjectListFunctionParameters args) {
        DatabaseObjectListFunctionParameters.DatabaseObjectType databaseObjectType = args.getDatabaseObjectType();
        switch (databaseObjectType) {
            case TABLES: {
                return catalog -> !catalog.getTables().isEmpty();
            }
            case ROUTINES: {
                return catalog -> !catalog.getRoutines().isEmpty();
            }
            case SEQUENCES: {
                return catalog -> !catalog.getSequences().isEmpty();
            }
            case SYNONYMS: {
                return catalog -> !catalog.getSynonyms().isEmpty();
            }
        }
        return catalog -> !catalog.getTables().isEmpty() || !catalog.getRoutines().isEmpty() || !catalog.getSequences().isEmpty() || !catalog.getSynonyms().isEmpty();
    }
}

