/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.function.Function;
import java.util.regex.Pattern;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionInclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.command.chatgpt.functions.AbstractExecutableFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.DatabaseObjectDescriptionFunctionParameters;
import schemacrawler.tools.command.text.schema.options.SchemaTextOptionsBuilder;
import schemacrawler.tools.options.Config;

public final class DatabaseObjectDescriptionFunctionDefinition
extends AbstractExecutableFunctionDefinition<DatabaseObjectDescriptionFunctionParameters> {
    @JsonPropertyDescription(value="Name of database object to find.")
    private String objectName;

    public DatabaseObjectDescriptionFunctionDefinition() {
        super("Gets the details and description of database objects like routines (that is, functions and stored procedures), sequences, or synonyms.", DatabaseObjectDescriptionFunctionParameters.class);
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    @Override
    protected Config createAdditionalConfig(DatabaseObjectDescriptionFunctionParameters args) {
        DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope scope = args.getDatabaseObjectsScope();
        SchemaTextOptionsBuilder schemaTextOptionsBuilder = SchemaTextOptionsBuilder.builder();
        if (scope != DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope.SEQUENCES) {
            schemaTextOptionsBuilder.noSequences();
        }
        if (scope != DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope.SYNONYMS) {
            schemaTextOptionsBuilder.noSynonyms();
        }
        if (scope != DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope.ROUTINES) {
            schemaTextOptionsBuilder.noRoutines();
        }
        schemaTextOptionsBuilder.noInfo();
        return schemaTextOptionsBuilder.toConfig();
    }

    @Override
    protected SchemaCrawlerOptions createSchemaCrawlerOptions(DatabaseObjectDescriptionFunctionParameters args) {
        Pattern inclusionPattern = this.makeNameInclusionPattern(args.getDatabaseObjectName());
        DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope scope = args.getDatabaseObjectsScope();
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder();
        switch (scope) {
            case SEQUENCES: {
                limitOptionsBuilder.includeSequences((InclusionRule)new RegularExpressionInclusionRule(inclusionPattern));
            }
            case SYNONYMS: {
                limitOptionsBuilder.includeSynonyms((InclusionRule)new RegularExpressionInclusionRule(inclusionPattern));
            }
            case ROUTINES: {
                limitOptionsBuilder.includeRoutines((InclusionRule)new RegularExpressionInclusionRule(inclusionPattern));
            }
        }
        limitOptionsBuilder.includeTables((InclusionRule)new ExcludeAll());
        return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions().withLimitOptions(limitOptionsBuilder.toOptions());
    }

    @Override
    protected String getCommand() {
        return "schema";
    }

    @Override
    protected Function<Catalog, Boolean> getResultsChecker(DatabaseObjectDescriptionFunctionParameters args) {
        DatabaseObjectDescriptionFunctionParameters.DatabaseObjectsScope scope = args.getDatabaseObjectsScope();
        switch (scope) {
            case SEQUENCES: {
                return catalog -> !catalog.getSequences().isEmpty();
            }
            case SYNONYMS: {
                return catalog -> !catalog.getSynonyms().isEmpty();
            }
            case ROUTINES: {
                return catalog -> !catalog.getRoutines().isEmpty();
            }
        }
        return catalog -> false;
    }
}

