/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.sql.Connection;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.tools.command.chatgpt.FunctionDefinition;
import schemacrawler.tools.command.chatgpt.FunctionParameters;
import us.fatehi.utility.Utility;

public abstract class AbstractFunctionDefinition<P extends FunctionParameters>
implements FunctionDefinition<P> {
    private final String description;
    private final Class<P> parameters;
    protected Catalog catalog;
    protected Connection connection;

    protected AbstractFunctionDefinition(String description, Class<P> parameters) {
        this.description = Utility.requireNotBlank((String)description, (String)"Function description not provided");
        this.parameters = Objects.requireNonNull(parameters, "Function parameters not provided");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFunctionDefinition other = (AbstractFunctionDefinition)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.parameters, other.parameters);
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Class<P> getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return Objects.hash(this.description, this.parameters);
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String toString() {
        return String.format("function %s(%s)%n\"%s\"", this.getName(), new PropertyNamingStrategies.KebabCaseStrategy().translate(this.parameters.getSimpleName()), this.description);
    }
}

