/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.chatgpt.FunctionParameters;
import schemacrawler.tools.command.chatgpt.FunctionReturn;
import schemacrawler.tools.command.chatgpt.functions.AbstractFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.ExecutableFunctionReturn;
import schemacrawler.tools.command.chatgpt.utility.ConnectionDatabaseConnectionSource;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.Config;
import schemacrawler.utility.MetaDataUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseConnectionSource;

public abstract class AbstractExecutableFunctionDefinition<P extends FunctionParameters>
extends AbstractFunctionDefinition<P> {
    protected AbstractExecutableFunctionDefinition(String description, Class<P> parameters) {
        super(description, parameters);
    }

    @Override
    public Function<P, FunctionReturn> getExecutor() {
        if (this.catalog == null) {
            throw new ExecutionRuntimeException("Catalog is not provided");
        }
        return args -> {
            SchemaCrawlerExecutable executable = this.createExecutable(args);
            Function<Catalog, Boolean> resultsChecker = this.getResultsChecker(args);
            return new ExecutableFunctionReturn(executable, resultsChecker);
        };
    }

    protected abstract Config createAdditionalConfig(P var1);

    protected abstract SchemaCrawlerOptions createSchemaCrawlerOptions(P var1);

    protected abstract String getCommand();

    protected abstract Function<Catalog, Boolean> getResultsChecker(P var1);

    protected Pattern makeNameInclusionPattern(String name) {
        if (Utility.isBlank((CharSequence)name)) {
            return Pattern.compile(".*");
        }
        boolean hasDefaultSchema = this.hasDefaultSchema();
        return Pattern.compile(String.format(".*%s(?i)%s(?-i)", hasDefaultSchema ? "" : "\\.", name));
    }

    private SchemaCrawlerExecutable createExecutable(P args) {
        SchemaCrawlerOptions options = this.createSchemaCrawlerOptions(args);
        Config config = this.createAdditionalConfig(args);
        String command = this.getCommand();
        MetaDataUtility.reduceCatalog((Catalog)this.catalog, (SchemaCrawlerOptions)options);
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(command);
        executable.setSchemaCrawlerOptions(options);
        executable.setAdditionalConfiguration(config);
        executable.setCatalog(this.catalog);
        if (this.connection != null) {
            ConnectionDatabaseConnectionSource databaseConnectionSource = new ConnectionDatabaseConnectionSource(this.connection);
            executable.setDataSource((DatabaseConnectionSource)databaseConnectionSource);
        }
        return executable;
    }

    private boolean hasDefaultSchema() {
        Collection schemas = this.catalog.getSchemas();
        int schemaCount = schemas.size();
        for (Schema schema : schemas) {
            if (!Utility.isBlank((CharSequence)schema.getFullName()) || schemaCount != 1) continue;
            return true;
        }
        return false;
    }
}

