/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import com.theokanning.openai.embedding.Embedding;
import com.theokanning.openai.embedding.EmbeddingResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.math3.linear.RealVector;
import schemacrawler.tools.command.chatgpt.embeddings.ListRealVector;

public final class TextEmbedding {
    private final String text;
    private final long tokenCount;
    private final ListRealVector embeddingVector;

    public TextEmbedding(String text) {
        this.text = Objects.requireNonNull(text, "No text provided");
        this.tokenCount = 0L;
        this.embeddingVector = new ListRealVector();
    }

    public TextEmbedding(String text, EmbeddingResult embeddingResult) {
        Objects.requireNonNull(embeddingResult, "No embedding result provided");
        List embeddings = embeddingResult.getData();
        List embedding = embeddings != null && embeddings.size() == 1 ? ((Embedding)embeddings.get(0)).getEmbedding() : new ArrayList();
        this.text = Objects.requireNonNull(text, "No text provided");
        this.tokenCount = embeddingResult.getUsage().getPromptTokens();
        this.embeddingVector = new ListRealVector(embedding);
    }

    public String getText() {
        return this.text;
    }

    public List<Double> getEmbedding() {
        return this.embeddingVector.getEmbedding();
    }

    public RealVector getEmbeddingVector() {
        return this.embeddingVector;
    }

    public long getTokenCount() {
        return this.tokenCount;
    }
}

