/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.embeddings;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.Table;
import schemacrawler.tools.command.chatgpt.embeddings.EmbeddedTable;
import schemacrawler.tools.command.chatgpt.embeddings.EmbeddingService;
import us.fatehi.utility.string.StringFormat;

public final class TableEmbeddingService {
    private static final Logger LOGGER = Logger.getLogger(TableEmbeddingService.class.getCanonicalName());
    private final EmbeddingService service;

    public TableEmbeddingService(EmbeddingService service) {
        this.service = Objects.requireNonNull(service, "No embedding service provided");
    }

    public EmbeddedTable embedTable(Table table) {
        Objects.requireNonNull(table, "No table provided");
        LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Emebedding table <%s>", new Object[]{table}));
        EmbeddedTable embeddedTable = new EmbeddedTable(table);
        embeddedTable.setEmbedding(this.service.embed(embeddedTable.toJson()));
        return embeddedTable;
    }
}

