/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt;

import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.command.chatgpt.ChatGPTCommand;
import schemacrawler.tools.command.chatgpt.options.ChatGPTCommandOptions;
import schemacrawler.tools.command.chatgpt.options.ChatGPTCommandOptionsBuilder;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.property.PropertyName;

public final class ChatGPTCommandProvider
extends BaseCommandProvider {
    public static final String DESCRIPTION_HEADER = "SchemaCrawler ChatGPT integration";

    public ChatGPTCommandProvider() {
        super(new PropertyName("chatgpt", DESCRIPTION_HEADER));
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"chatgpt", (String)"** SchemaCrawler ChatGPT integration");
        pluginCommand.addOption("api-key", String.class, new String[]{"OpenAI API key"}).addOption("api-key:env", String.class, new String[]{"OpenAI API key, from an environmental variable value"}).addOption("model", String.class, new String[]{"ChatGPT model", "Optional, defaults to 'chatgpt-3.5-turbo'"}).addOption("timeout", Integer.class, new String[]{"Number of seconds to timeout a request if no response is received", "Optional, defaults to 10"}).addOption("context", Integer.class, new String[]{"Number of chat messages (not tokens) to maintain as chat context", "Optional, defaults to 10"}).addOption("use-metadata", Boolean.class, new String[]{"Allow sharing of database metadata with OpenAI to enhance chat responses", "Optional, defaults to false"});
        return pluginCommand;
    }

    public ChatGPTCommand newSchemaCrawlerCommand(String command, Config config) {
        if (!"chatgpt".equals(command)) {
            throw new IllegalArgumentException("Cannot support command, " + command);
        }
        try {
            ChatGPTCommandOptions options = ChatGPTCommandOptionsBuilder.builder().fromConfig(config).toOptions();
            ChatGPTCommand scCommand = new ChatGPTCommand();
            scCommand.setCommandOptions(options);
            return scCommand;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException((Throwable)e);
        }
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return true;
    }
}

