/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.$internal.client.auth.external.CompositeRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.DesktopBrowserRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.SystemOpenRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.SystemOutPrintRedirectHandler;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import java.util.Objects;

public enum ExternalRedirectStrategy {
    DESKTOP_OPEN(new DesktopBrowserRedirectHandler()),
    SYSTEM_OPEN(new SystemOpenRedirectHandler()),
    PRINT(new SystemOutPrintRedirectHandler()),
    OPEN(new CompositeRedirectHandler(ImmutableList.of(SYSTEM_OPEN, DESKTOP_OPEN))),
    ALL(new CompositeRedirectHandler(ImmutableList.of(OPEN, PRINT)));

    private final RedirectHandler handler;

    private ExternalRedirectStrategy(RedirectHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler is null");
    }

    public RedirectHandler getHandler() {
        return this.handler;
    }
}

