/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.diagram;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import schemacrawler.crawl.NotLoadedException;
import schemacrawler.loader.counts.TableRowCountsUtility;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnDataType;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Index;
import schemacrawler.schema.IndexType;
import schemacrawler.schema.PrimaryKey;
import schemacrawler.schema.Routine;
import schemacrawler.schema.Sequence;
import schemacrawler.schema.Synonym;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.WeakAssociation;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.schema.options.HideDatabaseObjectNamesType;
import schemacrawler.tools.command.text.schema.options.HideDependantDatabaseObjectsType;
import schemacrawler.tools.command.text.schema.options.SchemaTextDetailType;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.diagram.BaseDotFormatter;
import schemacrawler.tools.traversal.SchemaTraversalHandler;
import schemacrawler.utility.MetaDataUtility;
import schemacrawler.utility.NamedObjectSort;
import us.fatehi.utility.Color;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Alignment;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public final class SchemaDotFormatter
extends BaseDotFormatter
implements SchemaTraversalHandler {
    private final int tableColspan;

    public SchemaDotFormatter(SchemaTextDetailType schemaTextDetailType, DiagramOptions options, OutputOptions outputOptions, Identifiers identifiers) {
        super(schemaTextDetailType, options, outputOptions, identifiers);
        this.tableColspan = options.isShowOrdinalNumbers() ? 4 : 3;
    }

    @Override
    public void handle(ColumnDataType columnDataType) {
    }

    @Override
    public void handle(Routine routine) {
    }

    @Override
    public void handle(Sequence sequence) {
    }

    @Override
    public void handle(Synonym synonym) {
    }

    @Override
    public void handle(Table table) {
        String tableName = this.quoteName(table);
        String tableType = "[" + table.getTableType() + "]";
        Color tableNameBgColor = this.colorMap.getColor(table);
        this.formattingHelper.append("  /* ").append(table.getFullName()).append(" -=-=-=-=-=-=-=-=-=-=-=-=-=- */").println();
        this.formattingHelper.append("  \"").append(this.nodeId(table)).append("\" [").println();
        this.formattingHelper.append("    label=<").println();
        this.formattingHelper.append("      <table border=\"1\" cellborder=\"0\" cellspacing=\"0\" color=\"#888888\">").println();
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(tableName).withAlignment(Alignment.left).withEmphasis(true).withBackground(tableNameBgColor).withColumnSpan(this.tableColspan - 1).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(tableType).withBackground(tableNameBgColor).withAlignment(Alignment.right).make()).render(TagOutputFormat.html)).println();
        this.printTableRemarks(table);
        if (!((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideTableColumns)) {
            this.printTableColumns(table.getColumns());
            if (this.isVerbose()) {
                this.printTableColumns(new ArrayList<Column>(table.getHiddenColumns()));
            }
        }
        if (this.isVerbose()) {
            this.printIndexes(table);
        }
        this.printAlternateKeys(table);
        this.printTableRowCount(table);
        this.formattingHelper.append("      </table>").println();
        this.formattingHelper.append("    >").println();
        this.formattingHelper.append("  ];").println();
        this.formattingHelper.println();
        this.printForeignKeys(table);
        this.printWeakAssociations(table);
        this.formattingHelper.println();
        this.formattingHelper.println();
    }

    @Override
    public void handleColumnDataTypesEnd() {
    }

    @Override
    public void handleColumnDataTypesStart() {
    }

    @Override
    public void handleRoutinesEnd() {
    }

    @Override
    public void handleRoutinesStart() {
    }

    @Override
    public void handleSequencesEnd() {
    }

    @Override
    public void handleSequencesStart() {
    }

    @Override
    public void handleSynonymsEnd() {
    }

    @Override
    public void handleSynonymsStart() {
    }

    @Override
    public void handleTablesEnd() {
    }

    @Override
    public void handleTablesStart() {
    }

    private String arrowhead(MetaDataUtility.ForeignKeyCardinality connectivity) {
        switch (connectivity) {
            case zero_one: {
                return "teeodot";
            }
            case zero_many: {
                return "crowodot";
            }
            case one_one: {
                return "teetee";
            }
        }
        return "box";
    }

    private String[] getPortIds(Column column, boolean isNewNode) {
        String[] portIds = new String[2];
        if (!isNewNode) {
            portIds[0] = String.format("\"%s\":\"%s.start\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
            portIds[1] = String.format("\"%s\":\"%s.end\"", this.nodeId((DatabaseObject)column.getParent()), this.nodeId(column));
        } else {
            String nodeId;
            portIds[0] = nodeId = this.printNewNode(column);
            portIds[1] = nodeId;
        }
        return portIds;
    }

    private void printAlternateKeys(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideAlternateKeys)) {
            return;
        }
        Collection<PrimaryKey> alternateKeys = table.getAlternateKeys();
        if (alternateKeys == null || alternateKeys.isEmpty()) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        for (TableConstraint tableConstraint : alternateKeys) {
            String name = this.identifiers.quoteName(tableConstraint);
            String akName = !((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideAlternateKeyNames) ? name : "";
            String columnsList = MetaDataUtility.getColumnsListAsString(tableConstraint, this.identifiers);
            if (!Utility.isBlank(columnsList)) {
                columnsList = " (" + columnsList + ")";
            }
            String constraintText = String.format("\u2022 %s%s [alternate key]", akName, columnsList);
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(constraintText).withAlignment(Alignment.left).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
            if (!tableConstraint.hasRemarks()) continue;
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(tableConstraint.getRemarks()).withAlignment(Alignment.left).withBackground(Color.fromRGB(244, 244, 244)).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
        }
    }

    private String printColumnReference(boolean isForeignKey, String fkName, ColumnReference columnRef, MetaDataUtility.ForeignKeyCardinality fkCardinality, boolean isPkColumnFiltered, boolean isFkColumnFiltered, boolean showRemarks, String remarks) {
        String label;
        Column primaryKeyColumn = columnRef.getPrimaryKeyColumn();
        Column foreignKeyColumn = columnRef.getForeignKeyColumn();
        boolean isPkColumnSignificant = this.isColumnSignificant(primaryKeyColumn);
        boolean isFkColumnSignificant = this.isColumnSignificant(foreignKeyColumn);
        if (!isPkColumnSignificant || !((DiagramOptions)this.options).isShowFilteredTables() && !isFkColumnSignificant) {
            return "";
        }
        String[] pkPortIds = this.getPortIds(primaryKeyColumn, isPkColumnFiltered);
        String[] fkPortIds = this.getPortIds(foreignKeyColumn, isFkColumnFiltered || !isFkColumnSignificant);
        DiagramOptions diagramOptions = (DiagramOptions)this.options;
        String pkSymbol = diagramOptions.isShowPrimaryKeyCardinality() ? "teetee" : "none";
        String fkSymbol = diagramOptions.isShowForeignKeyCardinality() ? this.arrowhead(fkCardinality) : "none";
        String style = isForeignKey ? "solid" : "dashed";
        String associationName = isForeignKey && ((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideForeignKeyNames) || !isForeignKey && ((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideWeakAssociationNames) ? "" : fkName;
        if (showRemarks) {
            String remarksLines = remarks.replaceAll("\\R", "<br/>");
            label = associationName + "<br/>" + remarksLines;
        } else {
            label = associationName;
        }
        return String.format("  %s:w -> %s:e [label=<%s> style=\"%s\" dir=\"both\" arrowhead=\"%s\" arrowtail=\"%s\"];%n", fkPortIds[0], pkPortIds[1], label, style, pkSymbol, fkSymbol);
    }

    private void printForeignKeys(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideForeignKeys)) {
            return;
        }
        this.printForeignKeys(table, table.getForeignKeys());
    }

    private <R extends ColumnReference> void printForeignKeys(Table table, Collection<? extends TableReference> foreignKeys) {
        for (TableReference tableReference : foreignKeys) {
            boolean isForeignKey = tableReference.getType() == TableConstraintType.foreign_key;
            MetaDataUtility.ForeignKeyCardinality fkCardinality = MetaDataUtility.findForeignKeyCardinality(tableReference);
            boolean showRemarks = !((DiagramOptions)this.options).isHideRemarks() && tableReference.hasRemarks();
            for (ColumnReference columnRef : tableReference) {
                Table referencedTable = (Table)columnRef.getPrimaryKeyColumn().getParent();
                Table dependentTable = (Table)columnRef.getForeignKeyColumn().getParent();
                boolean isPkColumnFiltered = this.isTableFiltered(referencedTable);
                boolean isFkColumnFiltered = this.isTableFiltered(dependentTable);
                if (!((DiagramOptions)this.options).isShowFilteredTables() && (isPkColumnFiltered || isFkColumnFiltered)) continue;
                String remarks = showRemarks ? tableReference.getRemarks() : "";
                if (table.equals(referencedTable) || isPkColumnFiltered && table.equals(dependentTable)) {
                    this.formattingHelper.append(this.printColumnReference(isForeignKey, this.identifiers.quoteName(tableReference.getName()), columnRef, fkCardinality, isPkColumnFiltered, isFkColumnFiltered, showRemarks, remarks));
                }
                showRemarks = false;
            }
        }
    }

    private void printIndexes(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideIndexes)) {
            return;
        }
        Collection<Index> indexes = table.getIndexes();
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        for (Index index : indexes) {
            String name = this.identifiers.quoteName(index);
            String indexName = !((DiagramOptions)this.options).is(HideDatabaseObjectNamesType.hideIndexNames) ? name : "";
            IndexType indexType = index.getIndexType();
            String indexTypeString = "";
            if (indexType != IndexType.unknown && indexType != IndexType.other) {
                indexTypeString = indexType.toString() + " ";
            }
            String indexDetails = (index.isUnique() ? "" : "non-") + "unique " + indexTypeString + "index";
            String columnsList = MetaDataUtility.getColumnsListAsString(index, this.identifiers);
            if (!Utility.isBlank(columnsList)) {
                columnsList = " (" + columnsList + ")";
            }
            String constraintText = String.format("\u2022 %s%s [%s]", indexName, columnsList, indexDetails);
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(constraintText).withAlignment(Alignment.left).withBackground(Color.fromRGB(244, 244, 244)).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
            if (!index.hasRemarks()) continue;
            this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(index.getRemarks()).withAlignment(Alignment.left).withBackground(Color.fromRGB(244, 244, 244)).withColumnSpan(3).make()).render(TagOutputFormat.html)).println();
        }
    }

    private String printNewNode(Column column) {
        String nodeId = "\"" + this.nodeId(column) + "\"";
        String columnName = ((DiagramOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteShortName(column) : this.identifiers.quoteFullName(column);
        String columnNode = String.format("  %s [label=<%s>];%n", nodeId, columnName);
        this.formattingHelper.append(columnNode);
        return nodeId;
    }

    private void printTableColumnAutoIncremented(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isAutoIncremented()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("auto-incremented").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnEnumValues(Column column) {
        if (column == null || !column.isColumnDataTypeKnown() || !column.getColumnDataType().isEnumerated()) {
            return;
        }
        String enumValues = String.format("'%s'", String.join((CharSequence)"', ", column.getColumnDataType().getEnumValues()));
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(enumValues).withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnGenerated(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isGenerated()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("generated").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnHidden(Column column) {
        if (column == null) {
            return;
        }
        try {
            if (!column.isHidden()) {
                return;
            }
        }
        catch (NotLoadedException e) {
            return;
        }
        Tag row = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        row.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText("hidden").withAlignment(Alignment.left).make());
        this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
    }

    private void printTableColumnRemarks(Column column) {
        if (column == null || !column.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        Tag remarksRow = TagBuilder.tableRow().make();
        if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
            remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.right).make());
        }
        remarksRow.addInnerTag(TagBuilder.tableCell().withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(column.getRemarks()).withAlignment(Alignment.left).make());
        this.formattingHelper.append(remarksRow.render(TagOutputFormat.html)).println();
    }

    private void printTableColumns(List<Column> columns) {
        if (columns.isEmpty()) {
            return;
        }
        Collections.sort(columns, NamedObjectSort.getNamedObjectSort(((DiagramOptions)this.options).isAlphabeticalSortForTableColumns()));
        for (Column column : columns) {
            if (!this.isColumnSignificant(column)) continue;
            String columnTypeName = ((DiagramOptions)this.options).isShowStandardColumnTypeNames() ? column.getColumnDataType().getJavaSqlType().getName() : column.getColumnDataType().getDatabaseSpecificTypeName();
            String columnType = columnTypeName + column.getWidth();
            String nullable = this.columnNullable(columnTypeName, column.isNullable());
            String columnDetails = columnType + nullable;
            boolean emphasize = column.isPartOfPrimaryKey();
            Tag row = TagBuilder.tableRow().make();
            if (((DiagramOptions)this.options).isShowOrdinalNumbers()) {
                String ordinalNumberString = String.valueOf(column.getOrdinalPosition());
                row.addInnerTag(TagBuilder.tableCell().withEscapedText(ordinalNumberString).withAlignment(Alignment.right).make());
            }
            row.addInnerTag(TagBuilder.tableCell().withEscapedText(this.identifiers.quoteName(column.getName())).withAlignment(Alignment.left).withEmphasis(emphasize).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(" ").withAlignment(Alignment.left).make()).addInnerTag(TagBuilder.tableCell().withEscapedText(columnDetails).withAlignment(Alignment.left).make());
            row.firstInnerTag().addAttribute("port", this.nodeId(column) + ".start");
            row.lastInnerTag().addAttribute("port", this.nodeId(column) + ".end");
            this.formattingHelper.append(row.render(TagOutputFormat.html)).println();
            this.printTableColumnEnumValues(column);
            this.printTableColumnHidden(column);
            this.printTableColumnAutoIncremented(column);
            this.printTableColumnGenerated(column);
            this.printTableColumnRemarks(column);
        }
    }

    private void printTableRemarks(Table table) {
        if (table == null || !table.hasRemarks() || ((DiagramOptions)this.options).isHideRemarks()) {
            return;
        }
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(table.getRemarks()).withAlignment(Alignment.left).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
    }

    private void printTableRowCount(Table table) {
        if (((DiagramOptions)this.options).isHideTableRowCounts() || !TableRowCountsUtility.hasRowCount(table)) {
            return;
        }
        this.formattingHelper.append("\t<hr/>").append(System.lineSeparator());
        this.formattingHelper.append(TagBuilder.tableRow().make().addInnerTag(TagBuilder.tableCell().withEscapedText(TableRowCountsUtility.getRowCountMessage(table)).withAlignment(Alignment.right).withColumnSpan(this.tableColspan).make()).render(TagOutputFormat.html)).println();
    }

    private void printWeakAssociations(Table table) {
        if (table == null || ((DiagramOptions)this.options).is(HideDependantDatabaseObjectsType.hideWeakAssociations)) {
            return;
        }
        Collection<WeakAssociation> weakFks = table.getWeakAssociations();
        this.printForeignKeys(table, weakFks);
    }
}

