/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConversionsUtil {
    static final Logger LOG = LoggerFactory.getLogger(ConversionsUtil.class);
    static final String BINARY_FAILED_CONVERSION = "Unable to convert %s object to byte array.";

    private ConversionsUtil() {
    }

    public static byte[] convertToByteArray(Object x) throws SQLException {
        byte[] array = new byte[]{};
        if (x instanceof ByteArrayInputStream) {
            array = new byte[((ByteArrayInputStream)x).available()];
            try {
                ((ByteArrayInputStream)x).read(array);
            }
            catch (IOException e) {
                LOG.warn(String.format(BINARY_FAILED_CONVERSION, x.getClass()), (Throwable)e);
            }
        } else if (x instanceof byte[]) {
            array = (byte[])x;
        } else if (x instanceof Blob) {
            try {
                InputStream stream = ((Blob)x).getBinaryStream();
                array = new byte[stream.available()];
                stream.read(array);
            }
            catch (IOException | SQLException e) {
                LOG.warn(String.format(BINARY_FAILED_CONVERSION, x.getClass()), (Throwable)e);
            }
        } else if (x instanceof Clob) {
            try (Reader reader = ((Clob)x).getCharacterStream();){
                array = IOUtils.toByteArray((Reader)reader, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException | SQLException e) {
                LOG.warn(String.format(BINARY_FAILED_CONVERSION, x.getClass()), (Throwable)e);
            }
        } else {
            throw new SQLException(String.format("Unsupported parameter type: %s", x.getClass()));
        }
        return array;
    }

    public static LocalDate convertToLocalDate(Object x) throws SQLException {
        if (x instanceof LocalDate) {
            return (LocalDate)x;
        }
        if (x instanceof Date) {
            return ((Date)x).toLocalDate();
        }
        throw new SQLException(String.format("Unsupported parameter type: %s", x.getClass()));
    }

    public static LocalTime convertToLocalTime(Object x) throws SQLException {
        if (x instanceof LocalTime) {
            return (LocalTime)x;
        }
        if (x instanceof Time) {
            return ((Time)x).toLocalTime();
        }
        if (x instanceof OffsetTime) {
            return ((OffsetTime)x).toLocalTime();
        }
        throw new SQLException(String.format("Unsupported parameter type: %s", x.getClass()));
    }

    public static Instant convertToInstant(Object x) throws SQLException {
        if (x instanceof LocalDateTime) {
            return ((LocalDateTime)x).atZone(ZoneOffset.systemDefault()).toInstant();
        }
        if (x instanceof Timestamp) {
            return ((Timestamp)x).toInstant();
        }
        if (x instanceof java.util.Date) {
            return ((java.util.Date)x).toInstant();
        }
        if (x instanceof Calendar) {
            return ((Calendar)x).toInstant();
        }
        if (x instanceof OffsetDateTime) {
            return ((OffsetDateTime)x).toInstant();
        }
        throw new SQLException(String.format("Unsupported parameter type: %s", x.getClass()));
    }
}

