/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.Comparator;
import java.util.Objects;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.datasource.DatabaseConnectionSource;
import us.fatehi.utility.property.PropertyName;

public abstract class BaseCatalogLoader
implements CatalogLoader {
    private static Comparator<CatalogLoader> comparator = Comparator.nullsLast(Comparator.comparingInt(CatalogLoader::getPriority)).thenComparing(loader -> loader.getCatalogLoaderName().getName());
    private final int priority;
    private final PropertyName catalogLoaderName;
    private SchemaRetrievalOptions schemaRetrievalOptions;
    private SchemaCrawlerOptions schemaCrawlerOptions;
    private Config additionalConfig;
    private DatabaseConnectionSource dataSource;
    private Catalog catalog;

    protected BaseCatalogLoader(PropertyName catalogLoaderName, int priority) {
        this.catalogLoaderName = Objects.requireNonNull(catalogLoaderName, "No catalog loader name provided");
        this.priority = priority;
    }

    @Override
    public int compareTo(CatalogLoader otherCatalogLoader) {
        return Objects.compare(this, otherCatalogLoader, comparator);
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public PropertyName getCatalogLoaderName() {
        return this.catalogLoaderName;
    }

    @Override
    public PluginCommand getCommandLineCommand() {
        return PluginCommand.empty();
    }

    @Override
    public DatabaseConnectionSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public SchemaCrawlerOptions getSchemaCrawlerOptions() {
        if (this.schemaCrawlerOptions == null) {
            return SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        }
        return this.schemaCrawlerOptions;
    }

    @Override
    public SchemaRetrievalOptions getSchemaRetrievalOptions() {
        if (this.schemaRetrievalOptions == null) {
            return SchemaRetrievalOptionsBuilder.newSchemaRetrievalOptions();
        }
        return this.schemaRetrievalOptions;
    }

    @Override
    public void setAdditionalConfiguration(Config additionalConfig) {
        this.additionalConfig = additionalConfig;
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    @Override
    public void setDataSource(DatabaseConnectionSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setSchemaCrawlerOptions(SchemaCrawlerOptions schemaCrawlerOptions) {
        this.schemaCrawlerOptions = schemaCrawlerOptions;
    }

    @Override
    public void setSchemaRetrievalOptions(SchemaRetrievalOptions schemaRetrievalOptions) {
        this.schemaRetrievalOptions = schemaRetrievalOptions;
    }

    protected Config getAdditionalConfiguration() {
        return this.additionalConfig;
    }

    protected boolean isDatabaseSystemIdentifier(String databaseSystemIdentifier) {
        String actualDatabaseSystemIdentifier = this.getSchemaRetrievalOptions().getDatabaseServerType().getDatabaseSystemIdentifier();
        if (actualDatabaseSystemIdentifier == null && databaseSystemIdentifier == null) {
            return true;
        }
        if (actualDatabaseSystemIdentifier != null) {
            return actualDatabaseSystemIdentifier.equals(databaseSystemIdentifier);
        }
        return false;
    }

    protected boolean isLoaded() {
        return this.catalog != null;
    }
}

