/* codecore.vapi generated by valac 0.56.18, do not modify. */

namespace Scratch {
	namespace Dialogs {
		[CCode (cheader_filename = "codecore.h")]
		public class GlobalSearchDialog : Granite.MessageDialog {
			public GlobalSearchDialog (string folder_name, bool is_repo);
			public bool case_sensitive { get; set; }
			public string folder_name { get; construct; }
			public bool is_repo { get; construct; }
			public string search_term { get; set; }
			public bool use_regex { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class NewBranchDialog : Granite.MessageDialog {
			public NewBranchDialog (Scratch.FolderManager.ProjectFolderItem project);
			public Scratch.FolderManager.ProjectFolderItem active_project { get; construct; }
			public string new_branch_name { get; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class Preferences : Granite.Dialog {
			public Preferences (Gtk.Window? parent, Scratch.Services.PluginsManager plugins);
			public Scratch.Services.PluginsManager plugins { get; construct; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class RestoreConfirmationDialog : Granite.MessageDialog {
			public RestoreConfirmationDialog (Scratch.MainWindow parent);
		}
	}
	namespace FolderManager {
		[CCode (cheader_filename = "codecore.h")]
		public class File : GLib.Object {
			public File (string path);
			public static int compare (Scratch.FolderManager.File a, Scratch.FolderManager.File b);
			public void invalidate_cache ();
			public bool is_valid_directory (bool allow_hidden = true);
			public void rename (string name);
			public void trash ();
			public Gee.Collection<Scratch.FolderManager.File> children { owned get; }
			public bool exists { get; }
			public GLib.File file { get; private set; }
			public GLib.Icon icon { get; }
			public bool is_executable { get; }
			public bool is_temporary { get; }
			public bool is_valid_textfile { get; }
			public string name { get; }
			public string path { owned get; set construct; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class FileItem : Scratch.FolderManager.Item {
			public FileItem (Scratch.FolderManager.File file, Scratch.FolderManager.FileView view);
			public override Gtk.Menu? get_context_menu ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public class FileView : Code.Widgets.SourceList, Code.PaneSwitcher {
			public const string ACTION_CHANGE_BRANCH;
			public const string ACTION_CLOSE_FOLDER;
			public const string ACTION_CLOSE_OTHER_FOLDERS;
			public const string ACTION_DELETE;
			public const string ACTION_EXECUTE_CONTRACT_WITH_FILE_PATH;
			public const string ACTION_GROUP;
			public const string ACTION_LAUNCH_APP_WITH_FILE_PATH;
			public const string ACTION_NEW_FILE;
			public const string ACTION_NEW_FOLDER;
			public const string ACTION_PREFIX;
			public const string ACTION_RENAME_FILE;
			public const string ACTION_RENAME_FOLDER;
			public const string ACTION_SHOW_APP_CHOOSER;
			public FileView (Scratch.Services.PluginsManager plugins_manager);
			public void clear_badges ();
			public void collapse_all ();
			public void collapse_other_projects (string? keep_open_path = null);
			public unowned Code.Widgets.SourceList.Item? expand_to_path (string path);
			public void folder_item_update_hook (GLib.File source, GLib.File? dest, GLib.FileMonitorEvent event);
			public Scratch.FolderManager.ProjectFolderItem? get_project_for_file (GLib.File file);
			public void new_branch (string active_project_path);
			public void open_folder (Scratch.FolderManager.File folder);
			public void order_folders ();
			public void restore_saved_state ();
			public void search_global (string path, string? term = null);
			public void select_path (string path);
			public void unselect_all ();
			public GLib.SimpleActionGroup actions { get; private set; }
			public string active_project_path { get; }
			public bool ignore_next_select { get; set; }
			public GLib.ActionGroup toplevel_action_group { get; private set; }
			public signal bool rename_request (Scratch.FolderManager.File file);
			public signal void select (string file);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class FolderItem : Scratch.FolderManager.Item {
			public FolderItem (Scratch.FolderManager.File file, Scratch.FolderManager.FileView view);
			public new void add (Code.Widgets.SourceList.Item item);
			public new void clear ();
			protected GLib.MenuItem create_submenu_for_new ();
			protected GLib.MenuItem create_submenu_for_open_in (string? file_type);
			public override Gtk.Menu? get_context_menu ();
			public void on_add_new (bool is_folder);
			protected virtual void on_changed (GLib.File source, GLib.File? dest, GLib.FileMonitorEvent event);
			public new void remove (Code.Widgets.SourceList.Item item);
			public void remove_all_badges ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public abstract class Item : Code.Widgets.SourceList.ExpandableItem, Code.Widgets.SourceListSortable {
			protected Item ();
			public Scratch.FolderManager.ProjectFolderItem? get_root_folder (Code.Widgets.SourceList.ExpandableItem? start = null);
			protected void rename (string new_name);
			public void trash ();
			public Scratch.FolderManager.File file { get; construct; }
			public string path { owned get; set; }
			public Scratch.FolderManager.FileView view { get; construct; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class ProjectFolderItem : Scratch.FolderManager.FolderItem {
			public ProjectFolderItem (Scratch.FolderManager.File file, Scratch.FolderManager.FileView view);
			public void child_folder_changed (Scratch.FolderManager.FolderItem folder);
			public void child_folder_loaded (Scratch.FolderManager.FolderItem folder);
			public bool contains_file (GLib.File descendant);
			protected GLib.MenuItem create_submenu_for_branch ();
			public unowned GLib.List<string> get_branch_names ();
			public override Gtk.Menu? get_context_menu ();
			public string get_current_branch_name ();
			public void global_search (GLib.File start_folder = @this.file.file, string? term = null, bool is_explicit = false);
			public bool has_local_branch_name (string name);
			public bool is_valid_new_branch_name (string new_name);
			public void new_branch (string branch_name);
			protected override void on_changed (GLib.File source, GLib.File? dest, GLib.FileMonitorEvent event);
			public void refresh_diff (ref Gee.HashMap<int,Scratch.Services.VCStatus> line_status_map, string doc_path);
			public void update_item_status (Scratch.FolderManager.FolderItem? start_folder);
			public bool is_git_repo { get; }
			public Scratch.Services.MonitoredRepository? monitored_repo { get; private set; }
			public signal void closed ();
		}
	}
	namespace Services {
		namespace ValaComparison {
		}
		[CCode (cheader_filename = "codecore.h")]
		public class CtagsSymbol : Code.Widgets.SourceList.ExpandableItem {
			public CtagsSymbol (Scratch.Services.Document doc, string name, int line, GLib.Icon? _icon, Scratch.Services.SymbolType? s_type = null);
			public Scratch.Services.Document doc { get; set construct; }
			public int line { get; set construct; }
			public Scratch.Services.SymbolType symbol_type { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class CtagsSymbolIter : GLib.Object {
			public Scratch.Services.SymbolType? symbol_type;
			public CtagsSymbolIter (string name, string parent, int line, GLib.Icon? icon, Scratch.Services.SymbolType? s_type = SymbolType.OTHER);
			public GLib.Icon? icon { get; set construct; }
			public int line { get; set construct; }
			public string name { get; set construct; }
			public string parent { get; set construct; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class CtagsSymbolOutline : Scratch.Services.SymbolOutline {
			public CtagsSymbolOutline (Scratch.Services.Document _doc);
			public override void parse_symbols ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public class Document : Gtk.Box {
			public delegate void VoidFunc ();
			public Gtk.Stack main_stack;
			public string original_content;
			public bool saved;
			public Scratch.Widgets.SourceView source_view;
			public Document (GLib.SimpleActionGroup actions, GLib.File file);
			public bool can_write ();
			public void check_undoable_actions ();
			public async bool do_close (bool app_closing = false);
			public void duplicate_selection ();
			public bool exists (GLib.Cancellable? cancellable = null);
			public new void focus ();
			public string get_basename ();
			public string get_directory ();
			public string get_language_id ();
			public string get_language_name ();
			public string get_selected_text (bool replace_newline = true);
			public string get_tab_tooltip ();
			public string get_text ();
			public string get_uri ();
			public void goto (int line);
			public void init_tab (Hdy.TabPage tab);
			public bool move (GLib.File new_dest);
			public async void open (bool force = false);
			public void redo ();
			public void revert ();
			public async bool save_as_with_hold ();
			public void save_request ();
			public async bool save_with_hold (bool force = false, bool saving_as = false);
			public void set_outline_width (int width);
			public void set_saved_status (bool val);
			public void show_outline (bool show);
			public void toggle_changed_handlers (bool enabled);
			public void undo ();
			public weak GLib.SimpleActionGroup actions { get; set construct; }
			public GLib.File file { get; private set; }
			public GLib.Icon icon { get; set; }
			public bool is_file_temporary { get; }
			public bool loading { get; set; }
			public bool locked { get; set; }
			public string? mime_type { get; }
			public weak Hdy.TabPage tab { get; private set; }
			public string title { get; set; }
			public signal void doc_closed ();
			public signal void doc_opened ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public class DocumentManager : GLib.Object {
			public DocumentManager ();
			public void add_open_document (Scratch.Services.Document doc);
			public static Scratch.Services.DocumentManager get_instance ();
			public void make_restorable (Scratch.Services.Document doc);
			public uint open_for_project (string project_path);
			public void remove_open_document (Scratch.Services.Document doc);
			public void remove_project (string project_path);
			public uint restorable_for_project (string project_path);
			public Gee.Collection<string> take_restorable_paths (string project_path);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class FileHandler : GLib.Object {
			public FileHandler ();
			public static bool can_open_file (GLib.File file, out bool is_folder);
			public static bool copy (string path, string new_path);
			public static async string? load_content_from_file (GLib.File file);
			public static string? load_content_from_file_sync (GLib.File file);
			public static bool move (string path, string new_path);
			public static bool move_uri (string uri, string new_uri);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class GitManager : GLib.Object {
			public Scratch.Services.MonitoredRepository? add_project (Scratch.FolderManager.ProjectFolderItem root_folder);
			public string get_default_build_dir (string? project_path);
			public static Scratch.Services.GitManager get_instance ();
			public static Scratch.Services.MonitoredRepository? get_monitored_repository (string root_path);
			public void remove_project (Scratch.FolderManager.ProjectFolderItem root_folder);
			public string active_project_path { get; set; }
			public GLib.ListStore project_liststore { get; private set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class Interface : GLib.Object {
			public Scratch.Services.PluginsManager manager;
			public Interface (Scratch.Services.PluginsManager manager);
			public void close_document (Scratch.Services.Document doc);
			public Scratch.Services.Document open_file (GLib.File file);
			public Scratch.TemplateManager template_manager { get; private set; }
			public signal void hook_document (Scratch.Services.Document doc);
			public signal void hook_folder_item_change (GLib.File file, GLib.File? other_file, GLib.FileMonitorEvent event_type);
			public signal void hook_preferences_dialog (Scratch.Dialogs.Preferences dialog);
			public signal void hook_share_menu (GLib.MenuModel menu);
			public signal void hook_toolbar (Scratch.HeaderBar toolbar);
			public signal void hook_window (Scratch.MainWindow window);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class MonitoredRepository : GLib.Object {
			public MonitoredRepository (Ggit.Repository _git_repo);
			public void change_branch (string new_branch_name) throws GLib.Error;
			public void create_new_branch (string name) throws GLib.Error;
			public unowned string get_current_branch ();
			public unowned GLib.List<string> get_local_branches ();
			public bool has_local_branch_name (string name);
			public bool is_valid_new_local_branch_name (string new_name);
			public bool path_is_ignored (string path) throws GLib.Error;
			public void refresh_diff (string file_path, ref Gee.HashMap<int,Scratch.Services.VCStatus> line_status_map);
			public void update_status_map ();
			public string branch_name { get; set; }
			public Ggit.Repository git_repo { get; set construct; }
			public bool has_uncommitted { get; }
			public bool head_is_branch { get; }
			public Gee.Set<Gee.Map.Entry<string,Ggit.StatusFlags?>> non_current_entries { owned get; }
			public signal void branch_changed ();
			public signal void file_content_changed ();
			public signal void file_status_change ();
			public signal void ignored_changed ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public class PluginsManager : GLib.Object {
			public weak Scratch.MainWindow window;
			public PluginsManager (Scratch.MainWindow window);
			public Gtk.Widget get_view ();
			public Scratch.Services.Interface plugin_iface { get; private set; }
			public signal void extension_added (Peas.PluginInfo info);
			public signal void extension_removed (Peas.PluginInfo info);
			public signal void hook_document (Scratch.Services.Document doc);
			public signal void hook_folder_item_change (GLib.File file, GLib.File? other_file, GLib.FileMonitorEvent event_type);
			public signal void hook_preferences_dialog (Scratch.Dialogs.Preferences dialog);
			public signal void hook_share_menu (GLib.MenuModel menu);
			public signal void hook_toolbar (Scratch.HeaderBar toolbar);
			public signal void hook_window (Scratch.MainWindow window);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class SymbolOutline : Gtk.Box {
			protected Gee.HashMap<Scratch.Services.SymbolType,GLib.SimpleAction> checks;
			protected static Scratch.Services.SymbolType[] filters;
			protected Code.Widgets.SourceList.ExpandableItem root;
			protected Gtk.SearchEntry search_entry;
			protected Gtk.CssProvider source_list_style_provider;
			protected Code.Widgets.SourceList store;
			public SymbolOutline ();
			protected bool filter_func (GLib.Object item);
			public Gtk.Widget get_widget ();
			public virtual void parse_symbols ();
			protected void schedule_refilter ();
			protected void set_up_css ();
			protected void update_style_scheme (Gtk.SourceStyleScheme style_scheme);
			public Scratch.Services.Document doc { get; construct; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class ValaSymbolItem : Code.Widgets.SourceList.ExpandableItem, Code.Widgets.SourceListSortable, Scratch.Services.SymbolItem {
			public ValaSymbolItem (Vala.Symbol symbol);
			public bool compare_symbol (Vala.Symbol comp_symbol);
			public Vala.Symbol symbol { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class ValaSymbolOutline : Scratch.Services.SymbolOutline {
			public ValaSymbolOutline (Scratch.Services.Document _doc);
			public override void parse_symbols ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public interface SymbolItem : Code.Widgets.SourceList.ExpandableItem {
			public abstract Scratch.Services.SymbolType symbol_type { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public enum DocumentStates {
			NORMAL,
			READONLY
		}
		[CCode (cheader_filename = "codecore.h")]
		public enum FileOption {
			EXISTS,
			IS_DIR,
			IS_EXECUTABLE
		}
		[CCode (cheader_filename = "codecore.h")]
		public enum SymbolType {
			CLASS,
			PROPERTY,
			SIGNAL,
			METHOD,
			STRUCT,
			ENUM,
			CONSTANT,
			CONSTRUCTOR,
			INTERFACE,
			NAMESPACE,
			OTHER;
			public unowned string to_string ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public enum VCStatus {
			NONE,
			ADDED,
			CHANGED,
			REMOVED,
			REPLACES_DELETED,
			OTHER
		}
	}
	namespace Utils {
		[CCode (cheader_filename = "codecore.h")]
		public static string? last_path;
		[CCode (cheader_filename = "codecore.h")]
		public static GLib.SimpleAction action_from_group (string action_name, GLib.SimpleActionGroup action_group);
		[CCode (cheader_filename = "codecore.h")]
		public static bool check_if_valid_text_file (string path, GLib.FileInfo info);
		[CCode (cheader_filename = "codecore.h")]
		public static GLib.Menu create_contract_items_for_file (GLib.File file);
		[CCode (cheader_filename = "codecore.h")]
		public static GLib.Menu create_executable_app_items_for_file (GLib.File file, string file_type);
		[CCode (cheader_filename = "codecore.h")]
		public static void execute_contract_with_file_path (string path, string contract_name);
		[CCode (cheader_filename = "codecore.h")]
		public static bool find_unique_path (GLib.File f1, GLib.File f2, out string? path1, out string? path2);
		[CCode (cheader_filename = "codecore.h")]
		public static string get_accel_for_action (string detailed_action_name);
		[CCode (cheader_filename = "codecore.h")]
		public static void launch_app_with_file (GLib.AppInfo app_info, GLib.File file);
		[CCode (cheader_filename = "codecore.h")]
		public static string pango_font_description_to_css (Pango.FontDescription font_descr);
		[CCode (cheader_filename = "codecore.h")]
		public static string replace_home_with_tilde (string path);
	}
	namespace Widgets {
		[CCode (cheader_filename = "codecore.h")]
		public class DocumentView : Gtk.Box {
			public enum TargetType {
				URI_LIST
			}
			public GLib.List<Scratch.Services.Document> docs;
			public bool is_closing;
			public DocumentView (Scratch.MainWindow window);
			public void close_document (Scratch.Services.Document? doc = null);
			public void close_other_tabs ();
			public void close_tabs_to_right ();
			public void duplicate_tab ();
			public new void focus ();
			public void new_document ();
			public void new_document_from_clipboard (string clipboard);
			public void next_document ();
			public void open_document (Scratch.Services.Document doc, bool focus = true, int cursor_position = 0, SelectionRange range = SelectionRange.EMPTY);
			public void previous_document ();
			public void request_placeholder_if_empty ();
			public void restore_closed_tab (string path);
			public void save_opened_files ();
			public void transfer_tab_to_new_window ();
			public void update_outline_visible ();
			public Scratch.Services.Document current_document { get; set; }
			public bool outline_visible { get; set; }
			public int outline_width { get; set; }
			public weak Scratch.MainWindow window { get; construct; }
			public signal void document_change (Scratch.Services.Document? document, Scratch.Widgets.DocumentView parent);
			public signal void request_placeholder ();
			public signal void tab_added (Scratch.Services.Document document);
			public signal void tab_removed (Scratch.Services.Document document);
		}
		[CCode (cheader_filename = "codecore.h")]
		public class SearchBar : Gtk.FlowBox {
			public Gtk.SearchEntry replace_entry;
			public Gtk.SearchEntry search_entry;
			public SearchBar (Scratch.MainWindow window);
			public void highlight_none ();
			public bool search ();
			public void search_next ();
			public void search_previous ();
			public void set_text_view (Scratch.Widgets.SourceView? text_view);
			public Gtk.SourceSearchContext? search_context { get; private set; }
			public weak Scratch.MainWindow window { get; construct; }
			public signal void search_empty ();
		}
		[CCode (cheader_filename = "codecore.h")]
		public class SourceGutterRenderer : Gtk.SourceGutterRenderer {
			public Gee.HashMap<int,Scratch.Services.VCStatus> line_status_map;
			public Gee.HashMap<Scratch.Services.VCStatus,Gdk.RGBA?> status_color_map;
			public const string ADDED_STYLE_ID;
			public const string CHANGED_STYLE_ID;
			public const string NONE_STYLE_ID;
			public const string REMOVED_STYLE_ID;
			public const string REPLACES_DELETED_STYLE_ID;
			public SourceGutterRenderer ();
			public override void draw (Cairo.Context cr, Gdk.Rectangle bg, Gdk.Rectangle area, Gtk.TextIter start, Gtk.TextIter end, Gtk.SourceGutterRendererState state);
			public void set_style_scheme (Gtk.SourceStyleScheme? scheme);
			public Scratch.FolderManager.ProjectFolderItem? project { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class SourceView : Gtk.SourceView {
			public Gtk.TextTag error_tag;
			public Gtk.CssProvider font_css_provider;
			public Gtk.SourceLanguageManager manager;
			public Gtk.SourceStyleSchemeManager style_scheme_manager;
			public Gtk.TextTag warning_tag;
			public SourceView ();
			public void change_syntax_highlight_from_file (GLib.File file);
			public void clear_selected_lines ();
			public void duplicate_selection ();
			public string get_selected_text (bool replace_new_line = true);
			public string get_text ();
			public void go_to_line (int line, int offset = 0);
			public void select_range (SelectionRange range);
			public void set_text (string text, bool opening = true);
			public void sort_selected_lines ();
			public int cursor_position { get; set; }
			public Gtk.SourceLanguage? language { get; set; }
			public GLib.File location { get; set; }
			public Scratch.FolderManager.ProjectFolderItem project { get; set; }
			public signal void deselected ();
			public signal void selection_changed (Gtk.TextIter start_iter, Gtk.TextIter end_iter);
			public signal void style_changed (Gtk.SourceStyleScheme style);
		}
	}
	[CCode (cheader_filename = "codecore.h")]
	public class Application : Gtk.Application {
		public Application ();
		protected override void activate ();
		public override int command_line (GLib.ApplicationCommandLine command_line);
		public Scratch.MainWindow? get_last_window ();
		public override int handle_local_options (GLib.VariantDict options);
		public static int main (string[] args);
		protected override void open (GLib.File[] files, string hint);
		public string data_home_folder_unsaved { get; }
		public string default_font { get; set; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class CommentToggler {
		public CommentToggler ();
		public static bool language_has_comments (Gtk.SourceLanguage? lang);
		public static void toggle_comment (Gtk.SourceBuffer? buffer);
	}
	[CCode (cheader_filename = "codecore.h")]
	public class HeaderBar : Hdy.HeaderBar {
		public Code.FormatBar format_bar;
		public GLib.Menu share_menu;
		public Gtk.MenuButton share_menu_button;
		public HeaderBar ();
		public void document_available (bool has_document);
		public void set_document_focus (Scratch.Services.Document doc);
		public Gtk.ToggleButton find_button { get; private set; }
		public Gtk.ToggleButton outline_button { get; private set; }
		public Gtk.ToggleButton sidebar_button { get; private set; }
		public Gtk.Button templates_button { get; private set; }
		public Gtk.ToggleButton terminal_button { get; private set; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class LocationJumpManager : GLib.Object {
		public LocationJumpManager ();
		public void clear ();
		public RestoreOverride create_restore_override ();
		public bool has_override_target ();
		public bool has_selection_range ();
		public bool parse_selection_range_string (string selection_range_string);
		public GLib.File file { get; set; }
		public SelectionRange range { get; set; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class MainWindow : Hdy.Window {
		public static Gee.MultiMap<string,string> action_accelerators;
		public Gtk.Clipboard clipboard;
		public Scratch.Widgets.DocumentView document_view;
		public Scratch.Widgets.SearchBar search_bar;
		public Code.Sidebar sidebar;
		public Scratch.HeaderBar toolbar;
		public const string ACTION_CLEAR_LINES;
		public const string ACTION_CLOSE_OTHER_TABS;
		public const string ACTION_CLOSE_PROJECT_DOCS;
		public const string ACTION_CLOSE_TAB;
		public const string ACTION_CLOSE_TABS_TO_RIGHT;
		public const string ACTION_COLLAPSE_ALL_FOLDERS;
		public const string ACTION_DUPLICATE;
		public const string ACTION_DUPLICATE_TAB;
		public const string ACTION_FIND;
		public const string ACTION_FIND_GLOBAL;
		public const string ACTION_FIND_NEXT;
		public const string ACTION_FIND_PREVIOUS;
		public const string ACTION_FULLSCREEN;
		public const string ACTION_GO_TO;
		public const string ACTION_GROUP;
		public const string ACTION_HIDE_PROJECT_DOCS;
		public const string ACTION_MOVE_TAB_TO_NEW_WINDOW;
		public const string ACTION_NEW_BRANCH;
		public const string ACTION_NEW_FROM_CLIPBOARD;
		public const string ACTION_NEW_TAB;
		public const string ACTION_NEXT_TAB;
		public const string ACTION_OPEN;
		public const string ACTION_OPEN_FOLDER;
		public const string ACTION_OPEN_IN_NEW_WINDOW;
		public const string ACTION_OPEN_IN_TERMINAL;
		public const string ACTION_ORDER_FOLDERS;
		public const string ACTION_PREFERENCES;
		public const string ACTION_PREFIX;
		public const string ACTION_PREVIOUS_TAB;
		public const string ACTION_QUIT;
		public const string ACTION_REDO;
		public const string ACTION_RESTORE_CLOSED_TAB;
		public const string ACTION_RESTORE_PROJECT_DOCS;
		public const string ACTION_REVERT;
		public const string ACTION_SAVE;
		public const string ACTION_SAVE_AS;
		public const string ACTION_SHOW_FIND;
		public const string ACTION_SHOW_REPLACE;
		public const string ACTION_SORT_LINES;
		public const string ACTION_TEMPLATES;
		public const string ACTION_TOGGLE_COMMENT;
		public const string ACTION_TOGGLE_OUTLINE;
		public const string ACTION_TOGGLE_SIDEBAR;
		public const string ACTION_TOGGLE_TERMINAL;
		public const string ACTION_TO_LOWER_CASE;
		public const string ACTION_TO_UPPER_CASE;
		public const string ACTION_UNDO;
		public const string ACTION_ZOOM_DEFAULT;
		public const string ACTION_ZOOM_IN;
		public const string ACTION_ZOOM_OUT;
		public const int FONT_SIZE_MAX;
		public const int FONT_SIZE_MIN;
		public MainWindow (bool restore_docs);
		public void action_zoom_in ();
		public void action_zoom_out ();
		public void close_document (Scratch.Services.Document doc);
		protected override bool delete_event (Gdk.EventAny event);
		public Scratch.Services.Document? get_current_document ();
		public string get_current_font ();
		public double get_current_font_size ();
		public string get_default_font ();
		public double get_default_font_size ();
		public Scratch.Services.Document? get_focused_document ();
		public void open_document (Scratch.Services.Document doc, bool focus = true, int cursor_position = 0);
		public void open_document_at_selected_range (Scratch.Services.Document doc, bool focus = true, SelectionRange range = SelectionRange.EMPTY, bool is_override = false);
		public void open_folder (GLib.File folder);
		public bool quit_source_func ();
		public void set_default_zoom ();
		public MainWindow.with_restore_override (bool restore_docs, RestoreOverride restore_override);
		public GLib.SimpleActionGroup actions { get; construct; }
		public Scratch.Application app { get; private set; }
		public bool restore_docs { get; construct; }
		public RestoreOverride restore_override { get; set construct; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public abstract class Template : GLib.Object {
		protected Template ();
		public static void configure_template (string origin, string destination, Gee.HashMap<string,string> variables);
		public static void enumerate_directory (GLib.File origin, Gee.TreeSet<GLib.FileInfo> files, Gee.TreeSet<GLib.File> directories);
		public abstract Gtk.Widget get_creation_box ();
		public static void info_directory (GLib.File file, out bool is_directory, out bool exists);
		public signal void loaded (GLib.File file);
	}
	[CCode (cheader_filename = "codecore.h")]
	public class TemplateManager : GLib.Object {
		public bool template_available;
		public TemplateManager ();
		public void register_template (string icon_id, string label, string description, GLib.Type template_type);
		public void show_window (Gtk.Widget? parent);
		public signal void template_loaded (Scratch.Template template, GLib.File file);
	}
	[CCode (cheader_filename = "codecore.h")]
	public class TestTemplate : Scratch.Template {
		public TestTemplate ();
		public override Gtk.Widget get_creation_box ();
	}
	[CCode (cheader_filename = "codecore.h")]
	public enum ScratchDrawSpacesState {
		NEVER,
		FOR_SELECTION,
		ALWAYS,
		CURRENT
	}
	[CCode (cheader_filename = "codecore.h")]
	public enum ScratchWindowState {
		NORMAL,
		MAXIMIZED,
		FULLSCREEN
	}
	[CCode (cheader_filename = "codecore.h")]
	public static GLib.Settings privacy_settings;
	[CCode (cheader_filename = "codecore.h")]
	public static GLib.Settings saved_state;
	[CCode (cheader_filename = "codecore.h")]
	public static GLib.Settings service_settings;
	[CCode (cheader_filename = "codecore.h")]
	public static GLib.Settings settings;
}
namespace Code {
	namespace Plugins {
		[CCode (cheader_filename = "codecore.h")]
		public class ValaSymbolResolver : Vala.SymbolResolver {
			public ValaSymbolResolver ();
			public void clear ();
			public Gee.TreeSet<weak Vala.Field> get_properties_fields ();
			public Gee.TreeSet<weak Vala.Symbol> get_symbols ();
			public override void visit_class (Vala.Class s);
			public override void visit_constant (Vala.Constant s);
			public override void visit_constructor (Vala.Constructor s);
			public override void visit_creation_method (Vala.CreationMethod s);
			public override void visit_delegate (Vala.Delegate s);
			public override void visit_destructor (Vala.Destructor s);
			public override void visit_enum (Vala.Enum s);
			public override void visit_field (Vala.Field s);
			public override void visit_interface (Vala.Interface s);
			public override void visit_method (Vala.Method s);
			public override void visit_namespace (Vala.Namespace s);
			public override void visit_property (Vala.Property s);
			public override void visit_signal (Vala.Signal s);
			public override void visit_struct (Vala.Struct s);
		}
	}
	namespace Widgets {
		[CCode (cheader_filename = "codecore.h")]
		public class CellRendererBadge : Gtk.CellRenderer {
			public CellRendererBadge ();
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public string text { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class CellRendererExpander : Gtk.CellRenderer {
			public CellRendererExpander ();
			public virtual int get_arrow_size (Gtk.Widget widget);
			public override void get_preferred_height_for_width (Gtk.Widget widget, int width, out int minimum_height, out int natural_height);
			public override void get_preferred_width (Gtk.Widget widget, out int minimum_size, out int natural_size);
			public override Gtk.SizeRequestMode get_request_mode ();
			public override void render (Cairo.Context context, Gtk.Widget widget, Gdk.Rectangle bg_area, Gdk.Rectangle cell_area, Gtk.CellRendererState flags);
			public bool is_category_expander { get; set; }
		}
		[CCode (cheader_filename = "codecore.h")]
		public class SourceList : Gtk.ScrolledWindow {
			public class ExpandableItem : Code.Widgets.SourceList.Item {
				public ExpandableItem (string name = "");
				public void add (Code.Widgets.SourceList.Item item);
				public void clear ();
				public void collapse_all (bool inclusive = true, bool recursive = true);
				public void collapse_with_parents ();
				public bool contains (Code.Widgets.SourceList.Item item);
				public void expand_all (bool inclusive = true, bool recursive = true);
				public void expand_with_parents ();
				public void remove (Code.Widgets.SourceList.Item item);
				public Gee.Collection<Code.Widgets.SourceList.Item> children { owned get; }
				public bool collapsible { get; set; }
				public bool expanded { get; set; }
				public uint n_children { get; }
				public signal void child_added (Code.Widgets.SourceList.Item item);
				public signal void child_removed (Code.Widgets.SourceList.Item item);
				public virtual signal void toggled ();
			}
			public class Item : GLib.Object {
				public Item (string name = "");
				public virtual Gtk.Menu? get_context_menu ();
				public GLib.Icon activatable { get; set; }
				public string activatable_tooltip { get; set; }
				public string badge { get; set; }
				public bool editable { get; set; }
				public GLib.Icon icon { get; set; }
				public string? markup { get; set; }
				public string name { get; set; }
				public Code.Widgets.SourceList.ExpandableItem parent { get; internal set; }
				public bool selectable { get; set; }
				public string? tooltip { get; set; }
				public bool visible { get; set; }
				public virtual signal void action_activated ();
				public virtual signal void activated ();
				public virtual signal void edited (string new_name);
			}
			public delegate bool VisibleFunc (Code.Widgets.SourceList.Item item);
			public SourceList (Code.Widgets.SourceList.ExpandableItem root = new Code.Widgets.SourceList.ExpandableItem (""));
			public void disable_drag_dest ();
			public void disable_drag_source ();
			public void enable_drag_dest (Gtk.TargetEntry[] dest_entries, Gdk.DragAction actions);
			public void enable_drag_source (Gtk.TargetEntry[] src_entries);
			public Code.Widgets.SourceList.Item? get_first_child (Code.Widgets.SourceList.ExpandableItem parent);
			public Code.Widgets.SourceList.Item? get_last_child (Code.Widgets.SourceList.ExpandableItem parent);
			public uint get_n_visible_children (Code.Widgets.SourceList.ExpandableItem parent);
			public Code.Widgets.SourceList.Item? get_next_item (Code.Widgets.SourceList.Item reference);
			public Code.Widgets.SourceList.Item? get_previous_item (Code.Widgets.SourceList.Item reference);
			public bool has_item (Code.Widgets.SourceList.Item item);
			public bool is_item_expanded (Code.Widgets.SourceList.Item item);
			public void refilter ();
			public bool scroll_to_item (Code.Widgets.SourceList.Item item, bool expand_parents = true, bool use_align = false, float row_align = 0);
			public void set_filter_func (Code.Widgets.SourceList.VisibleFunc? visible_func, bool refilter);
			public bool start_editing_item (Code.Widgets.SourceList.Item item);
			public void stop_editing ();
			public bool editing { get; }
			public Pango.EllipsizeMode ellipsize_mode { get; set; }
			public Code.Widgets.SourceList.ExpandableItem root { get; set; }
			public Code.Widgets.SourceList.Item? selected { get; set; }
			public virtual signal void item_selected (Code.Widgets.SourceList.Item? item);
		}
		[CCode (cheader_filename = "codecore.h")]
		public interface SourceListDragDest : Code.Widgets.SourceList.Item {
			public abstract bool data_drop_possible (Gdk.DragContext context, Gtk.SelectionData data);
			public abstract Gdk.DragAction data_received (Gdk.DragContext context, Gtk.SelectionData data);
		}
		[CCode (cheader_filename = "codecore.h")]
		public interface SourceListDragSource : Code.Widgets.SourceList.Item {
			public abstract bool draggable ();
			public abstract void prepare_selection_data (Gtk.SelectionData selection_data);
		}
		[CCode (cheader_filename = "codecore.h")]
		public interface SourceListSortable : Code.Widgets.SourceList.ExpandableItem {
			public abstract bool allow_dnd_sorting ();
			public abstract int compare (Code.Widgets.SourceList.Item a, Code.Widgets.SourceList.Item b);
			public signal void user_moved_item (Code.Widgets.SourceList.Item moved);
		}
	}
	[CCode (cheader_filename = "codecore.h")]
	public class ChooseProjectButton : Gtk.MenuButton {
		public class ProjectRow : Gtk.ListBoxRow {
			public ProjectRow (string project_path, Gtk.RadioButton? group_source);
			public bool active { get; set; }
			public string project_name { get; }
			public string project_path { get; construct; }
			public Gtk.RadioButton project_radio { get; construct; }
		}
		public ChooseProjectButton ();
		public weak Gtk.RadioButton? group_source { get; }
		public signal void project_chosen ();
	}
	[CCode (cheader_filename = "codecore.h")]
	public class FormatBar : Gtk.Box {
		public class FormatButton : Gtk.MenuButton {
			public FormatButton ();
			public weak GLib.Icon? icon { owned get; set; }
			public weak string text { set; }
		}
		public class LangEntry : Gtk.ListBoxRow {
			public LangEntry (string? lang_id, string lang_name, GLib.SList<Gtk.RadioButton> group);
			public unowned GLib.SList<Gtk.RadioButton> get_radio_group ();
			public bool active { get; set; }
			public weak GLib.SList<Gtk.RadioButton> group { get; construct; }
			public string? lang_id { get; construct; }
			public string lang_name { get; construct; }
			public bool selected { get; set; }
		}
		public FormatBar ();
		public void set_document (Scratch.Services.Document doc);
		public void set_insert_spaces_instead_of_tabs (bool use_spaces);
		public void set_tab_width (int indent_width);
		public Gtk.InfoBar editorconfig_infobar { get; set construct; }
		public Code.FormatBar.FormatButton line_menubutton { get; private set; }
		public Gtk.Box tab_box { get; set construct; }
		public bool tab_style_set_by_editor_config { get; set; }
		public bool tab_width_set_by_editor_config { get; set; }
		public Gtk.SpinButton width_spinbutton { get; set construct; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class Sidebar : Gtk.Grid {
		public enum TargetType {
			URI_LIST
		}
		public Sidebar ();
		public void add_tab (Code.PaneSwitcher tab);
		public void remove_tab (Code.PaneSwitcher tab);
		public Code.ChooseProjectButton choose_project_button { get; private set; }
		public Hdy.HeaderBar headerbar { get; private set; }
		public GLib.MenuModel project_menu_model { get; construct; }
		public Gtk.Stack stack { get; private set; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class Terminal : Gtk.Box {
		public const string ACTION_COPY;
		public const string ACTION_GROUP;
		public const string ACTION_PASTE;
		public const string ACTION_PREFIX;
		public Terminal ();
		public void change_location (string dir);
		public void decrement_size ();
		public void increment_size ();
		public void set_default_font_size ();
		public GLib.SimpleActionGroup actions { get; construct; }
		public Vte.Terminal terminal { get; construct; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public class WelcomeView : Granite.Widgets.Welcome {
		public WelcomeView (Scratch.MainWindow window);
		public weak Scratch.MainWindow window { get; construct; }
	}
	[CCode (cheader_filename = "codecore.h")]
	public interface PaneSwitcher : Gtk.Widget {
		public abstract string icon_name { get; set; }
		public abstract string title { get; set; }
	}
}
namespace Constants {
	[CCode (cheader_filename = "codecore.h")]
	public const string BRANCH;
	[CCode (cheader_filename = "codecore.h")]
	public const string DATADIR;
	[CCode (cheader_filename = "codecore.h")]
	public const string GETTEXT_PACKAGE;
	[CCode (cheader_filename = "codecore.h")]
	public const string INSTALL_PREFIX;
	[CCode (cheader_filename = "codecore.h")]
	public const string LOCALEDIR;
	[CCode (cheader_filename = "codecore.h")]
	public const string PLUGINDIR;
	[CCode (cheader_filename = "codecore.h")]
	public const string PROJECT_NAME;
	[CCode (cheader_filename = "codecore.h")]
	public const string VERSION;
}
[CCode (cheader_filename = "codecore.h")]
public class RestoreOverride : GLib.Object {
	public RestoreOverride (GLib.File file, SelectionRange range);
	public GLib.File file { get; construct; }
	public SelectionRange range { get; construct; }
}
[CCode (cheader_filename = "codecore.h")]
public class TemplateButton : Gtk.Button {
	public TemplateButton (string title, string description, string icon);
	public void set_icon_from_pixbuf (Gdk.Pixbuf pixbuf);
}
[CCode (cheader_filename = "codecore.h")]
public class Report : Vala.Report {
	public Report ();
	public override void depr (Vala.SourceReference? @ref, string msg);
	public override void err (Vala.SourceReference? @ref, string msg);
	public override void note (Vala.SourceReference? @ref, string msg);
	public override void warn (Vala.SourceReference? @ref, string msg);
}
[CCode (cheader_filename = "codecore.h")]
public struct SelectionRange {
	public int start_line;
	public int start_column;
	public int end_line;
	public int end_column;
	public const SelectionRange EMPTY;
}
