/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableApplicationEvent;
import org.apache.kafka.common.PartitionInfo;

public class TopicMetadataApplicationEvent
extends CompletableApplicationEvent<Map<String, List<PartitionInfo>>> {
    private final String topic;
    private final boolean allTopics;
    private final long timeoutMs;

    public TopicMetadataApplicationEvent(long timeoutMs) {
        super(ApplicationEvent.Type.TOPIC_METADATA);
        this.topic = null;
        this.allTopics = true;
        this.timeoutMs = timeoutMs;
    }

    public TopicMetadataApplicationEvent(String topic, long timeoutMs) {
        super(ApplicationEvent.Type.TOPIC_METADATA);
        this.topic = topic;
        this.allTopics = false;
        this.timeoutMs = timeoutMs;
    }

    public String topic() {
        return this.topic;
    }

    public boolean isAllTopics() {
        return this.allTopics;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " {" + this.toStringBase() + ", topic=" + this.topic + ", allTopics=" + this.allTopics + ", timeoutMs=" + this.timeoutMs + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicMetadataApplicationEvent)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TopicMetadataApplicationEvent that = (TopicMetadataApplicationEvent)o;
        return this.topic.equals(that.topic) && this.allTopics == that.allTopics && this.timeoutMs == that.timeoutMs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.topic, this.allTopics, this.timeoutMs);
    }
}

