/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.etc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import jnr.constants.Constant;
import jnr.constants.ConstantSet;
import jnr.constants.platform.Confstr;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Pathconf;
import jnr.constants.platform.Sysconf;
import jnr.posix.Group;
import jnr.posix.POSIX;
import jnr.posix.Passwd;
import jnr.posix.util.Platform;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.io.OpenFile;

@JRubyModule(name={"Etc"})
public class RubyEtc {
    private static final AtomicBoolean iteratingPasswd = new AtomicBoolean(false);

    public static RubyModule createEtcModule(ThreadContext context) {
        Object Etc = Define.defineModule(context, "Etc").defineMethods(context, RubyEtc.class);
        context.runtime.setEtc((RubyModule)Etc);
        Access.ioClass(context).defineMethods(context, IOExt.class);
        if (!Platform.IS_WINDOWS) {
            String name2;
            for (Constant c : ConstantSet.getConstantSet("Sysconf")) {
                name2 = c.name().substring(1);
                ((RubyModule)Etc).defineConstant(context, name2, Convert.asFixnum(context, c.intValue()));
            }
            for (Constant c : ConstantSet.getConstantSet("Confstr")) {
                name2 = c.name().substring(1);
                ((RubyModule)Etc).defineConstant(context, name2, Convert.asFixnum(context, c.intValue()));
            }
            for (Constant c : ConstantSet.getConstantSet("Pathconf")) {
                name2 = c.name().substring(1);
                ((RubyModule)Etc).defineConstant(context, name2, Convert.asFixnum(context, c.intValue()));
            }
        }
        RubyEtc.definePasswdStruct(context, Etc);
        RubyEtc.defineGroupStruct(context, Etc);
        return Etc;
    }

    private static void definePasswdStruct(ThreadContext context, RubyModule Etc) {
        IRubyObject[] args2 = new IRubyObject[]{context.nil, Convert.asSymbol(context, "name"), Convert.asSymbol(context, "passwd"), Convert.asSymbol(context, "uid"), Convert.asSymbol(context, "gid"), Convert.asSymbol(context, "gecos"), Convert.asSymbol(context, "dir"), Convert.asSymbol(context, "shell"), Convert.asSymbol(context, "change"), Convert.asSymbol(context, "uclass"), Convert.asSymbol(context, "expire")};
        RubyClass PasswdStruct = RubyStruct.newInstance(context, Access.structClass(context), args2, Block.NULL_BLOCK);
        context.runtime.setPasswdStruct(PasswdStruct);
        Etc.defineConstant(context, "Passwd", PasswdStruct);
    }

    private static void defineGroupStruct(ThreadContext context, RubyModule Etc) {
        IRubyObject[] args2 = new IRubyObject[]{context.nil, Convert.asSymbol(context, "name"), Convert.asSymbol(context, "passwd"), Convert.asSymbol(context, "gid"), Convert.asSymbol(context, "mem")};
        RubyClass GroupStruct = RubyStruct.newInstance(context, Access.structClass(context), args2, Block.NULL_BLOCK);
        context.runtime.setGroupStruct(GroupStruct);
        Etc.defineConstant(context, "Group", GroupStruct);
    }

    private static IRubyObject setupPasswd(ThreadContext context, Passwd passwd2) {
        IRubyObject[] args2 = new IRubyObject[]{Create.newString(context, passwd2.getLoginName()), Create.newString(context, passwd2.getPassword()), Convert.asFixnum(context, passwd2.getUID()), Convert.asFixnum(context, passwd2.getGID()), Create.newString(context, passwd2.getGECOS()), Create.newString(context, passwd2.getHome()), Create.newString(context, passwd2.getShell()), Convert.asFixnum(context, passwd2.getPasswdChangeTime()), Create.newString(context, passwd2.getAccessClass()), Convert.asFixnum(context, passwd2.getExpire())};
        return Create.newStruct(context, (RubyClass)context.runtime.getPasswdStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject setupGroup(ThreadContext context, Group group2) {
        IRubyObject[] args2 = new IRubyObject[]{Create.newString(context, group2.getName()), Create.newString(context, group2.getPassword()), Convert.asFixnum(context, group2.getGID()), RubyEtc.intoStringArray(context, group2.getMembers())};
        return Create.newStruct(context, (RubyClass)context.runtime.getGroupStruct(), args2, Block.NULL_BLOCK);
    }

    private static IRubyObject intoStringArray(ThreadContext context, String[] members2) {
        IRubyObject[] arr = new IRubyObject[members2.length];
        for (int i2 = 0; i2 < arr.length; ++i2) {
            arr[i2] = Create.newString(context, members2[i2]);
        }
        return RubyArray.newArrayMayCopy(context.runtime, arr);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject sysconf(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Sysconf name2 = Sysconf.valueOf(Convert.toLong(context, arg2));
        POSIX posix = context.runtime.getPosix();
        posix.errno(0);
        long ret = posix.sysconf(name2);
        if (ret == -1L) {
            int errno2 = posix.errno();
            if (errno2 == Errno.ENOENT.intValue() || errno2 == 0) {
                return context.nil;
            }
            if (errno2 == Errno.EOPNOTSUPP.intValue()) {
                throw Error.notImplementedError(context, "sysconf() function is unimplemented on this machine");
            }
            throw context.runtime.newErrnoFromLastPOSIXErrno();
        }
        return Convert.asFixnum(context, ret);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject confstr(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        ByteBuffer buf;
        Confstr name2 = Confstr.valueOf(Convert.toLong(context, arg2));
        POSIX posix = context.runtime.getPosix();
        int n = posix.confstr(name2, null, 0);
        int ret = -1;
        if (n > 0) {
            buf = ByteBuffer.allocate(n);
            ret = posix.confstr(name2, buf, n);
        } else {
            buf = ByteBuffer.allocate(0);
        }
        if (ret == -1) {
            if (posix.errno() == 0) {
                return context.nil;
            }
            if (posix.errno() == Errno.EOPNOTSUPP.intValue()) {
                throw context.runtime.newNotImplementedError("confstr() function is unimplemented on this machine");
            }
            throw context.runtime.newErrnoFromLastPOSIXErrno();
        }
        buf.flip();
        return Create.newString(context, new ByteList(buf.array(), 0, n - 1));
    }

    @Deprecated
    public static synchronized IRubyObject getpwuid(IRubyObject recv2, IRubyObject[] args2) {
        return RubyEtc.getpwuid(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(optional=1, checkArity=false, module=true)
    public static synchronized IRubyObject getpwuid(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 0, 1);
        POSIX posix = context.runtime.getPosix();
        GlobalVariables globalVariables = Access.globalVariables(context);
        IRubyObject oldExc = globalVariables.get("$!");
        try {
            int uid2 = args2.length == 0 ? posix.getuid() : Convert.toInt(context, args2[0]);
            Passwd pwd = posix.getpwuid(uid2);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return context.nil;
                }
                throw Error.argumentError(context, "can't find user for " + uid2);
            }
            return RubyEtc.setupPasswd(context, pwd);
        }
        catch (RaiseException re) {
            if (context.runtime.getNotImplementedError().isInstance(re.getException())) {
                globalVariables.set("$!", oldExc);
                return context.nil;
            }
            throw re;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getpwuid is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject getpwnam(IRubyObject recv2, IRubyObject name2) {
        return RubyEtc.getpwnam(((RubyBasicObject)recv2).getCurrentContext(), recv2, name2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getpwnam(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        String nam = name2.convertToString().toString();
        try {
            Passwd pwd = context.runtime.getPosix().getpwnam(nam);
            if (pwd == null) {
                if (Platform.IS_WINDOWS) {
                    return context.nil;
                }
                throw Error.argumentError(context, "can't find user for " + nam);
            }
            return RubyEtc.setupPasswd(context, pwd);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getpwnam is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject passwd(IRubyObject recv2, Block block) {
        return RubyEtc.passwd(((RubyBasicObject)recv2).getCurrentContext(), recv2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject passwd(ThreadContext context, IRubyObject recv2, Block block) {
        POSIX posix = context.runtime.getPosix();
        try {
            Passwd pw;
            posix.getpwent();
            if (block.isGiven()) {
                if (!iteratingPasswd.compareAndSet(false, true)) {
                    throw Error.runtimeError(context, "parallel passwd iteration");
                }
                posix.setpwent();
                try {
                    while ((pw = posix.getpwent()) != null) {
                        block.yield(context, RubyEtc.setupPasswd(context, pw));
                    }
                }
                finally {
                    posix.endpwent();
                    iteratingPasswd.set(false);
                }
            }
            return (pw = posix.getpwent()) != null ? RubyEtc.setupPasswd(context, pw) : context.nil;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.passwd is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject getlogin(IRubyObject recv2) {
        return RubyEtc.getlogin(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getlogin(ThreadContext context, IRubyObject recv2) {
        try {
            String login = context.runtime.getPosix().getlogin();
            if (login != null) {
                return Create.newString(context, login);
            }
            login = System.getenv("USER");
            if (login != null) {
                return Create.newString(context, login);
            }
            return context.nil;
        }
        catch (Exception e) {
            return Create.newString(context, System.getProperty("user.name"));
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject endpwent(IRubyObject recv2) {
        return RubyEtc.endpwent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject endpwent(ThreadContext context, IRubyObject recv2) {
        block2: {
            try {
                context.runtime.getPosix().endpwent();
            }
            catch (Exception e) {
                if (!context.runtime.getDebug().isTrue()) break block2;
                Warn.warn(context, "Etc.endpwent is not supported by JRuby on this platform");
            }
        }
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject setpwent(IRubyObject recv2) {
        return RubyEtc.setpwent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject setpwent(ThreadContext context, IRubyObject recv2) {
        block2: {
            try {
                context.runtime.getPosix().setpwent();
            }
            catch (Exception e) {
                if (!context.runtime.getDebug().isTrue()) break block2;
                Warn.warn(context, "Etc.setpwent is not supported by JRuby on this platform");
            }
        }
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject getpwent(IRubyObject recv2) {
        return RubyEtc.getpwent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getpwent(ThreadContext context, IRubyObject recv2) {
        try {
            Passwd passwd2 = context.runtime.getPosix().getpwent();
            return passwd2 != null ? RubyEtc.setupPasswd(context, passwd2) : context.nil;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getpwent is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject getgrnam(IRubyObject recv2, IRubyObject name2) {
        return RubyEtc.getgrnam(((RubyBasicObject)recv2).getCurrentContext(), recv2, name2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject getgrnam(ThreadContext context, IRubyObject recv2, IRubyObject name2) {
        String nam = name2.convertToString().toString();
        try {
            Group grp = context.runtime.getPosix().getgrnam(nam);
            if (grp == null) {
                if (Platform.IS_WINDOWS) {
                    return context.nil;
                }
                throw Error.argumentError(context, "can't find group for " + nam);
            }
            return RubyEtc.setupGroup(context, grp);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getgrnam is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated
    public static synchronized IRubyObject getgrgid(IRubyObject recv2, IRubyObject[] args2) {
        return RubyEtc.getgrgid(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2);
    }

    @JRubyMethod(optional=1, checkArity=false, module=true)
    public static synchronized IRubyObject getgrgid(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 0, 1);
        POSIX posix = context.runtime.getPosix();
        try {
            int gid2 = argc == 0 ? posix.getgid() : Convert.toInt(context, args2[0]);
            Group gr = posix.getgrgid(gid2);
            if (gr == null) {
                if (Platform.IS_WINDOWS) {
                    return context.nil;
                }
                throw Error.argumentError(context, "can't find group for " + gid2);
            }
            return RubyEtc.setupGroup(context, gr);
        }
        catch (RaiseException re) {
            throw re;
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getgrgid is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject endgrent(IRubyObject recv2) {
        return RubyEtc.endgrent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject endgrent(ThreadContext context, IRubyObject recv2) {
        block2: {
            try {
                context.runtime.getPosix().endgrent();
            }
            catch (Exception e) {
                if (!context.runtime.getDebug().isTrue()) break block2;
                Warn.warn(context, "Etc.engrent is not supported by JRuby on this platform");
            }
        }
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject setgrent(IRubyObject recv2) {
        return RubyEtc.setgrent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject setgrent(ThreadContext context, IRubyObject recv2) {
        block2: {
            try {
                context.runtime.getPosix().setgrent();
            }
            catch (Exception e) {
                if (!context.runtime.getDebug().isTrue()) break block2;
                Warn.warn(context, "Etc.setgrent is not supported by JRuby on this platform");
            }
        }
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject group(IRubyObject recv2, Block block) {
        return RubyEtc.group(((RubyBasicObject)recv2).getCurrentContext(), recv2, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject group(ThreadContext context, IRubyObject recv2, Block block) {
        POSIX posix;
        block9: {
            posix = context.runtime.getPosix();
            try {
                posix.getgrent();
            }
            catch (Exception e) {
                if (!context.runtime.getDebug().isTrue()) break block9;
                Warn.warn(context, "Etc.group is not supported by JRuby on this platform");
            }
        }
        if (block.isGiven()) {
            Boolean blocking2 = (Boolean)recv2.getInternalVariables().getInternalVariable("group_blocking");
            if (blocking2 != null && blocking2.booleanValue()) {
                throw Error.runtimeError(context, "parallel group iteration");
            }
            try {
                Group gr;
                recv2.getInternalVariables().setInternalVariable("group_blocking", true);
                posix.setgrent();
                while ((gr = posix.getgrent()) != null) {
                    block.yield(context, RubyEtc.setupGroup(context, gr));
                }
            }
            finally {
                posix.endgrent();
                recv2.getInternalVariables().setInternalVariable("group_blocking", false);
            }
        } else {
            Group gr = posix.getgrent();
            return gr != null ? RubyEtc.setupGroup(context, gr) : context.nil;
        }
        return context.nil;
    }

    @Deprecated(since="10.0")
    public static synchronized IRubyObject getgrent(IRubyObject recv2) {
        return RubyEtc.getgrent(((RubyBasicObject)recv2).getCurrentContext(), recv2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static synchronized IRubyObject getgrent(ThreadContext context, IRubyObject recv2) {
        try {
            Class<RubyEtc> clazz = RubyEtc.class;
            synchronized (RubyEtc.class) {
                Group gr = context.runtime.getPosix().getgrent();
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return gr != null ? RubyEtc.setupGroup(context, gr) : context.nil;
            }
        }
        catch (Exception e) {
            if (context.runtime.getDebug().isTrue()) {
                Warn.warn(context, "Etc.getgrent is not supported by JRuby on this platform");
            }
            return context.nil;
        }
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject systmpdir(ThreadContext context, IRubyObject recv2) {
        String commonAppData;
        ByteList tmp = ByteList.create(System.getProperty("java.io.tmpdir"));
        if (Platform.IS_WINDOWS && (commonAppData = System.getenv("CSIDL_COMMON_APPDATA")) != null) {
            tmp = ByteList.create(commonAppData);
        }
        return Create.newString(context, tmp, context.runtime.getDefaultExternalEncoding());
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject sysconfdir(ThreadContext context, IRubyObject recv2) {
        String localAppData;
        Ruby runtime2 = context.getRuntime();
        ByteList tmp = ByteList.create(RbConfigLibrary.getSysConfDir(runtime2));
        if (Platform.IS_WINDOWS && (localAppData = System.getenv("CSIDL_LOCAL_APPDATA")) != null) {
            tmp = ByteList.create(localAppData);
        }
        RubyString ret = RubyString.newString(runtime2, tmp, runtime2.getDefaultExternalEncoding());
        return ret;
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject nprocessors(ThreadContext context, IRubyObject recv2) {
        int nprocs = Runtime.getRuntime().availableProcessors();
        return Convert.asFixnum(context, nprocs);
    }

    @JRubyMethod(module=true)
    public static synchronized IRubyObject uname(ThreadContext context, IRubyObject self2) {
        RubyHash uname2 = Create.newHash(context);
        uname2.op_aset(context, Convert.asSymbol(context, "sysname"), Create.newString(context, SafePropertyAccessor.getProperty("os.name", "unknown")));
        try {
            uname2.op_aset(context, Convert.asSymbol(context, "nodename"), Create.newString(context, InetAddress.getLocalHost().getHostName()));
        }
        catch (UnknownHostException uhe) {
            uname2.op_aset(context, Convert.asSymbol(context, "nodename"), Create.newString(context, "unknown"));
        }
        uname2.put(Convert.asSymbol(context, "release"), Create.newString(context, "unknown"));
        uname2.put(Convert.asSymbol(context, "version"), Create.newString(context, SafePropertyAccessor.getProperty("os.version")));
        uname2.put(Convert.asSymbol(context, "machine"), Create.newString(context, SafePropertyAccessor.getProperty("os.arch")));
        return uname2;
    }

    public static class IOExt {
        @JRubyMethod
        public static synchronized IRubyObject pathconf(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
            Pathconf name2 = Pathconf.valueOf(Convert.toLong(context, arg2));
            RubyIO io2 = (RubyIO)recv2;
            OpenFile fptr = io2.getOpenFileChecked();
            POSIX posix = context.runtime.getPosix();
            long ret = posix.fpathconf(fptr.getFileno(), name2);
            if (ret == -1L) {
                if (posix.errno() == 0) {
                    return context.nil;
                }
                if (posix.errno() == Errno.EOPNOTSUPP.intValue()) {
                    throw context.runtime.newNotImplementedError("pathconf() function is unimplemented on this machine");
                }
                throw context.runtime.newErrnoFromLastPOSIXErrno();
            }
            return Convert.asFixnum(context, ret);
        }
    }
}

