/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.datum;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileSource;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformVisitor;
import org.openstreetmap.josm.tools.Utils;

public final class NTV2Proj4DirGridShiftFileSource
implements NTV2GridShiftFileSource,
PlatformVisitor<List<File>> {
    private NTV2Proj4DirGridShiftFileSource() {
    }

    public static NTV2Proj4DirGridShiftFileSource getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @Override
    public InputStream getNTV2GridShiftFile(String gridFileName) {
        File file2;
        File dir2;
        String projLib;
        File grid = Platform.determinePlatform().accept(this).stream().map(dir -> new File((File)dir, gridFileName)).filter(file -> file.exists() && file.isFile()).findFirst().orElse(null);
        if (grid == null && !Utils.isEmpty(projLib = Utils.getSystemProperty("PROJ_LIB")) && (dir2 = new File(projLib)).exists() && dir2.isDirectory() && (file2 = new File(dir2, gridFileName)).exists() && file2.isFile()) {
            grid = file2;
        }
        if (grid != null) {
            try {
                return Files.newInputStream(grid.getAbsoluteFile().toPath(), new OpenOption[0]);
            }
            catch (IOException | InvalidPathException ex) {
                Logging.warn("Unable to open NTV2 grid shift file: " + grid);
                Logging.debug(ex);
            }
        }
        return null;
    }

    private static List<File> visit(String prefSuffix, String ... defaults) {
        return Config.getPref().getList("ntv2.proj4.grid.dir." + prefSuffix, Arrays.asList(defaults)).stream().map(File::new).collect(Collectors.toList());
    }

    @Override
    public List<File> visitUnixoid() {
        return NTV2Proj4DirGridShiftFileSource.visit("unix", "/usr/local/share/proj", "/usr/share/proj");
    }

    @Override
    public List<File> visitWindows() {
        return NTV2Proj4DirGridShiftFileSource.visit("windows", "C:\\PROJ\\NAD");
    }

    @Override
    public List<File> visitOsx() {
        return Collections.emptyList();
    }

    private static final class InstanceHolder {
        static final NTV2Proj4DirGridShiftFileSource INSTANCE = new NTV2Proj4DirGridShiftFileSource();

        private InstanceHolder() {
        }
    }
}

