/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.awt.Color;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.util.TextUtils;
import org.freeplane.n3.nanoxml.XMLElement;

public class ColorUtils {
    public static final int NON_TRANSPARENT_ALPHA = 255;
    public static final String BLACK = "#000000";

    public static String colorToString(Color col) {
        if (col == null) {
            return null;
        }
        return String.format("#%02x%02x%02x", col.getRed(), col.getGreen(), col.getBlue());
    }

    public static String colorToRGBPercentString(Color col) {
        if (col == null) {
            return null;
        }
        int alpha = col.getAlpha();
        if (alpha == 255) {
            return String.format("#%02x%02x%02x", col.getRed(), col.getGreen(), col.getBlue());
        }
        if (alpha == 0) {
            return TextUtils.getText("transparent");
        }
        return String.format("#%02x%02x%02x, %2d%%", col.getRed(), col.getGreen(), col.getBlue(), alpha * 100 / 255);
    }

    public static String colorToRGBAString(Color col) {
        if (col == null) {
            return null;
        }
        return String.format("#%02x%02x%02x%02x", col.getRed(), col.getGreen(), col.getBlue(), col.getAlpha());
    }

    public static Color rgbStringToColor(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() != 7 || str.charAt(0) != '#') {
            throw new NumberFormatException("wrong color format in " + str + ". Expecting #rrggbb");
        }
        int r = Integer.parseInt(str.substring(1, 3), 16);
        int g = Integer.parseInt(str.substring(3, 5), 16);
        int b = Integer.parseInt(str.substring(5, 7), 16);
        return new Color(r, g, b);
    }

    public static Color stringToColor(String str) {
        if (str == null || str.equals("none")) {
            return null;
        }
        if (str.length() == 7) {
            return ColorUtils.rgbStringToColor(str);
        }
        if (str.length() != 9 || str.charAt(0) != '#') {
            throw new NumberFormatException("wrong color format in " + str + ". Expecting #aarrggbb");
        }
        int r = Integer.parseInt(str.substring(1, 3), 16);
        int g = Integer.parseInt(str.substring(3, 5), 16);
        int b = Integer.parseInt(str.substring(5, 7), 16);
        int a = Integer.parseInt(str.substring(7, 9), 16);
        return new Color(r, g, b, a);
    }

    public static Color stringToColor(String str, Color opacityHolder) {
        Color rgb = ColorUtils.stringToColor(str);
        if (opacityHolder == null || ColorUtils.isNonTransparent(opacityHolder) || rgb == null) {
            return rgb;
        }
        return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), opacityHolder.getAlpha());
    }

    public static boolean isNonTransparent(Color opacityHolder) {
        boolean isNonTransparent = opacityHolder.getAlpha() == 255;
        return isNonTransparent;
    }

    public static Color alphaToColor(String value, Color color) {
        return ColorUtils.alphaToColor(Integer.parseInt(value), color);
    }

    public static Color alphaToColor(int opacity, Color rgbHolder) {
        if (rgbHolder == null) {
            return new Color(0, 0, 0, opacity);
        }
        if (rgbHolder.getAlpha() == opacity) {
            return rgbHolder;
        }
        return new Color(rgbHolder.getRed(), rgbHolder.getGreen(), rgbHolder.getBlue(), opacity);
    }

    public static void setColorAttributes(XMLElement element, String colorAttribute, String opacityAttribite, Color color) {
        element.setAttribute(colorAttribute, ColorUtils.colorToString(color));
        if (!ColorUtils.isNonTransparent(color)) {
            element.setAttribute(opacityAttribite, Integer.toString(color.getAlpha()));
        }
    }

    public static void addColorAttributes(ITreeWriter writer, String colorAttribute, String opacityAttribite, Color color) {
        writer.addAttribute(colorAttribute, ColorUtils.colorToString(color));
        if (!ColorUtils.isNonTransparent(color)) {
            writer.addAttribute(opacityAttribite, Integer.toString(color.getAlpha()));
        }
    }

    public static Color makeNonTransparent(Color color) {
        return ColorUtils.makeNonTransparent(color, Color.WHITE);
    }

    public static Color makeNonTransparent(Color color, Color background) {
        if (color == null) {
            return null;
        }
        if (ColorUtils.isNonTransparent(color)) {
            return color;
        }
        int r1 = color.getRed();
        int g1 = color.getGreen();
        int b1 = color.getBlue();
        int a1 = color.getAlpha();
        int r2 = background.getRed();
        int g2 = background.getGreen();
        int b2 = background.getBlue();
        int r3 = r2 + (r1 - r2) * a1 / 255;
        int g3 = g2 + (g1 - g2) * a1 / 255;
        int b3 = b2 + (b1 - b2) * a1 / 255;
        return new Color(r3, g3, b3);
    }

    public static boolean isDark(Color color) {
        int b;
        int g;
        int r = color.getRed();
        double brightness = 0.299 * (double)(r * r) + 0.587 * (double)((g = color.getGreen()) * g) + 0.114 * (double)((b = color.getBlue()) * b);
        boolean isDark = brightness < 16384.0;
        return isDark;
    }
}

