/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.presentations.mindmapmode;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.JAutoScrollBarPane;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.map.IMapSelectionListener;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.presentations.mindmapmode.CollectionChangeListener;
import org.freeplane.features.presentations.mindmapmode.CollectionChangedEvent;
import org.freeplane.features.presentations.mindmapmode.EscapeKeyEventDispatcher;
import org.freeplane.features.presentations.mindmapmode.MapPresentations;
import org.freeplane.features.presentations.mindmapmode.NamedElementFactory;
import org.freeplane.features.presentations.mindmapmode.NavigationKeyEventDispatcher;
import org.freeplane.features.presentations.mindmapmode.Presentation;
import org.freeplane.features.presentations.mindmapmode.PresentationAutomation;
import org.freeplane.features.presentations.mindmapmode.PresentationBuilder;
import org.freeplane.features.presentations.mindmapmode.PresentationEditorController;
import org.freeplane.features.presentations.mindmapmode.PresentationKeyEventDispatcher;
import org.freeplane.features.presentations.mindmapmode.PresentationPngExporter;
import org.freeplane.features.presentations.mindmapmode.PresentationState;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeEvent;
import org.freeplane.features.presentations.mindmapmode.PresentationStateChangeListener;
import org.freeplane.features.presentations.mindmapmode.Slide;
import org.freeplane.features.presentations.mindmapmode.SlideChangeEvent;
import org.freeplane.features.presentations.mindmapmode.SlideChangeListener;

public class PresentationController
implements IExtension {
    private static final float FOLDED_NODE_DOT_WIDTH = 3.0f * UITools.FONT_SCALE_FACTOR;
    private static final Color NODE_HIGHLIGHTING_COLOR = Color.GREEN.brighter();
    static final String PROCESS_NAVIGATION_KEYS_PROPERTY = "presentation.processesNavigationKeys";
    static final String PROCESS_ESCAPE_KEY_PROPERTY = "presentation.processesEscapeKey";
    private static float[] FOLDED_NODE_DASH = new float[]{FOLDED_NODE_DOT_WIDTH / 2.0f, 2.0f * FOLDED_NODE_DOT_WIDTH};
    private static BasicStroke FOLDED_NODE_STROKE = new BasicStroke(FOLDED_NODE_DOT_WIDTH, 1, 0, 1.0f, FOLDED_NODE_DASH, 0.0f);
    private static BasicStroke ROOT_NODE_STROKE = new BasicStroke(FOLDED_NODE_DOT_WIDTH * 2.0f);
    private final PresentationState presentationState;
    private final PresentationEditorController presentationEditorController;
    ModeController modeController;

    public static void install(ModeController modeController) {
        PresentationController presentationController = new PresentationController(modeController);
        modeController.addExtension(PresentationController.class, (IExtension)presentationController);
        presentationController.registerActions();
        presentationController.addMapSelectionListener();
        new PresentationBuilder().register(modeController.getMapController(), presentationController);
        HighlightController highlightController = (HighlightController)modeController.getController().getExtension(HighlightController.class);
        final PresentationState presentationState = presentationController.presentationState;
        new PresentationPngExporter.ActionInstaller().installActions(modeController, presentationState);
        JTabbedPane tabs = UITools.getFreeplaneTabbedPanel();
        tabs.add(TextUtils.getText((String)"presentation_panel"), presentationController.createPanel());
        highlightController.addNodeHighlighter(new NodeHighlighter(){

            public boolean isNodeHighlighted(NodeModel node, boolean isPrinting) {
                return !isPrinting && presentationState.shouldHighlightNodeContainedOnSlide(node);
            }

            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(NODE_HIGHLIGHTING_COLOR);
                if (presentationState.isSlideRoot(node)) {
                    g.setStroke(ROOT_NODE_STROKE);
                }
            }
        });
        highlightController.addNodeHighlighter(new NodeHighlighter(){

            public boolean isNodeHighlighted(NodeModel node, boolean isPrinting) {
                return !isPrinting && presentationState.shouldHighlightNodeFoldedOnSlide(node);
            }

            public void configure(NodeModel node, Graphics2D g, boolean isPrinting) {
                g.setColor(NODE_HIGHLIGHTING_COLOR);
                g.setStroke(FOLDED_NODE_STROKE);
            }
        });
        NavigationKeyEventDispatcher navigationKeyEventDispatcher = new NavigationKeyEventDispatcher(presentationState);
        EscapeKeyEventDispatcher escapeKeyEventDispatcher = new EscapeKeyEventDispatcher(presentationState);
        PresentationAutomation presentationKeyHandler = new PresentationAutomation(presentationState, PresentationKeyEventDispatcher.of(navigationKeyEventDispatcher, PROCESS_NAVIGATION_KEYS_PROPERTY), PresentationKeyEventDispatcher.of(escapeKeyEventDispatcher, PROCESS_ESCAPE_KEY_PROPERTY));
        presentationState.addPresentationStateListener(presentationKeyHandler);
    }

    private void registerActions() {
        this.presentationEditorController.registerActions(this.modeController);
    }

    private PresentationController(ModeController modeController) {
        this.modeController = modeController;
        this.presentationState = new PresentationState();
        ResourceController resourceController = ResourceController.getResourceController();
        boolean combinesAllPresentations = resourceController.getBooleanProperty("presentation.combineAll");
        resourceController.addPropertyChangeListener(new IFreeplanePropertyListener(){

            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if ("presentation.combineAll".equals(propertyName)) {
                    PresentationController.this.presentationState.setCombinesAllPresentations(Boolean.parseBoolean(newValue));
                }
            }
        });
        this.presentationState.setCombinesAllPresentations(combinesAllPresentations);
        this.presentationEditorController = new PresentationEditorController(this.presentationState);
        this.presentationState.addPresentationStateListener(new PresentationStateChangeListener(){

            @Override
            public void onPresentationStateChange(PresentationStateChangeEvent presentationStateChangeEvent) {
                PresentationController.this.repaintMap();
            }
        });
    }

    private void addMapSelectionListener() {
        IMapSelectionListener mapSelectionListener = new IMapSelectionListener(){

            public void beforeMapChange(MapModel oldMap, MapModel newMap) {
                PresentationController.this.presentationState.stopPresentation();
            }

            public void afterMapChange(MapModel oldMap, MapModel newMap) {
                if (newMap != null && Controller.getCurrentModeController() == PresentationController.this.modeController) {
                    PresentationController.this.presentationEditorController.setPresentations(PresentationController.this.getPresentations((MapModel)newMap).presentations);
                } else {
                    PresentationController.this.presentationEditorController.setPresentations(null);
                }
            }
        };
        this.modeController.getController().getMapViewManager().addMapSelectionListener(mapSelectionListener);
    }

    public MapPresentations getPresentations(final MapModel map) {
        NodeModel rootNode = map.getRootNode();
        MapPresentations mapPresentations = (MapPresentations)rootNode.getExtension(MapPresentations.class);
        if (mapPresentations == null) {
            mapPresentations = new MapPresentations(this.getPresentationFactory(map));
            CollectionChangeListener<Presentation> presentationCollectionChangeListener = new CollectionChangeListener<Presentation>(){

                @Override
                public void onCollectionChange(CollectionChangedEvent<Presentation> event) {
                    if (event.eventType == CollectionChangedEvent.EventType.COLLECTION_SIZE_CHANGED) {
                        PresentationController.this.modeController.getMapController().mapSaved(map, false);
                    }
                }
            };
            mapPresentations.presentations.addCollectionChangeListener(presentationCollectionChangeListener);
            rootNode.addExtension((IExtension)mapPresentations);
        }
        return mapPresentations;
    }

    NamedElementFactory<Presentation> getPresentationFactory(final MapModel map) {
        final NamedElementFactory<Slide> slideFactory = this.getSlideFactory(map);
        final CollectionChangeListener<Slide> slideCollectionChangeListener = new CollectionChangeListener<Slide>(){

            @Override
            public void onCollectionChange(CollectionChangedEvent<Slide> event) {
                if (event.eventType == CollectionChangedEvent.EventType.COLLECTION_SIZE_CHANGED) {
                    PresentationController.this.modeController.getMapController().mapSaved(map, false);
                } else if (event.eventType == CollectionChangedEvent.EventType.SELECTION_CHANGED) {
                    PresentationController.this.presentationState.changeSlide();
                }
            }
        };
        NamedElementFactory<Presentation> presentationFactory = new NamedElementFactory<Presentation>(){

            @Override
            public Presentation create(Presentation prototype, String newName) {
                Presentation presentation = prototype.create(newName);
                presentation.slides.addCollectionChangeListener(slideCollectionChangeListener);
                return presentation;
            }

            @Override
            public Presentation create(String name) {
                Presentation presentation = new Presentation(name, slideFactory);
                presentation.slides.addCollectionChangeListener(slideCollectionChangeListener);
                return presentation;
            }
        };
        return presentationFactory;
    }

    NamedElementFactory<Slide> getSlideFactory(final MapModel map) {
        NamedElementFactory<Slide> slideFactory = new NamedElementFactory<Slide>(){
            final SlideChangeListener slideChangeListener = new SlideChangeListener(){

                @Override
                public void onSlideModelChange(SlideChangeEvent changeEvent) {
                    PresentationController.this.modeController.getMapController().mapSaved(map, false);
                    PresentationController.this.presentationState.changeSlide();
                }
            };

            @Override
            public Slide create(Slide prototype, String newName) {
                Slide slide = prototype.create(newName);
                slide.addSlideChangeListener(this.slideChangeListener);
                return slide;
            }

            @Override
            public Slide create(String name) {
                Slide slide = new Slide(name);
                slide.addSlideChangeListener(this.slideChangeListener);
                return slide;
            }
        };
        return slideFactory;
    }

    private Component createPanel() {
        Component presentationEditor = this.presentationEditorController.createPanel(this.modeController);
        presentationEditor.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if (0L != (e.getChangeFlags() & 4L)) {
                    PresentationController.this.presentationState.setHighlightsNodes(e.getComponent().isShowing());
                }
            }
        });
        JAutoScrollBarPane scrollPane = new JAutoScrollBarPane(presentationEditor);
        UITools.setScrollbarIncrement((JScrollPane)scrollPane);
        return scrollPane;
    }

    private void repaintMap() {
        JComponent mapViewComponent = Controller.getCurrentController().getMapViewManager().getMapViewComponent();
        if (mapViewComponent != null) {
            mapViewComponent.repaint();
        }
    }
}

