/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.dependencies;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.ClassNode;
import org.freeplane.plugin.codeexplorer.map.CodeNode;

public class CodeDependency {
    private static final Pattern ARRAYS = Pattern.compile("\\[+L?([\\w$]+);?");
    private static final Pattern PACKAGES = Pattern.compile("(?<=\\b|\\[L)(?:[a-z0-9_]+\\.)+");
    private final Dependency dependency;
    private final boolean goesUp;
    private final DependencyVerdict dependencyVerdict;

    public CodeDependency(Dependency dependendy, boolean goesUp, DependencyVerdict dependencyVerdict) {
        this.dependency = dependendy;
        this.goesUp = goesUp;
        this.dependencyVerdict = dependencyVerdict;
    }

    public JavaClass getOriginClass() {
        return this.dependency.getOriginClass();
    }

    public JavaClass getTargetClass() {
        return this.dependency.getTargetClass();
    }

    public DependencyVerdict dependencyVerdict() {
        return this.dependencyVerdict;
    }

    public boolean goesUp() {
        return this.goesUp;
    }

    public Dependency getDependency() {
        return this.dependency;
    }

    public String getDescription() {
        JavaClass originClass = this.getOriginClass();
        JavaClass targetClass = this.getTargetClass();
        JavaClass namedOrigin = CodeNode.findEnclosingNamedClass(originClass);
        JavaClass namedTarget = CodeNode.findEnclosingNamedClass(targetClass);
        String description = this.dependency.getDescription().replace(namedOrigin.getName(), ClassNode.getSimpleName(namedOrigin)).replace(namedTarget.getName(), ClassNode.getSimpleName(namedTarget));
        Matcher packagesMatcher = PACKAGES.matcher(description);
        description = packagesMatcher.replaceAll("");
        Matcher arraysMatcher = ARRAYS.matcher(description);
        StringBuffer result = new StringBuffer();
        while (arraysMatcher.find()) {
            arraysMatcher.appendReplacement(result, Matcher.quoteReplacement(CodeDependency.convertArrayDescriptor(arraysMatcher.group())));
        }
        arraysMatcher.appendTail(result);
        description = result.toString().replace('$', '.');
        return description;
    }

    public String describeVerdict() {
        return this.dependencyVerdict.name().toLowerCase() + " (goes " + (this.goesUp ? "up" : "down") + ")";
    }

    private static String convertArrayDescriptor(String descriptor) {
        int arrayDepth = 0;
        for (char ch : descriptor.toCharArray()) {
            String type;
            if (ch == '[') {
                ++arrayDepth;
                continue;
            }
            switch (ch) {
                case 'B': {
                    type = "byte";
                    break;
                }
                case 'C': {
                    type = "char";
                    break;
                }
                case 'D': {
                    type = "double";
                    break;
                }
                case 'F': {
                    type = "float";
                    break;
                }
                case 'I': {
                    type = "int";
                    break;
                }
                case 'J': {
                    type = "long";
                    break;
                }
                case 'S': {
                    type = "short";
                    break;
                }
                case 'Z': {
                    type = "boolean";
                    break;
                }
                case 'L': {
                    type = descriptor.substring(arrayDepth + 1, descriptor.length() - 1);
                    break;
                }
                default: {
                    return descriptor;
                }
            }
            StringBuilder replacement = new StringBuilder(type);
            for (int i = 0; i < arrayDepth; ++i) {
                replacement.append("[]");
            }
            return replacement.toString();
        }
        return descriptor;
    }

    public String toString() {
        return "CodeDependency [dependency=" + this.dependency + ", goesUp=" + this.goesUp + "]";
    }

    public int hashCode() {
        return this.dependency.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeDependency other = (CodeDependency)obj;
        return Objects.equals(this.dependency, other.dependency);
    }
}

