"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.media = exports.QUERY = exports.QueryKeys = void 0;
const sizes_1 = require("./Layout/sizes");
var QueryKeys;
(function (QueryKeys) {
    QueryKeys["DESKTOP"] = "desktop";
    QueryKeys["DESKTOP_XL"] = "desktopXL";
    QueryKeys["MOBILE"] = "mobile";
    QueryKeys["MOBILE_DOWN"] = "mobileDown";
    QueryKeys["MOBILE_UP"] = "mobileUp";
    QueryKeys["TABLET"] = "tablet";
    QueryKeys["TABLET_DOWN"] = "tabletDown";
    QueryKeys["TABLET_UP"] = "tabletUp";
})(QueryKeys = exports.QueryKeys || (exports.QueryKeys = {}));
exports.QUERY = {
    [QueryKeys.DESKTOP]: `min-width: ${sizes_1.WIDTH.DESKTOP_MIN}px`,
    [QueryKeys.DESKTOP_XL]: `min-width: ${sizes_1.WIDTH.DESKTOP_XL_MIN}px`,
    [QueryKeys.MOBILE]: `max-width: ${sizes_1.WIDTH.MOBILE_MAX}px`,
    [QueryKeys.MOBILE_DOWN]: `max-width: ${sizes_1.WIDTH.MOBILE_MAX}px`,
    [QueryKeys.MOBILE_UP]: `min-width: ${sizes_1.WIDTH.MOBILE}px`,
    [QueryKeys.TABLET]: `min-width: ${sizes_1.WIDTH.TABLET_MIN}px) and (max-width: ${sizes_1.WIDTH.TABLET_MAX}px`,
    [QueryKeys.TABLET_DOWN]: `max-width: ${sizes_1.WIDTH.TABLET_MAX}px`,
    [QueryKeys.TABLET_UP]: `min-width: ${sizes_1.WIDTH.TABLET_MIN}px`,
};
exports.media = Object.entries(exports.QUERY).reduce((accumulator, [key, value]) => (Object.assign(Object.assign({}, accumulator), { [key]: `@media (${value})` })), {});
