/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import jakarta.servlet.ServletConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.HeadersTooLargeException;
import org.apache.coyote.http11.Http11InputBuffer;
import org.apache.coyote.http11.Http11OutputBuffer;
import org.apache.coyote.http11.InputFilter;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.BufferedInputFilter;
import org.apache.coyote.http11.filters.ChunkedInputFilter;
import org.apache.coyote.http11.filters.ChunkedOutputFilter;
import org.apache.coyote.http11.filters.GzipOutputFilter;
import org.apache.coyote.http11.filters.IdentityInputFilter;
import org.apache.coyote.http11.filters.IdentityOutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http11.upgrade.UpgradeApplicationBufferHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.HttpParser;
import org.apache.tomcat.util.http.parser.TokenList;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http11Processor
extends AbstractProcessor {
    private static final Log log = LogFactory.getLog(Http11Processor.class);
    private static final StringManager sm = StringManager.getManager(Http11Processor.class);
    private final AbstractHttp11Protocol<?> protocol;
    private final Http11InputBuffer inputBuffer;
    private final Http11OutputBuffer outputBuffer;
    private final HttpParser httpParser;
    private int pluggableFilterIndex = Integer.MAX_VALUE;
    private volatile boolean keepAlive = true;
    private volatile boolean openSocket = false;
    private volatile boolean readComplete = true;
    private boolean http11 = true;
    private boolean http09 = false;
    private boolean contentDelimitation = true;
    private UpgradeToken upgradeToken = null;
    private SendfileDataBase sendfileData = null;

    public Http11Processor(AbstractHttp11Protocol<?> abstractHttp11Protocol, Adapter adapter) {
        super(adapter);
        this.protocol = abstractHttp11Protocol;
        this.httpParser = new HttpParser(abstractHttp11Protocol.getRelaxedPathChars(), abstractHttp11Protocol.getRelaxedQueryChars());
        this.inputBuffer = new Http11InputBuffer(this.request, abstractHttp11Protocol.getMaxHttpRequestHeaderSize(), abstractHttp11Protocol.getRejectIllegalHeader(), this.httpParser);
        this.request.setInputBuffer(this.inputBuffer);
        this.outputBuffer = new Http11OutputBuffer(this.response, abstractHttp11Protocol.getMaxHttpResponseHeaderSize());
        this.response.setOutputBuffer(this.outputBuffer);
        this.inputBuffer.addFilter(new IdentityInputFilter(abstractHttp11Protocol.getMaxSwallowSize()));
        this.outputBuffer.addFilter(new IdentityOutputFilter());
        this.inputBuffer.addFilter(new ChunkedInputFilter(abstractHttp11Protocol.getMaxTrailerSize(), abstractHttp11Protocol.getAllowedTrailerHeadersInternal(), abstractHttp11Protocol.getMaxExtensionSize(), abstractHttp11Protocol.getMaxSwallowSize()));
        this.outputBuffer.addFilter(new ChunkedOutputFilter());
        this.inputBuffer.addFilter(new VoidInputFilter());
        this.outputBuffer.addFilter(new VoidOutputFilter());
        this.inputBuffer.addFilter(new BufferedInputFilter(abstractHttp11Protocol.getMaxSwallowSize()));
        this.outputBuffer.addFilter(new GzipOutputFilter());
        this.pluggableFilterIndex = this.inputBuffer.getFilters().length;
    }

    private static boolean statusDropsConnection(int n) {
        return n == 400 || n == 408 || n == 411 || n == 413 || n == 414 || n == 500 || n == 503 || n == 501;
    }

    private void addInputFilter(InputFilter[] inputFilterArray, String string) {
        if (this.contentDelimitation) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " Transfer encoding lists chunked before [" + string + "]"));
            }
            return;
        }
        if (string.equals("chunked")) {
            this.inputBuffer.addActiveFilter(inputFilterArray[1]);
            this.contentDelimitation = true;
        } else {
            for (int i = this.pluggableFilterIndex; i < inputFilterArray.length; ++i) {
                if (!inputFilterArray[i].getEncodingName().toString().equals(string)) continue;
                this.inputBuffer.addActiveFilter(inputFilterArray[i]);
                return;
            }
            this.response.setStatus(501);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported transfer encoding [" + string + "]"));
            }
        }
    }

    @Override
    public AbstractEndpoint.Handler.SocketState service(SocketWrapperBase<?> socketWrapperBase) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.setSocketWrapper(socketWrapperBase);
        this.keepAlive = true;
        this.openSocket = false;
        this.readComplete = true;
        boolean bl = false;
        SendfileState sendfileState = SendfileState.DONE;
        while (!this.getErrorState().isError() && this.keepAlive && !this.isAsync() && this.upgradeToken == null && sendfileState == SendfileState.DONE && !this.protocol.isPaused()) {
            int n;
            String string;
            Object object;
            Object object2;
            try {
                if (!this.inputBuffer.parseRequestLine(bl, this.protocol.getConnectionTimeout(), this.protocol.getKeepAliveTimeout())) {
                    if (this.inputBuffer.getParsingRequestLinePhase() == -1) {
                        return AbstractEndpoint.Handler.SocketState.UPGRADING;
                    }
                    if (this.handleIncompleteRequestLineRead()) break;
                }
                this.prepareRequestProtocol();
                if (this.protocol.isPaused()) {
                    this.response.setStatus(503);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                } else {
                    bl = true;
                    this.request.getMimeHeaders().setLimit(this.protocol.getMaxHeaderCount());
                    if (!this.http09 && !this.inputBuffer.parseHeaders()) {
                        this.openSocket = true;
                        this.readComplete = false;
                        break;
                    }
                    if (!this.protocol.getDisableUploadTimeout()) {
                        socketWrapperBase.setReadTimeout(this.protocol.getConnectionUploadTimeout());
                    }
                }
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("http11processor.header.parse"), (Throwable)iOException);
                }
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                object2 = this.userDataHelper.getNextMode();
                if (object2 != null) {
                    object = sm.getString("http11processor.header.parse");
                    switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[((Enum)object2).ordinal()]) {
                        case 1: {
                            object = (String)object + sm.getString("http11processor.fallToDebug");
                        }
                        case 2: {
                            log.info(object, throwable);
                            break;
                        }
                        case 3: {
                            log.debug(object, throwable);
                        }
                    }
                }
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
            }
            if (Http11Processor.isConnectionToken(this.request.getMimeHeaders(), "upgrade") && (object2 = this.protocol.getUpgradeProtocol(string = this.request.getHeader("Upgrade"))) != null && object2.accept(this.request)) {
                object = null;
                try {
                    object = this.cloneRequest(this.request);
                }
                catch (ByteChunk.BufferOverflowException bufferOverflowException) {
                    this.response.setStatus(413);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                }
                catch (IOException iOException) {
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, iOException);
                }
                if (object != null) {
                    this.response.setStatus(101);
                    this.response.setHeader("Connection", "Upgrade");
                    this.response.setHeader("Upgrade", string);
                    this.action(ActionCode.CLOSE, null);
                    this.getAdapter().log(this.request, this.response, 0L);
                    InternalHttpUpgradeHandler internalHttpUpgradeHandler = object2.getInternalUpgradeHandler(socketWrapperBase, this.getAdapter(), (Request)object);
                    UpgradeToken upgradeToken = new UpgradeToken(internalHttpUpgradeHandler, null, null, string);
                    this.action(ActionCode.UPGRADE, upgradeToken);
                    return AbstractEndpoint.Handler.SocketState.UPGRADING;
                }
            }
            if (this.getErrorState().isIoAllowed()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.request.prepare"), throwable);
                    }
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                }
            }
            if ((n = this.protocol.getMaxKeepAliveRequests()) == 1) {
                this.keepAlive = false;
            } else if (n > 0 && socketWrapperBase.decrementKeepAlive() <= 0) {
                this.keepAlive = false;
            }
            if (this.getErrorState().isIoAllowed()) {
                try {
                    requestInfo.setStage(3);
                    this.getAdapter().service(this.request, this.response);
                    if (this.keepAlive && !this.getErrorState().isError() && !this.isAsync() && Http11Processor.statusDropsConnection(this.response.getStatus())) {
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, interruptedIOException);
                }
                catch (HeadersTooLargeException headersTooLargeException) {
                    log.error((Object)sm.getString("http11processor.request.process"), (Throwable)headersTooLargeException);
                    if (this.response.isCommitted()) {
                        this.setErrorState(ErrorState.CLOSE_NOW, headersTooLargeException);
                    } else {
                        this.response.reset();
                        this.response.setStatus(500);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, headersTooLargeException);
                        this.response.setHeader("Connection", "close");
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)sm.getString("http11processor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            requestInfo.setStage(4);
            if (!this.isAsync()) {
                this.endRequest();
            }
            requestInfo.setStage(5);
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            if (!this.isAsync() || this.getErrorState().isError()) {
                this.request.updateCounters();
                if (this.getErrorState().isIoAllowed()) {
                    this.inputBuffer.nextRequest();
                    this.outputBuffer.nextRequest();
                }
            }
            if (!this.protocol.getDisableUploadTimeout()) {
                int n2 = this.protocol.getConnectionTimeout();
                if (n2 > 0) {
                    socketWrapperBase.setReadTimeout(n2);
                } else {
                    socketWrapperBase.setReadTimeout(0L);
                }
            }
            requestInfo.setStage(6);
            sendfileState = this.processSendfile(socketWrapperBase);
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError() || this.protocol.isPaused() && !this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        if (this.isUpgrade()) {
            return AbstractEndpoint.Handler.SocketState.UPGRADING;
        }
        if (sendfileState == SendfileState.PENDING) {
            return AbstractEndpoint.Handler.SocketState.SENDFILE;
        }
        if (this.openSocket) {
            if (this.readComplete) {
                return AbstractEndpoint.Handler.SocketState.OPEN;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected final void setSocketWrapper(SocketWrapperBase<?> socketWrapperBase) {
        super.setSocketWrapper(socketWrapperBase);
        this.inputBuffer.init(socketWrapperBase);
        this.outputBuffer.init(socketWrapperBase);
    }

    private Request cloneRequest(Request request) throws IOException {
        Object object;
        Request request2 = new Request();
        request2.decodedURI().duplicate(request.decodedURI());
        request2.method().duplicate(request.method());
        request2.getMimeHeaders().duplicate(request.getMimeHeaders());
        request2.requestURI().duplicate(request.requestURI());
        request2.queryString().duplicate(request.queryString());
        MimeHeaders mimeHeaders = request.getMimeHeaders();
        this.prepareExpectation(mimeHeaders);
        this.prepareInputFilters(mimeHeaders);
        this.ack(ContinueResponseTiming.ALWAYS);
        ByteChunk byteChunk = new ByteChunk();
        int n = this.protocol.getMaxSavePostSize();
        if (n != 0) {
            byteChunk.setLimit(n);
            object = new UpgradeApplicationBufferHandler();
            while (request.getInputBuffer().doRead((ApplicationBufferHandler)object) >= 0) {
                byteChunk.append(object.getByteBuffer());
            }
        }
        object = new SavedRequestInputFilter(byteChunk);
        request2.setInputBuffer((InputBuffer)object);
        return request2;
    }

    private boolean handleIncompleteRequestLineRead() {
        this.openSocket = true;
        if (this.inputBuffer.getParsingRequestLinePhase() > 1) {
            if (this.protocol.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                return false;
            }
            this.readComplete = false;
        }
        return true;
    }

    private void checkExpectationAndResponseStatus() {
        if (this.request.hasExpectation() && !this.isRequestBodyFullyRead() && (this.response.getStatus() < 200 || this.response.getStatus() > 299)) {
            this.inputBuffer.setSwallowInput(false);
            this.keepAlive = false;
        }
    }

    private void checkMaxSwallowSize() {
        long l = -1L;
        try {
            l = this.request.getContentLengthLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (l > 0L && this.protocol.getMaxSwallowSize() > -1 && l - this.request.getBytesRead() > (long)this.protocol.getMaxSwallowSize()) {
            this.keepAlive = false;
        }
    }

    private void prepareRequestProtocol() {
        MessageBytes messageBytes = this.request.protocol();
        if (messageBytes.equals("HTTP/1.1")) {
            this.http09 = false;
            this.http11 = true;
            messageBytes.setString("HTTP/1.1");
        } else if (messageBytes.equals("HTTP/1.0")) {
            this.http09 = false;
            this.http11 = false;
            this.keepAlive = false;
            messageBytes.setString("HTTP/1.0");
        } else if (messageBytes.equals("")) {
            this.http09 = true;
            this.http11 = false;
            this.keepAlive = false;
        } else {
            this.http09 = false;
            this.http11 = false;
            this.response.setStatus(505);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("http11processor.request.prepare") + " Unsupported HTTP version \"" + messageBytes + "\""));
            }
        }
    }

    private void prepareRequest() throws IOException {
        int n;
        String string;
        MessageBytes messageBytes;
        HashSet<String> hashSet;
        MimeHeaders mimeHeaders;
        MessageBytes messageBytes2;
        if (this.protocol.isSSLEnabled()) {
            this.request.scheme().setString("https");
        }
        if ((messageBytes2 = (mimeHeaders = this.request.getMimeHeaders()).getValue("Connection")) != null && !messageBytes2.isNull()) {
            hashSet = new HashSet();
            TokenList.parseTokenList(mimeHeaders.values("Connection"), hashSet);
            if (hashSet.contains("close")) {
                this.keepAlive = false;
            } else if (hashSet.contains("keep-alive")) {
                this.keepAlive = true;
            }
        }
        if (this.http11) {
            this.prepareExpectation(mimeHeaders);
        }
        if ((hashSet = this.protocol.getRestrictedUserAgentsPattern()) != null && (this.http11 || this.keepAlive) && (messageBytes = mimeHeaders.getValue("user-agent")) != null && !messageBytes.isNull() && ((Pattern)((Object)hashSet)).matcher(string = messageBytes.toString()).matches()) {
            this.http11 = false;
            this.keepAlive = false;
        }
        messageBytes = null;
        try {
            messageBytes = mimeHeaders.getUniqueValue("host");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest("http11processor.request.multipleHosts");
        }
        if (this.http11 && messageBytes == null) {
            this.badRequest("http11processor.request.noHostHeader");
        }
        string = this.request.requestURI().getByteChunk();
        byte[] byArray = string.getBytes();
        if (string.startsWithIgnoreCase("http", 0)) {
            n = 4;
            if (string.startsWithIgnoreCase("s", n)) {
                ++n;
            }
            if (string.startsWith("://", n)) {
                int n2 = string.getStart();
                int n3 = string.indexOf('/', n += 3);
                int n4 = string.indexOf('@', n);
                if (n3 > -1 && n4 > n3) {
                    n4 = -1;
                }
                if (n3 == -1) {
                    n3 = string.getLength();
                    this.request.requestURI().setBytes(byArray, n2 + 6, 1);
                } else {
                    this.request.requestURI().setBytes(byArray, n2 + n3, string.getLength() - n3);
                }
                if (n4 != -1) {
                    while (n < n4) {
                        byte by = byArray[n2 + n];
                        if (!HttpParser.isUserInfo(by)) {
                            this.badRequest("http11processor.request.invalidUserInfo");
                            break;
                        }
                        ++n;
                    }
                    n = n4 + 1;
                }
                if (this.http11) {
                    if (messageBytes != null && !messageBytes.getByteChunk().equalsIgnoreCase(byArray, n2 + n, n3 - n)) {
                        if (this.protocol.getAllowHostHeaderMismatch()) {
                            messageBytes = mimeHeaders.setValue("host");
                            messageBytes.setBytes(byArray, n2 + n, n3 - n);
                        } else {
                            this.badRequest("http11processor.request.inconsistentHosts");
                        }
                    }
                } else {
                    try {
                        messageBytes = mimeHeaders.setValue("host");
                        messageBytes.setBytes(byArray, n2 + n, n3 - n);
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            } else {
                this.badRequest("http11processor.request.invalidScheme");
            }
        }
        for (n = string.getStart(); n < string.getEnd(); ++n) {
            if (this.httpParser.isAbsolutePathRelaxed(byArray[n])) continue;
            this.badRequest("http11processor.request.invalidUri");
            break;
        }
        this.prepareInputFilters(mimeHeaders);
        this.parseHost(messageBytes);
        if (!this.getErrorState().isIoAllowed()) {
            this.getAdapter().log(this.request, this.response, 0L);
        }
    }

    private void prepareExpectation(MimeHeaders mimeHeaders) {
        MessageBytes messageBytes = mimeHeaders.getValue("expect");
        if (messageBytes != null && !messageBytes.isNull()) {
            if (messageBytes.toString().trim().equalsIgnoreCase("100-continue")) {
                this.request.setExpectation(true);
            } else {
                this.response.setStatus(417);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
            }
        }
    }

    private void prepareInputFilters(MimeHeaders mimeHeaders) throws IOException {
        MessageBytes messageBytes;
        this.contentDelimitation = false;
        InputFilter[] inputFilterArray = this.inputBuffer.getFilters();
        if (!this.http09 && (messageBytes = mimeHeaders.getValue("transfer-encoding")) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (TokenList.parseTokenList(mimeHeaders.values("transfer-encoding"), arrayList)) {
                for (String string : arrayList) {
                    this.addInputFilter(inputFilterArray, string);
                }
            } else {
                this.badRequest("http11processor.request.invalidTransferEncoding");
            }
        }
        long l = -1L;
        try {
            l = this.request.getContentLengthLong();
        }
        catch (NumberFormatException numberFormatException) {
            this.badRequest("http11processor.request.nonNumericContentLength");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.badRequest("http11processor.request.multipleContentLength");
        }
        if (l >= 0L) {
            if (this.contentDelimitation) {
                mimeHeaders.removeHeader("content-length");
                this.request.setContentLength(-1L);
                this.keepAlive = false;
            } else {
                this.inputBuffer.addActiveFilter(inputFilterArray[0]);
                this.contentDelimitation = true;
            }
        }
        if (!this.contentDelimitation) {
            this.inputBuffer.addActiveFilter(inputFilterArray[2]);
            this.contentDelimitation = true;
        }
    }

    private void badRequest(String string) {
        this.response.setStatus(400);
        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString(string));
        }
    }

    @Override
    protected final void prepareResponse() throws IOException {
        String string;
        int n;
        boolean bl = true;
        this.contentDelimitation = false;
        OutputFilter[] outputFilterArray = this.outputBuffer.getFilters();
        if (this.http09) {
            this.outputBuffer.addActiveFilter(outputFilterArray[0]);
            this.outputBuffer.commit();
            return;
        }
        int n2 = this.response.getStatus();
        if (n2 < 200 || n2 == 204 || n2 == 205 || n2 == 304) {
            this.outputBuffer.addActiveFilter(outputFilterArray[2]);
            bl = false;
            this.contentDelimitation = true;
            if (n2 == 205) {
                this.response.setContentLength(0L);
            } else {
                this.response.setContentLength(-1L);
            }
        }
        if (this.request.method().equals("HEAD")) {
            this.outputBuffer.addActiveFilter(outputFilterArray[2]);
            this.contentDelimitation = true;
        }
        if (this.protocol.getUseSendfile()) {
            this.prepareSendfile(outputFilterArray);
        }
        boolean bl2 = false;
        if (bl && this.sendfileData == null) {
            bl2 = this.protocol.useCompression(this.request, this.response);
        }
        MimeHeaders mimeHeaders = this.response.getMimeHeaders();
        if (bl || n2 == 204) {
            String string2;
            String string3 = this.response.getContentType();
            if (string3 != null) {
                mimeHeaders.setValue("Content-Type").setString(string3);
            }
            if ((string2 = this.response.getContentLanguage()) != null) {
                mimeHeaders.setValue("Content-Language").setString(string2);
            }
        }
        long l = this.response.getContentLengthLong();
        boolean bl3 = Http11Processor.isConnectionToken(mimeHeaders, "close");
        if (this.http11 && this.response.getTrailerFields() != null) {
            this.outputBuffer.addActiveFilter(outputFilterArray[1]);
            this.contentDelimitation = true;
            mimeHeaders.addValue("Transfer-Encoding").setString("chunked");
        } else if (l != -1L) {
            mimeHeaders.setValue("Content-Length").setLong(l);
            this.outputBuffer.addActiveFilter(outputFilterArray[0]);
            this.contentDelimitation = true;
        } else if (this.http11 && bl && !bl3) {
            this.outputBuffer.addActiveFilter(outputFilterArray[1]);
            this.contentDelimitation = true;
            mimeHeaders.addValue("Transfer-Encoding").setString("chunked");
        } else {
            this.outputBuffer.addActiveFilter(outputFilterArray[0]);
        }
        if (bl2) {
            this.outputBuffer.addActiveFilter(outputFilterArray[3]);
        }
        if (mimeHeaders.getValue("Date") == null) {
            mimeHeaders.addValue("Date").setString(FastHttpDateFormat.getCurrentDate());
        }
        if (bl && !this.contentDelimitation || bl3) {
            this.keepAlive = false;
        }
        this.checkExpectationAndResponseStatus();
        this.checkMaxSwallowSize();
        if (this.keepAlive && Http11Processor.statusDropsConnection(n2)) {
            this.keepAlive = false;
        }
        if (!this.keepAlive) {
            if (!bl3) {
                mimeHeaders.addValue("Connection").setString("close");
            }
        } else if (!this.getErrorState().isError()) {
            boolean bl4;
            if (!this.http11) {
                mimeHeaders.addValue("Connection").setString("keep-alive");
            }
            if (this.protocol.getUseKeepAliveResponseHeader() && (bl4 = Http11Processor.isConnectionToken(this.request.getMimeHeaders(), "keep-alive")) && (n = this.protocol.getKeepAliveTimeout()) > 0) {
                String string4 = "timeout=" + (long)n / 1000L;
                mimeHeaders.setValue("Keep-Alive").setString(string4);
                if (this.http11) {
                    MessageBytes messageBytes = mimeHeaders.getValue("Connection");
                    if (messageBytes == null) {
                        mimeHeaders.addValue("Connection").setString("keep-alive");
                    } else {
                        messageBytes.setString(messageBytes.getString() + ", keep-alive");
                    }
                }
            }
        }
        if ((string = this.protocol.getServer()) == null) {
            if (this.protocol.getServerRemoveAppProvidedValues()) {
                mimeHeaders.removeHeader("server");
            }
        } else {
            mimeHeaders.setValue("Server").setString(string);
        }
        try {
            this.outputBuffer.sendStatus();
            n = mimeHeaders.size();
            for (int i = 0; i < n; ++i) {
                try {
                    this.outputBuffer.sendHeader(mimeHeaders.getName(i), mimeHeaders.getValue(i));
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    log.warn((Object)sm.getString("http11processor.response.invalidHeader", new Object[]{mimeHeaders.getName(i), mimeHeaders.getValue(i)}), (Throwable)illegalArgumentException);
                    mimeHeaders.removeHeader(i);
                    --n;
                    this.outputBuffer.resetHeaderBuffer();
                    i = 0;
                    this.outputBuffer.sendStatus();
                }
            }
            this.outputBuffer.endHeaders();
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.outputBuffer.resetHeaderBuffer();
            throw throwable;
        }
        this.outputBuffer.commit();
    }

    private static boolean isConnectionToken(MimeHeaders mimeHeaders, String string) throws IOException {
        MessageBytes messageBytes = mimeHeaders.getValue("Connection");
        if (messageBytes == null) {
            return false;
        }
        HashSet<String> hashSet = new HashSet<String>();
        TokenList.parseTokenList(mimeHeaders.values("Connection"), hashSet);
        return hashSet.contains(string);
    }

    private void prepareSendfile(OutputFilter[] outputFilterArray) {
        String string = (String)this.request.getAttribute("org.apache.tomcat.sendfile.filename");
        if (string == null) {
            this.sendfileData = null;
        } else {
            this.outputBuffer.addActiveFilter(outputFilterArray[2]);
            this.contentDelimitation = true;
            long l = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.start");
            long l2 = (Long)this.request.getAttribute("org.apache.tomcat.sendfile.end");
            this.sendfileData = this.socketWrapper.createSendfileData(string, l, l2 - l);
        }
    }

    @Override
    protected void populatePort() {
        this.request.action(ActionCode.REQ_LOCALPORT_ATTRIBUTE, this.request);
        this.request.setServerPort(this.request.getLocalPort());
    }

    @Override
    protected boolean flushBufferedWrite() throws IOException {
        if (this.outputBuffer.hasDataToWrite() && this.outputBuffer.flushBuffer(false)) {
            this.outputBuffer.registerWriteInterest();
            return true;
        }
        return false;
    }

    @Override
    protected AbstractEndpoint.Handler.SocketState dispatchEndRequest() {
        if (!this.keepAlive || this.protocol.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        this.endRequest();
        this.inputBuffer.nextRequest();
        this.outputBuffer.nextRequest();
        if (this.socketWrapper.isReadPending()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected ServletConnection getServletConnection() {
        return this.socketWrapper.getServletConnection("http/1.1", "");
    }

    private void endRequest() {
        if (this.getErrorState().isError()) {
            this.inputBuffer.setSwallowInput(false);
        } else {
            this.checkExpectationAndResponseStatus();
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.inputBuffer.endRequest();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.response.setStatus(500);
                this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                log.error((Object)sm.getString("http11processor.request.finish"), throwable);
            }
        }
        if (this.getErrorState().isIoAllowed()) {
            try {
                this.action(ActionCode.COMMIT, null);
                this.outputBuffer.end();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                log.error((Object)sm.getString("http11processor.response.finish"), throwable);
            }
        }
    }

    @Override
    protected final void finishResponse() throws IOException {
        this.outputBuffer.end();
    }

    @Override
    protected final void ack(ContinueResponseTiming continueResponseTiming) {
        if ((continueResponseTiming == ContinueResponseTiming.ALWAYS || continueResponseTiming == this.protocol.getContinueResponseTimingInternal()) && !this.response.isCommitted() && this.request.hasExpectation()) {
            try {
                this.outputBuffer.sendAck();
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
            }
        }
    }

    @Override
    protected final void flush() throws IOException {
        this.outputBuffer.flush();
    }

    @Override
    protected final int available(boolean bl) {
        return this.inputBuffer.available(bl);
    }

    @Override
    protected final void setRequestBody(ByteChunk byteChunk) {
        SavedRequestInputFilter savedRequestInputFilter = new SavedRequestInputFilter(byteChunk);
        Http11InputBuffer http11InputBuffer = (Http11InputBuffer)this.request.getInputBuffer();
        http11InputBuffer.addActiveFilter(savedRequestInputFilter);
    }

    @Override
    protected final void setSwallowResponse() {
        this.outputBuffer.responseFinished = true;
    }

    @Override
    protected final void disableSwallowRequest() {
        this.inputBuffer.setSwallowInput(false);
    }

    @Override
    protected final void sslReHandShake() throws IOException {
        if (this.sslSupport != null) {
            InputFilter[] inputFilterArray = this.inputBuffer.getFilters();
            ((BufferedInputFilter)inputFilterArray[3]).setLimit(this.protocol.getMaxSavePostSize());
            this.inputBuffer.addActiveFilter(inputFilterArray[3]);
            this.socketWrapper.doClientAuth(this.sslSupport);
            try {
                X509Certificate[] x509CertificateArray = this.sslSupport.getPeerCertificateChain();
                if (x509CertificateArray != null) {
                    this.request.setAttribute("jakarta.servlet.request.X509Certificate", x509CertificateArray);
                }
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("http11processor.socket.ssl"), (Throwable)iOException);
            }
        }
    }

    @Override
    protected final boolean isRequestBodyFullyRead() {
        return this.inputBuffer.isFinished();
    }

    @Override
    protected final void registerReadInterest() {
        this.socketWrapper.registerReadInterest();
    }

    @Override
    protected final boolean isReadyForWrite() {
        return this.outputBuffer.isReady();
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        return this.upgradeToken;
    }

    @Override
    protected final void doHttpUpgrade(UpgradeToken upgradeToken) {
        this.upgradeToken = upgradeToken;
        this.outputBuffer.responseFinished = true;
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        return this.inputBuffer.getLeftover();
    }

    @Override
    public boolean isUpgrade() {
        return this.upgradeToken != null;
    }

    @Override
    protected boolean isTrailerFieldsReady() {
        if (this.inputBuffer.isChunking()) {
            return this.inputBuffer.isFinished();
        }
        return true;
    }

    @Override
    protected boolean isTrailerFieldsSupported() {
        if (!this.http11) {
            return false;
        }
        if (!this.response.isCommitted()) {
            return true;
        }
        return this.outputBuffer.isChunking();
    }

    private SendfileState processSendfile(SocketWrapperBase<?> socketWrapperBase) {
        this.openSocket = this.keepAlive;
        SendfileState sendfileState = SendfileState.DONE;
        if (this.sendfileData != null && !this.getErrorState().isError()) {
            this.sendfileData.keepAliveState = this.keepAlive ? (this.available(false) == 0 ? SendfileKeepAliveState.OPEN : SendfileKeepAliveState.PIPELINED) : SendfileKeepAliveState.NONE;
            sendfileState = socketWrapperBase.processSendfile(this.sendfileData);
            switch (sendfileState) {
                case ERROR: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("http11processor.sendfile.error"));
                    }
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, null);
                }
            }
            this.sendfileData = null;
        }
        return sendfileState;
    }

    @Override
    public final void recycle() {
        this.getAdapter().checkRecycled(this.request, this.response);
        super.recycle();
        this.inputBuffer.recycle();
        this.outputBuffer.recycle();
        this.upgradeToken = null;
        this.socketWrapper = null;
        this.sendfileData = null;
        this.sslSupport = null;
    }

    @Override
    public void pause() {
    }
}

