/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.model;

import com.moandjiezana.toml.Toml;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.islandoftex.texplate.exceptions.InvalidTemplateException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B_\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0003Jc\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006%"}, d2={"Lorg/islandoftex/texplate/model/Template;", "", "name", "", "description", "authors", "", "requirements", "document", "handlers", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/util/Map;)V", "getAuthors", "()Ljava/util/List;", "getDescription", "()Ljava/lang/String;", "getDocument", "getHandlers", "()Ljava/util/Map;", "isValid", "", "()Z", "getName", "getRequirements", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "texplate"})
public final class Template {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String name;
    @Nullable
    private final String description;
    @NotNull
    private final List<String> authors;
    @NotNull
    private final List<String> requirements;
    @Nullable
    private final String document;
    @NotNull
    private final Map<String, String> handlers;

    public Template(@Nullable String name, @Nullable String description, @NotNull List<String> authors, @NotNull List<String> requirements, @Nullable String document, @NotNull Map<String, String> handlers) {
        Intrinsics.checkNotNullParameter(authors, "authors");
        Intrinsics.checkNotNullParameter(requirements, "requirements");
        Intrinsics.checkNotNullParameter(handlers, "handlers");
        this.name = name;
        this.description = description;
        this.authors = authors;
        this.requirements = requirements;
        this.document = document;
        this.handlers = handlers;
    }

    public /* synthetic */ Template(String string, String string2, List list, List list2, String string3, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            bl = false;
            map = MapsKt.emptyMap();
        }
        this(string, string2, list, list2, string3, map);
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final List<String> getAuthors() {
        return this.authors;
    }

    @NotNull
    public final List<String> getRequirements() {
        return this.requirements;
    }

    @Nullable
    public final String getDocument() {
        return this.document;
    }

    @NotNull
    public final Map<String, String> getHandlers() {
        return this.handlers;
    }

    private final boolean isValid() {
        return this.name != null && this.description != null && this.document != null && !StringsKt.isBlank(this.name) && !StringsKt.isBlank(this.description) && !this.authors.isEmpty() && !StringsKt.isBlank(this.document);
    }

    @Nullable
    public final String component1() {
        return this.name;
    }

    @Nullable
    public final String component2() {
        return this.description;
    }

    @NotNull
    public final List<String> component3() {
        return this.authors;
    }

    @NotNull
    public final List<String> component4() {
        return this.requirements;
    }

    @Nullable
    public final String component5() {
        return this.document;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.handlers;
    }

    @NotNull
    public final Template copy(@Nullable String name, @Nullable String description, @NotNull List<String> authors, @NotNull List<String> requirements, @Nullable String document, @NotNull Map<String, String> handlers) {
        Intrinsics.checkNotNullParameter(authors, "authors");
        Intrinsics.checkNotNullParameter(requirements, "requirements");
        Intrinsics.checkNotNullParameter(handlers, "handlers");
        return new Template(name, description, authors, requirements, document, handlers);
    }

    public static /* synthetic */ Template copy$default(Template template, String string, String string2, List list, List list2, String string3, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            string = template.name;
        }
        if ((n & 2) != 0) {
            string2 = template.description;
        }
        if ((n & 4) != 0) {
            list = template.authors;
        }
        if ((n & 8) != 0) {
            list2 = template.requirements;
        }
        if ((n & 0x10) != 0) {
            string3 = template.document;
        }
        if ((n & 0x20) != 0) {
            map = template.handlers;
        }
        return template.copy(string, string2, list, list2, string3, map);
    }

    @NotNull
    public String toString() {
        return "Template(name=" + this.name + ", description=" + this.description + ", authors=" + this.authors + ", requirements=" + this.requirements + ", document=" + this.document + ", handlers=" + this.handlers + ')';
    }

    public int hashCode() {
        int result = this.name == null ? 0 : this.name.hashCode();
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + ((Object)this.authors).hashCode();
        result = result * 31 + ((Object)this.requirements).hashCode();
        result = result * 31 + (this.document == null ? 0 : this.document.hashCode());
        result = result * 31 + ((Object)this.handlers).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Template)) {
            return false;
        }
        Template template = (Template)other;
        if (!Intrinsics.areEqual(this.name, template.name)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.description, template.description)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.authors, template.authors)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.requirements, template.requirements)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.document, template.document)) {
            return false;
        }
        return Intrinsics.areEqual(this.handlers, template.handlers);
    }

    public Template() {
        this(null, null, null, null, null, null, 63, null);
    }

    @JvmStatic
    @NotNull
    public static final Template fromPath(@NotNull Path path) throws InvalidTemplateException {
        return Companion.fromPath(path);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/islandoftex/texplate/model/Template$Companion;", "", "()V", "fromPath", "Lorg/islandoftex/texplate/model/Template;", "path", "Ljava/nio/file/Path;", "texplate"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Template fromPath(@NotNull Path path) throws InvalidTemplateException {
            Template template;
            Intrinsics.checkNotNullParameter(path, "path");
            Template template2 = null;
            String message = "The provided template file looks invalid. Please make sure the template has a valid syntax and try again. ";
            try {
                template = new Toml().read(path.toFile()).to(Template.class);
                Intrinsics.checkNotNullExpressionValue(template, "{\n                Toml().read(path.toFile()).to(Template::class.java)\n            }");
            }
            catch (IllegalStateException exception) {
                throw new InvalidTemplateException(Intrinsics.stringPlus(message, "In this particular scenario, there is a possibility that the template file does not follow the TOML specification. Please refer to the user manual for further details and a possible fix. Also, the raised exception message can give us some hints on what happened."), exception);
            }
            template2 = template;
            if (!template2.isValid()) {
                throw new InvalidTemplateException(Intrinsics.stringPlus(message, "Specifically, some mandatory fields are either absent or empty in the template file. It is quite important to strictly follow the template specification, as detailed in the user manual, or the tool will not work at all."));
            }
            return template2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

