import { EndpointParameterInstructions } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import {
  Handler,
  HttpHandlerOptions as __HttpHandlerOptions,
  MetadataBearer as __MetadataBearer,
  MiddlewareStack,
} from "@smithy/types";
import {
  CloudFormationClientResolvedConfig,
  ServiceInputTypes,
  ServiceOutputTypes,
} from "../CloudFormationClient";
import {
  DescribeStackResourceInput,
  DescribeStackResourceOutput,
} from "../models/models_0";
export { __MetadataBearer, $Command };
export interface DescribeStackResourceCommandInput
  extends DescribeStackResourceInput {}
export interface DescribeStackResourceCommandOutput
  extends DescribeStackResourceOutput,
    __MetadataBearer {}
export declare class DescribeStackResourceCommand extends $Command<
  DescribeStackResourceCommandInput,
  DescribeStackResourceCommandOutput,
  CloudFormationClientResolvedConfig
> {
  readonly input: DescribeStackResourceCommandInput;
  static getEndpointParameterInstructions(): EndpointParameterInstructions;
  constructor(input: DescribeStackResourceCommandInput);
  resolveMiddleware(
    clientStack: MiddlewareStack<ServiceInputTypes, ServiceOutputTypes>,
    configuration: CloudFormationClientResolvedConfig,
    options?: __HttpHandlerOptions
  ): Handler<
    DescribeStackResourceCommandInput,
    DescribeStackResourceCommandOutput
  >;
  private serialize;
  private deserialize;
}
