/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.ByteBufferUtil;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public class TimestampToLongCodec
extends AbstractCodec<Long>
implements TypeCodec<Long> {
    @NonNull
    public GenericType<Long> getJavaType() {
        return GenericType.LONG;
    }

    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIMESTAMP;
    }

    public ByteBuffer encode(Long value, @NonNull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value);
    }

    public Long decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        return ByteBufferUtil.toLong(bytes.duplicate());
    }

    @Override
    Long parseNonNull(@NonNull String value) {
        return Long.valueOf(value);
    }

    @Override
    String formatNonNull(@NonNull Long value) {
        return String.valueOf(value);
    }
}

