/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ing.data.cassandra.jdbc.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.AbstractResultSet;
import com.ing.data.cassandra.jdbc.CassandraResultSetExtras;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.DataTypeEnum;
import com.ing.data.cassandra.jdbc.MetadataResultSet;
import com.ing.data.cassandra.jdbc.MetadataRow;
import com.ing.data.cassandra.jdbc.TypesMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;

public class CassandraMetadataResultSet
extends AbstractResultSet
implements CassandraResultSetExtras {
    int rowNumber = 0;
    private final CResultSetMetaData metadata = new CResultSetMetaData();
    private final CassandraStatement statement;
    private MetadataRow currentRow;
    private Iterator<MetadataRow> rowsIterator;
    private int resultSetType;
    private int fetchDirection;
    private int fetchSize;
    private boolean wasNull;
    private MetadataResultSet driverResultSet;

    CassandraMetadataResultSet() {
        this.statement = null;
    }

    CassandraMetadataResultSet(CassandraStatement statement, MetadataResultSet metadataResultSet) throws SQLException {
        this.statement = statement;
        this.resultSetType = statement.getResultSetType();
        this.fetchDirection = statement.getFetchDirection();
        this.fetchSize = statement.getFetchSize();
        this.driverResultSet = metadataResultSet;
        this.rowsIterator = metadataResultSet.iterator();
        if (this.hasMoreRows()) {
            this.populateColumns();
        }
    }

    private void populateColumns() {
        this.currentRow = this.rowsIterator.next();
    }

    @Override
    DataType getCqlDataType(int columnIndex) {
        return this.currentRow.getColumnDefinitions().getType(columnIndex - 1);
    }

    @Override
    DataType getCqlDataType(String columnLabel) {
        return this.currentRow.getColumnDefinitions().getType(columnLabel);
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public void afterLast() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY.");
        }
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (this.resultSetType == 1003) {
            throw new SQLNonTransientException("Can not position cursor with a type of TYPE_FORWARD_ONLY.");
        }
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    private void checkIndex(int index) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(index - 1);
            if (this.currentRow.getColumnDefinitions() != null && (index < 1 || index > this.currentRow.getColumnDefinitions().asList().size())) {
                throw new SQLSyntaxErrorException(String.format("Index must be a positive number less or equal the count of returned columns: %d", index) + " " + this.currentRow.getColumnDefinitions().asList().size());
            }
        } else if (this.driverResultSet != null && this.driverResultSet.getColumnDefinitions() != null && (index < 1 || index > this.driverResultSet.getColumnDefinitions().asList().size())) {
            throw new SQLSyntaxErrorException(String.format("Index must be a positive number less or equal the count of returned columns: %d", index) + " " + this.driverResultSet.getColumnDefinitions().asList().size());
        }
    }

    private void checkName(String name) throws SQLException {
        if (this.currentRow != null) {
            this.wasNull = this.currentRow.isNull(name);
            if (!this.currentRow.getColumnDefinitions().contains(name)) {
                throw new SQLSyntaxErrorException(String.format("Name provided was not in the list of valid column labels: %s", name));
            }
        } else if (this.driverResultSet != null && this.driverResultSet.getColumnDefinitions() != null && !this.driverResultSet.getColumnDefinitions().contains(name)) {
            throw new SQLSyntaxErrorException(String.format("Name provided was not in the list of valid column labels: %s", name));
        }
    }

    private void checkNotClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLRecoverableException("Method was called on a closed ResultSet.");
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.statement.close();
        }
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkNotClosed();
        this.checkName(columnLabel);
        return this.currentRow.getColumnDefinitions().getIndexOf(columnLabel);
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getDecimal(columnIndex - 1);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        this.checkIndex(columnIndex);
        BigDecimal decimalValue = this.currentRow.getDecimal(columnIndex - 1);
        if (decimalValue == null) {
            return null;
        }
        return decimalValue.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getDecimal(columnLabel);
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        this.checkName(columnLabel);
        BigDecimal decimalValue = this.currentRow.getDecimal(columnLabel);
        if (decimalValue == null) {
            return null;
        }
        return decimalValue.setScale(scale, RoundingMode.HALF_UP);
    }

    @Override
    public BigInteger getBigInteger(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getVarint(columnIndex - 1);
    }

    @Override
    public BigInteger getBigInteger(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getVarint(columnLabel);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnIndex - 1);
        if (byteBuffer != null) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, bytes.length);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnLabel);
        if (byteBuffer != null) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, bytes.length);
            return new ByteArrayInputStream(bytes);
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnIndex - 1);
        if (byteBuffer != null) {
            return new SerialBlob(byteBuffer.array());
        }
        return null;
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnLabel);
        if (byteBuffer != null) {
            return new SerialBlob(byteBuffer.array());
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getBool(columnIndex - 1);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getBool(columnLabel);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getByte(columnIndex - 1);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getByte(columnLabel);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnIndex - 1);
        if (byteBuffer != null) {
            return byteBuffer.array();
        }
        return null;
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        ByteBuffer byteBuffer = this.currentRow.getBytes(columnLabel);
        if (byteBuffer != null) {
            return byteBuffer.array();
        }
        return null;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetConcurrency();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        java.util.Date dateValue = this.currentRow.getDate(columnIndex - 1);
        if (dateValue == null) {
            return null;
        }
        return new Date(dateValue.getTime());
    }

    @Override
    public Date getDate(int columnIndex, Calendar calendar) throws SQLException {
        return this.getDate(columnIndex);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        java.util.Date dateValue = this.currentRow.getDate(columnLabel);
        if (dateValue == null) {
            return null;
        }
        return new Date(dateValue.getTime());
    }

    @Override
    public Date getDate(String columnLabel, Calendar calendar) throws SQLException {
        return this.getDate(columnLabel);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isCqlType(columnIndex, DataTypeEnum.FLOAT)) {
            return this.currentRow.getFloat(columnIndex - 1);
        }
        return this.currentRow.getDouble(columnIndex - 1);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        if (this.isCqlType(columnLabel, DataTypeEnum.FLOAT)) {
            return this.currentRow.getFloat(columnLabel);
        }
        return this.currentRow.getDouble(columnLabel);
    }

    @Override
    public CqlDuration getDuration(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getDuration(columnIndex - 1);
    }

    @Override
    public CqlDuration getDuration(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getDuration(columnLabel);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkNotClosed();
        return this.fetchDirection;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkNotClosed();
        if (direction == 1000 || direction == 1001 || direction == 1002) {
            if (this.getType() == 1003 && direction != 1000) {
                throw new SQLSyntaxErrorException("Attempt to set an illegal direction: " + direction);
            }
            this.fetchDirection = direction;
        }
        throw new SQLSyntaxErrorException(String.format("Fetch direction value of: %s is illegal.", direction));
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkNotClosed();
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int size) throws SQLException {
        this.checkNotClosed();
        if (size < 0) {
            throw new SQLException(String.format("Fetch size of: %s rows may not be negative.", size));
        }
        this.fetchSize = size;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getFloat(columnIndex - 1);
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getFloat(columnLabel);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkNotClosed();
        return this.statement.getResultSetHoldability();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getInt(columnIndex - 1);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getInt(columnLabel);
    }

    @Override
    public List<?> getList(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DataType cqlDataType = this.getCqlDataType(columnIndex);
        if (DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false)).isCollection()) {
            ListType listType = (ListType)cqlDataType;
            Class<?> itemsClass = DataTypeEnum.fromCqlTypeName((String)listType.getElementType().asCql((boolean)false, (boolean)false)).javaType;
            List<?> resultList = this.currentRow.getList(columnIndex - 1, itemsClass);
            if (resultList == null) {
                return null;
            }
            return Lists.newArrayList(resultList);
        }
        return this.currentRow.getList(columnIndex - 1, String.class);
    }

    @Override
    public List<?> getList(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        DataType cqlDataType = this.getCqlDataType(columnLabel);
        if (DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false)).isCollection()) {
            ListType listType = (ListType)cqlDataType;
            Class<?> itemsClass = DataTypeEnum.fromCqlTypeName((String)listType.getElementType().asCql((boolean)false, (boolean)false)).javaType;
            List<?> resultList = this.currentRow.getList(columnLabel, itemsClass);
            if (resultList == null) {
                return null;
            }
            return Lists.newArrayList(resultList);
        }
        return this.currentRow.getList(columnLabel, String.class);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        if (this.isCqlType(columnIndex, DataTypeEnum.INT)) {
            return this.currentRow.getInt(columnIndex - 1);
        }
        if (this.isCqlType(columnIndex, DataTypeEnum.VARINT)) {
            return this.currentRow.getVarint(columnIndex - 1).longValue();
        }
        return this.currentRow.getLong(columnIndex - 1);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        if (this.isCqlType(columnLabel, DataTypeEnum.INT)) {
            return this.currentRow.getInt(columnLabel);
        }
        if (this.isCqlType(columnLabel, DataTypeEnum.VARINT)) {
            return this.currentRow.getVarint(columnLabel).longValue();
        }
        return this.currentRow.getLong(columnLabel);
    }

    @Override
    public Map<?, ?> getMap(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DataType cqlDataType = this.getCqlDataType(columnIndex);
        if (DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false)).isCollection()) {
            MapType mapType = (MapType)cqlDataType;
            Class<?> keysClass = DataTypeEnum.fromCqlTypeName((String)mapType.getKeyType().asCql((boolean)false, (boolean)false)).javaType;
            Class<?> valuesClass = DataTypeEnum.fromCqlTypeName((String)mapType.getValueType().asCql((boolean)false, (boolean)false)).javaType;
            return Maps.newLinkedHashMap(this.currentRow.getMap(columnIndex - 1, keysClass, valuesClass));
        }
        return this.currentRow.getMap(columnIndex - 1, String.class, String.class);
    }

    @Override
    public Map<?, ?> getMap(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        DataType cqlDataType = this.getCqlDataType(columnLabel);
        if (DataTypeEnum.fromCqlTypeName(cqlDataType.asCql(false, false)).isCollection()) {
            MapType mapType = (MapType)cqlDataType;
            Class<?> keysClass = DataTypeEnum.fromCqlTypeName((String)mapType.getKeyType().asCql((boolean)false, (boolean)false)).javaType;
            Class<?> valuesClass = DataTypeEnum.fromCqlTypeName((String)mapType.getValueType().asCql((boolean)false, (boolean)false)).javaType;
            return Maps.newLinkedHashMap(this.currentRow.getMap(columnLabel, keysClass, valuesClass));
        }
        return this.currentRow.getMap(columnLabel, String.class, String.class);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkNotClosed();
        return this.metadata;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        DataTypeEnum dataType = DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnIndex).asCql(false, false));
        switch (dataType) {
            case VARCHAR: 
            case ASCII: 
            case TEXT: {
                return this.currentRow.getString(columnIndex - 1);
            }
            case INT: 
            case VARINT: {
                return this.currentRow.getInt(columnIndex - 1);
            }
            case SMALLINT: {
                return this.currentRow.getShort(columnIndex - 1);
            }
            case TINYINT: {
                return this.currentRow.getByte(columnIndex - 1);
            }
            case BIGINT: 
            case COUNTER: {
                return this.currentRow.getLong(columnIndex - 1);
            }
            case BLOB: {
                return this.currentRow.getBytes(columnIndex - 1);
            }
            case BOOLEAN: {
                return this.currentRow.getBool(columnIndex - 1);
            }
            case DATE: {
                return this.currentRow.getDate(columnIndex - 1);
            }
            case TIME: {
                return this.currentRow.getTime(columnIndex - 1);
            }
            case DECIMAL: {
                return this.currentRow.getDecimal(columnIndex - 1);
            }
            case DOUBLE: {
                return this.currentRow.getDouble(columnIndex - 1);
            }
            case FLOAT: {
                return Float.valueOf(this.currentRow.getFloat(columnIndex - 1));
            }
            case INET: {
                return this.currentRow.getInet(columnIndex - 1);
            }
            case TIMESTAMP: {
                return new Timestamp(this.currentRow.getDate(columnIndex - 1).getTime());
            }
            case DURATION: {
                return this.currentRow.getDuration(columnIndex - 1);
            }
            case UUID: 
            case TIMEUUID: {
                return this.currentRow.getUUID(columnIndex - 1);
            }
        }
        return null;
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        DataTypeEnum dataType = DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnLabel).asCql(false, false));
        switch (dataType) {
            case VARCHAR: 
            case ASCII: 
            case TEXT: {
                return this.currentRow.getString(columnLabel);
            }
            case INT: 
            case VARINT: {
                return this.currentRow.getInt(columnLabel);
            }
            case SMALLINT: {
                return this.currentRow.getShort(columnLabel);
            }
            case TINYINT: {
                return this.currentRow.getByte(columnLabel);
            }
            case BIGINT: 
            case COUNTER: {
                return this.currentRow.getLong(columnLabel);
            }
            case BLOB: {
                return this.currentRow.getBytes(columnLabel);
            }
            case BOOLEAN: {
                return this.currentRow.getBool(columnLabel);
            }
            case DATE: {
                return this.currentRow.getDate(columnLabel);
            }
            case TIME: {
                return this.currentRow.getTime(columnLabel);
            }
            case DECIMAL: {
                return this.currentRow.getDecimal(columnLabel);
            }
            case DOUBLE: {
                return this.currentRow.getDouble(columnLabel);
            }
            case FLOAT: {
                return Float.valueOf(this.currentRow.getFloat(columnLabel));
            }
            case INET: {
                return this.currentRow.getInet(columnLabel);
            }
            case TIMESTAMP: {
                return new Timestamp(this.currentRow.getDate(columnLabel).getTime());
            }
            case DURATION: {
                return this.currentRow.getDuration(columnLabel);
            }
            case UUID: 
            case TIMEUUID: {
                return this.currentRow.getUUID(columnLabel);
            }
        }
        return null;
    }

    private String getObjectAsString(int columnIndex) throws SQLException {
        Object o = this.getObject(columnIndex);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    private String getObjectAsString(String columnLabel) throws SQLException {
        Object o = this.getObject(columnLabel);
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber;
    }

    @Override
    public RowId getRowId(int columnIndex) {
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) {
        return null;
    }

    @Override
    public Set<?> getSet(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        try {
            SetType setType = (SetType)this.getCqlDataType(columnIndex);
            return this.currentRow.getSet(columnIndex - 1, Class.forName(DataTypeEnum.fromCqlTypeName(setType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public Set<?> getSet(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        try {
            SetType setType = (SetType)this.getCqlDataType(columnLabel);
            return this.currentRow.getSet(columnLabel, Class.forName(DataTypeEnum.fromCqlTypeName(setType.getElementType().asCql(false, false)).asJavaClass().getCanonicalName()));
        }
        catch (ClassNotFoundException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getShort(columnIndex - 1);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getShort(columnLabel);
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkNotClosed();
        return this.statement;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        try {
            if (DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnIndex).asCql(false, false)).isCollection()) {
                return this.getObjectAsString(columnIndex);
            }
            return this.currentRow.getString(columnIndex - 1);
        }
        catch (Exception e) {
            return this.getObjectAsString(columnIndex);
        }
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        try {
            if (DataTypeEnum.fromCqlTypeName(this.getCqlDataType(columnLabel).asCql(false, false)).isCollection()) {
                return this.getObjectAsString(columnLabel);
            }
            return this.currentRow.getString(columnLabel);
        }
        catch (Exception e) {
            return this.getObjectAsString(columnLabel);
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        return this.currentRow.getTime(columnIndex - 1);
    }

    @Override
    public Time getTime(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTime(columnIndex);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        return this.currentRow.getTime(columnLabel);
    }

    @Override
    public Time getTime(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTime(columnLabel);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        java.util.Date date = this.currentRow.getDate(columnIndex - 1);
        if (date == null) {
            return null;
        }
        return new Timestamp(this.currentRow.getDate(columnIndex - 1).getTime());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        java.util.Date date = this.currentRow.getDate(columnLabel);
        if (date == null) {
            return null;
        }
        return new Timestamp(this.currentRow.getDate(columnLabel).getTime());
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar calendar) throws SQLException {
        return this.getTimestamp(columnLabel);
    }

    @Override
    public int getType() throws SQLException {
        this.checkNotClosed();
        return this.resultSetType;
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        this.checkIndex(columnIndex);
        String storedUrl = this.currentRow.getString(columnIndex - 1);
        if (storedUrl == null) {
            return null;
        }
        try {
            return new URL(storedUrl);
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("The string '%s' is not a valid URL.", storedUrl), e);
        }
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        this.checkName(columnLabel);
        String storedUrl = this.currentRow.getString(columnLabel);
        if (storedUrl == null) {
            return null;
        }
        try {
            return new URL(storedUrl);
        }
        catch (MalformedURLException e) {
            throw new SQLException(String.format("The string '%s' is not a valid URL.", storedUrl), e);
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkNotClosed();
        return null;
    }

    private boolean hasMoreRows() {
        return this.rowsIterator != null && (this.rowsIterator.hasNext() || this.rowNumber == 0 && this.currentRow != null);
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == Integer.MAX_VALUE;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 0;
    }

    @Override
    public boolean isClosed() {
        if (this.statement == null) {
            return true;
        }
        return this.statement.isClosed();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkNotClosed();
        return this.rowNumber == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkNotClosed();
        return !this.rowsIterator.hasNext();
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public synchronized boolean next() {
        if (this.hasMoreRows()) {
            if (this.rowNumber != 0) {
                this.populateColumns();
            }
            ++this.rowNumber;
            return true;
        }
        this.rowNumber = Integer.MAX_VALUE;
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    class CResultSetMetaData
    implements ResultSetMetaData {
        CResultSetMetaData() {
        }

        @Override
        public String getCatalogName(int column) throws SQLException {
            if (CassandraMetadataResultSet.this.statement == null) {
                return null;
            }
            return ((CassandraMetadataResultSet)CassandraMetadataResultSet.this).statement.connection.getCatalog();
        }

        @Override
        public String getColumnClassName(int column) {
            if (CassandraMetadataResultSet.this.currentRow != null) {
                return DataTypeEnum.fromCqlTypeName(CassandraMetadataResultSet.this.getCqlDataType(column).asCql(false, false)).asJavaClass().getCanonicalName();
            }
            return DataTypeEnum.fromCqlTypeName(CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1).getType().asCql(false, false)).asJavaClass().getCanonicalName();
        }

        @Override
        public int getColumnCount() {
            if (CassandraMetadataResultSet.this.currentRow != null) {
                return CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().size();
            }
            if (CassandraMetadataResultSet.this.driverResultSet != null && CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions() != null) {
                return CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().size();
            }
            return 0;
        }

        @Override
        public String getColumnLabel(int column) {
            return this.getColumnName(column);
        }

        @Override
        public String getColumnName(int column) {
            try {
                if (CassandraMetadataResultSet.this.currentRow != null) {
                    return CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getName(column - 1);
                }
                return CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1).getName();
            }
            catch (Exception e) {
                return "";
            }
        }

        @Override
        public int getColumnDisplaySize(int column) {
            try {
                ColumnDefinitions.Definition columnDefinition = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().asList().get(column - 1) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1);
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnDefinition.getType().toString());
                int length = -1;
                if (jdbcEquivalentType != null) {
                    length = jdbcEquivalentType.getPrecision(null);
                }
                return length;
            }
            catch (Exception e) {
                return -1;
            }
        }

        @Override
        public int getColumnType(int column) {
            DataType type = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.getCqlDataType(column) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1).getType();
            return TypesMap.getTypeForComparator(type.toString()).getJdbcType();
        }

        @Override
        public String getColumnTypeName(int column) {
            try {
                DataType type = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.getCqlDataType(column) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().getType(column - 1);
                return type.toString();
            }
            catch (Exception e) {
                return "VARCHAR";
            }
        }

        @Override
        public int getPrecision(int column) {
            return Math.max(this.getColumnDisplaySize(column), 0);
        }

        @Override
        public int getScale(int column) {
            try {
                ColumnDefinitions.Definition columnDefinition = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().asList().get(column - 1) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().asList().get(column - 1);
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnDefinition.getType().toString());
                int scale = 0;
                if (jdbcEquivalentType != null) {
                    scale = jdbcEquivalentType.getScale(null);
                }
                return scale;
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public String getSchemaName(int column) throws SQLException {
            if (CassandraMetadataResultSet.this.statement == null) {
                return null;
            }
            return ((CassandraMetadataResultSet)CassandraMetadataResultSet.this).statement.connection.getSchema();
        }

        @Override
        public String getTableName(int column) {
            String tableName = CassandraMetadataResultSet.this.currentRow != null ? CassandraMetadataResultSet.this.currentRow.getColumnDefinitions().getTable(column - 1) : CassandraMetadataResultSet.this.driverResultSet.getColumnDefinitions().getTable(column - 1);
            return tableName;
        }

        @Override
        public boolean isAutoIncrement(int column) {
            return false;
        }

        @Override
        public boolean isCaseSensitive(int column) {
            return true;
        }

        @Override
        public boolean isCurrency(int column) {
            return false;
        }

        @Override
        public boolean isDefinitelyWritable(int column) {
            return this.isWritable(column);
        }

        @Override
        public int isNullable(int column) {
            return 1;
        }

        @Override
        public boolean isReadOnly(int column) {
            return column == 0;
        }

        @Override
        public boolean isSearchable(int column) {
            return false;
        }

        @Override
        public boolean isSigned(int column) {
            return false;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public boolean isWritable(int column) {
            return column > 0;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new SQLFeatureNotSupportedException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
        }
    }
}

