/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdBlob;

public final class FBBlobInputStream
extends InputStream
implements FirebirdBlob.BlobInputStream {
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private byte[] buffer = EMPTY_BUFFER;
    private FbBlob blobHandle;
    private int pos = 0;
    private boolean closed;
    private final FBBlob owner;

    FBBlobInputStream(FBBlob owner) throws SQLException {
        if (owner.isNew()) {
            throw new FBSQLException("You can't read a new blob");
        }
        this.owner = owner;
        this.closed = false;
        try (LockCloseable ignored = owner.withLock();){
            this.blobHandle = owner.openBlob();
        }
    }

    @Override
    public FirebirdBlob getBlob() {
        return this.owner;
    }

    @Override
    public void seek(int position) throws IOException {
        this.seek(position, FbBlob.SeekMode.ABSOLUTE);
    }

    @Override
    public void seek(int position, int seekMode) throws IOException {
        this.seek(position, FbBlob.SeekMode.getById(seekMode));
    }

    public void seek(int position, FbBlob.SeekMode seekMode) throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            this.blobHandle.seek(position, seekMode);
        }
        catch (SQLException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long length() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            long l = this.blobHandle.length();
            return l;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.buffer.length - this.pos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int checkBuffer() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            this.checkClosed();
            if (this.pos < this.buffer.length) {
                int n = this.buffer.length - this.pos;
                return n;
            }
            if (this.blobHandle.isEof()) {
                int n = -1;
                return n;
            }
            this.buffer = this.blobHandle.getSegment(this.owner.getBufferLength());
            this.pos = 0;
            int n = this.buffer.length != 0 ? this.buffer.length : -1;
            return n;
        }
        catch (SQLException ge) {
            throw new IOException("Blob read problem: " + ge, ge);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.checkBuffer() == -1) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int toCopy = Math.min(this.checkBuffer(), len);
        if (toCopy == -1) {
            return -1;
        }
        System.arraycopy(this.buffer, this.pos, b, off, toCopy);
        this.pos += toCopy;
        return toCopy;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int counter = 0;
        int pos = off;
        byte[] buffer = new byte[Math.min(this.owner.getBufferLength(), len)];
        for (int toRead = len; toRead > 0 && (counter = this.read(buffer, 0, Math.min(toRead, buffer.length))) != -1; toRead -= counter) {
            System.arraycopy(buffer, 0, b, pos, counter);
            pos += counter;
        }
        if (counter == -1) {
            throw new EOFException();
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        try (LockCloseable ignored = this.owner.withLock();){
            if (this.blobHandle == null) {
                return;
            }
            try {
                this.blobHandle.close();
                this.owner.notifyClosed(this);
            }
            catch (SQLException ge) {
                throw new IOException("couldn't close blob: " + ge);
            }
            finally {
                this.blobHandle = null;
                this.closed = true;
                this.buffer = EMPTY_BUFFER;
                this.pos = 0;
            }
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Input stream is already closed.");
        }
    }
}

