/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import schemacrawler.tools.command.text.diagram.DiagramRenderer;
import schemacrawler.tools.command.text.diagram.GraphExecutorFactory;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOptionsBuilder;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import schemacrawler.tools.command.text.schema.options.CommandProviderUtility;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;

public final class DiagramCommandProvider
extends BaseCommandProvider {
    public DiagramCommandProvider() {
        super(CommandProviderUtility.schemaTextCommands());
    }

    public DiagramRenderer newSchemaCrawlerCommand(String command, Config config) {
        DiagramOptions diagramOptions = DiagramOptionsBuilder.builder().fromConfig(config).toOptions();
        DiagramRenderer scCommand = new DiagramRenderer(command, new GraphExecutorFactory());
        scCommand.setCommandOptions(diagramOptions);
        return scCommand;
    }

    @Override
    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return this.supportsOutputFormat(command, outputOptions, format -> {
            DiagramOutputFormat diagramOutputFormat = DiagramOutputFormat.fromFormat(format);
            boolean supportsOutputFormat = DiagramOutputFormat.isSupportedFormat(format) && diagramOutputFormat != DiagramOutputFormat.htmlx;
            return supportsOutputFormat;
        });
    }
}

