/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.schemacrawler.exceptions.WrappedSQLException;
import us.fatehi.utility.Utility;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TaskRunner;
import us.fatehi.utility.scheduler.TaskRunners;
import us.fatehi.utility.string.StringFormat;

final class TableColumnRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(TableColumnRetriever.class.getName());

    TableColumnRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    void retrieveTableColumns(NamedObjectList<MutableTable> allTables, InclusionRule columnInclusionRule) throws SQLException {
        Objects.requireNonNull(allTables, "No tables provided");
        InclusionRuleFilter<Column> columnFilter = new InclusionRuleFilter<Column>(columnInclusionRule, true);
        if (columnFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving table columns, since this was not requested");
            return;
        }
        Set<NamedObjectKey> hiddenTableColumnsLookupKeys = this.retrieveHiddenTableColumnsLookupKeys();
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.tableColumnsRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving table columns, using fast data dictionary retrieval");
                this.retrieveTableColumnsFromDataDictionary(allTables, columnFilter, hiddenTableColumnsLookupKeys);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving table columns");
                this.retrieveTableColumnsFromMetadata(allTables, columnFilter, hiddenTableColumnsLookupKeys);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving table columns");
            }
        }
    }

    private void createTableColumn(MetadataResultSet results, NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<NamedObjectKey> hiddenTableColumnsLookupKeys) {
        String defaultValue = results.getString("COLUMN_DEF");
        String catalogName = this.normalizeCatalogName(results.getString("TABLE_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEM"));
        String tableName = results.getString("TABLE_NAME");
        String columnName = results.getString("COLUMN_NAME");
        LOGGER.log(Level.FINE, new StringFormat("Retrieving table column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
        if (Utility.isBlank(columnName)) {
            return;
        }
        Optional<MutableTable> optionalTable = allTables.lookup(new NamedObjectKey(catalogName, schemaName, tableName));
        if (!optionalTable.isPresent()) {
            return;
        }
        MutableTable table = optionalTable.get();
        MutableColumn column = this.lookupOrCreateTableColumn(table, columnName);
        column.withQuoting(this.getRetrieverConnection().getIdentifiers());
        if (columnFilter.test(column) && this.belongsToSchema(table, catalogName, schemaName)) {
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int size = results.getInt("COLUMN_SIZE", 0);
            int decimalDigits = results.getInt("DECIMAL_DIGITS", 0);
            boolean isNullable = results.getInt("NULLABLE", 2) == 1;
            boolean isAutoIncremented = results.getBoolean("IS_AUTOINCREMENT");
            boolean isGenerated = results.getBoolean("IS_GENERATEDCOLUMN");
            String remarks = results.getString("REMARKS");
            boolean isHidden = hiddenTableColumnsLookupKeys.contains(column.key());
            column.setOrdinalPosition(ordinalPosition);
            column.setColumnDataType(this.lookupOrCreateColumnDataType(DataTypeType.user_defined, table.getSchema(), dataType, this.getColumnTypeName(typeName)));
            column.setSize(size);
            column.setDecimalDigits(decimalDigits);
            column.setNullable(isNullable);
            column.setAutoIncremented(isAutoIncremented);
            column.setGenerated(isGenerated);
            column.setRemarks(remarks);
            if (defaultValue != null) {
                column.setDefaultValue(defaultValue);
            }
            column.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding %scolumn to table <%s>", isHidden ? "hidden " : "", column));
            if (isHidden) {
                column.setHidden(true);
                table.addHiddenColumn(column);
            } else {
                table.addColumn(column);
            }
        }
    }

    private String getColumnTypeName(String typeName) {
        Identifiers identifiers;
        String[] split;
        String columnDataTypeName = null;
        if (!Utility.isBlank(typeName) && (split = typeName.split("\\.")).length > 0) {
            columnDataTypeName = split[split.length - 1];
        }
        if (Utility.isBlank(columnDataTypeName = (identifiers = this.getRetrieverConnection().getIdentifiers()).unquoteName(columnDataTypeName))) {
            columnDataTypeName = typeName;
        }
        return columnDataTypeName;
    }

    private MutableColumn lookupOrCreateTableColumn(MutableTable table, String columnName) {
        Optional<MutableColumn> columnOptional = table.lookupColumn(columnName);
        return columnOptional.orElseGet(() -> new MutableColumn(table, columnName));
    }

    private Set<NamedObjectKey> retrieveHiddenTableColumnsLookupKeys() throws SQLException {
        ConcurrentHashMap.KeySetView hiddenTableColumnsLookupKeys = ConcurrentHashMap.newKeySet();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.EXT_HIDDEN_TABLE_COLUMNS)) {
            LOGGER.log(Level.INFO, "No hidden table columns SQL provided");
            return hiddenTableColumnsLookupKeys;
        }
        Query hiddenColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.EXT_HIDDEN_TABLE_COLUMNS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(hiddenColumnsSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("TABLE_SCHEMA"));
                String tableName = results.getString("TABLE_NAME");
                String columnName = results.getString("COLUMN_NAME");
                LOGGER.log(Level.FINE, new StringFormat("Retrieving hidden column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
                NamedObjectKey lookupKey = new NamedObjectKey(catalogName, schemaName, tableName, columnName);
                hiddenTableColumnsLookupKeys.add(lookupKey);
            }
        }
        return hiddenTableColumnsLookupKeys;
    }

    private void retrieveTableColumnsFromDataDictionary(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<NamedObjectKey> hiddenTableColumnsLookupKeys) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_COLUMNS)) {
            throw new ExecutionRuntimeException("No table columns SQL provided");
        }
        Query tableColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_COLUMNS);
        try (Connection connection = this.getRetrieverConnection().getConnection();
             Statement statement = connection.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableColumnsSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                this.createTableColumn(results, allTables, columnFilter, hiddenTableColumnsLookupKeys);
            }
        }
    }

    private void retrieveTableColumnsFromMetadata(NamedObjectList<MutableTable> allTables, InclusionRuleFilter<Column> columnFilter, Set<NamedObjectKey> hiddenTableColumnsLookupKeys) throws SQLException {
        try (TaskRunner taskRunner = TaskRunners.getTaskRunner("retrieve-table-columns-from-metadata", 5);){
            for (MutableTable table : allTables) {
                taskRunner.add(new TaskDefinition(table.getFullName(), () -> {
                    LOGGER.log(Level.FINE, new StringFormat("Retrieving table columns for <%s>", table));
                    try (Connection connection = this.getRetrieverConnection().getConnection();
                         MetadataResultSet results = new MetadataResultSet(connection.getMetaData().getColumns(table.getSchema().getCatalogName(), table.getSchema().getName(), table.getName(), null), "DatabaseMetaData::getColumns");){
                        while (results.next()) {
                            this.createTableColumn(results, allTables, columnFilter, hiddenTableColumnsLookupKeys);
                        }
                    }
                    catch (SQLException e) {
                        throw new WrappedSQLException(String.format("Could not retrieve table columns for %s <%s>", table.getTableType(), table), e);
                    }
                }));
            }
            taskRunner.submit();
        }
        catch (SQLException | SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException(e.getMessage(), e);
        }
    }
}

