/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import picocli.CommandLine;
import schemacrawler.schemacrawler.FilterOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;

@CommandLine.Command(name="filter", header={"** Filter database object metadata"}, description={""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"filter"}, optionListHeading="Options:%n")
public final class FilterCommand
extends BaseStateHolder
implements Runnable {
    @CommandLine.Option(names={"--children"}, description={"<children> is the number of generations of descendants for the tables selected by grep, and shown in the results", "Optional, default is 0"})
    private Integer children;
    @CommandLine.Option(names={"--parents"}, description={"<parents> is the number of generations of ancestors for the tables selected by grep, and shown in the results", "Optional, default is 0"})
    private Integer parents;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public FilterCommand(ShellState state) {
        super(state);
    }

    @Override
    public void run() {
        SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
        FilterOptionsBuilder optionsBuilder = FilterOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getFilterOptions());
        if (this.parents != null) {
            if (this.parents >= 0) {
                optionsBuilder.parentTableFilterDepth(this.parents.intValue());
            } else {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Please provide a valid value for --parents");
            }
        }
        if (this.children != null) {
            if (this.children >= 0) {
                optionsBuilder.childTableFilterDepth(this.children.intValue());
            } else {
                throw new CommandLine.ParameterException(this.spec.commandLine(), "Please provide a valid value for --children");
            }
        }
        this.state.withFilterOptions(optionsBuilder.toOptions());
    }
}

