/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLNonTransientException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.management.TableStatistics;

public final class FBTableStatisticsManager
implements AutoCloseable {
    private Map<Integer, String> tableMapping = new HashMap<Integer, String>();
    private FirebirdConnection connection;

    private FBTableStatisticsManager(FirebirdConnection connection) throws SQLException {
        if (connection.isClosed()) {
            throw new SQLNonTransientConnectionException("This connection is closed and cannot be used now.", "08003");
        }
        this.connection = connection;
    }

    public static FBTableStatisticsManager of(Connection connection) throws SQLException {
        return new FBTableStatisticsManager(connection.unwrap(FirebirdConnection.class));
    }

    public Map<String, TableStatistics> getTableStatistics() throws SQLException {
        this.checkClosed();
        FbDatabase db = this.connection.getFbDatabase();
        return db.getDatabaseInfo(FBTableStatisticsManager.getInfoItems(), FBTableStatisticsManager.bufferSize(this.tableMapping.size()), new TableStatisticsProcessor());
    }

    @Override
    public void close() {
        this.connection = null;
        this.tableMapping.clear();
        this.tableMapping = null;
    }

    private void checkClosed() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return;
        }
        if (this.connection != null) {
            this.close();
        }
        throw new SQLNonTransientException("This statistics manager is closed and cannot be used now.");
    }

    private void updateTableMapping() throws SQLException {
        DatabaseMetaData md = this.connection.getMetaData();
        try (ResultSet rs = md.getTables(null, null, "%", new String[]{"SYSTEM TABLE", "TABLE", "GLOBAL TEMPORARY"});){
            while (rs.next()) {
                this.tableMapping.put(rs.getInt("JB_RELATION_ID"), rs.getString("TABLE_NAME"));
            }
        }
    }

    private String getTableName(Integer tableId) throws SQLException {
        String tableName = this.tableMapping.get(tableId);
        if (tableName == null) {
            this.updateTableMapping();
            tableName = this.tableMapping.get(tableId);
            if (tableName == null) {
                tableName = "UNKNOWN_TABLE_ID_" + tableId;
            }
        }
        return tableName;
    }

    private static int bufferSize(int maxTables) {
        long size = 1L + 8L * (3L + 6L * (long)maxTables);
        if (size <= 0L) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.min(size, Integer.MAX_VALUE);
    }

    private static byte[] getInfoItems() {
        return new byte[]{23, 24, 25, 26, 27, 28, 29, 30};
    }

    private final class TableStatisticsProcessor
    implements InfoProcessor<Map<String, TableStatistics>> {
        private final Map<String, TableStatistics.TableStatisticsBuilder> statisticsBuilders = new HashMap<String, TableStatistics.TableStatisticsBuilder>();

        private TableStatisticsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, TableStatistics> process(byte[] infoResponse) throws SQLException {
            try {
                int idx = 0;
                block8: while (idx < infoResponse.length) {
                    byte infoItem = infoResponse[idx++];
                    switch (infoItem) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            Logger logger = LoggerFactory.getLogger(TableStatisticsProcessor.class);
                            logger.debug("Received truncation processing table statistics, this is likely an implementation bug");
                            break;
                        }
                        case 23: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            int length = VaxEncoding.iscVaxInteger2(infoResponse, idx);
                            this.processStatistics(infoItem, infoResponse, idx += 2, idx += length);
                            continue block8;
                        }
                        default: {
                            LoggerFactory.getLogger(TableStatisticsProcessor.class).debugf("Received unexpected info item %d, this is likely an implementation bug.", (Object)infoItem);
                            break;
                        }
                    }
                    break;
                }
                Map<String, TableStatistics> map = this.statisticsBuilders.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TableStatistics.TableStatisticsBuilder)e.getValue()).toTableStatistics()));
                return map;
            }
            finally {
                this.statisticsBuilders.clear();
            }
        }

        void processStatistics(int statistic, byte[] buffer, int start, int end) throws SQLException {
            for (int idx = start; idx <= end - 6; idx += 4) {
                int tableId = VaxEncoding.iscVaxInteger2(buffer, idx);
                long value = VaxEncoding.iscVaxInteger(buffer, idx += 2, 4);
                this.getBuilder(tableId).addStatistic(statistic, value);
            }
        }

        private TableStatistics.TableStatisticsBuilder getBuilder(int tableId) throws SQLException {
            String tableName = FBTableStatisticsManager.this.getTableName(tableId);
            return this.statisticsBuilders.computeIfAbsent(tableName, TableStatistics::builder);
        }
    }
}

