/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.odps.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.dialect.odps.ast.OdpsCreateTableStatement;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsExprParser;
import com.alibaba.druid.sql.dialect.odps.parser.OdpsSelectParser;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;

public class OdpsCreateTableParser
extends SQLCreateTableParser {
    public OdpsCreateTableParser(String sql) {
        super(new OdpsExprParser(sql));
    }

    public OdpsCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    @Override
    public SQLCreateTableStatement parseCrateTable(boolean acceptCreate) {
        SQLColumnDefinition column;
        OdpsCreateTableStatement stmt = new OdpsCreateTableStatement();
        if (acceptCreate) {
            this.accept(Token.CREATE);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.identifierEquals("LIFECYCLE")) {
            this.lexer.nextToken();
            stmt.setLifecycle(this.exprParser.expr());
        }
        if (this.lexer.token() == Token.LIKE) {
            this.lexer.nextToken();
            SQLName name = this.exprParser.name();
            stmt.setLike(name);
        } else if (this.lexer.token() == Token.AS) {
            this.lexer.nextToken();
            OdpsSelectParser selectParser = new OdpsSelectParser(this.exprParser);
            SQLSelect select = selectParser.select();
            stmt.setSelect(select);
        } else {
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier");
                }
                column = this.exprParser.parseColumn();
                stmt.getTableElementList().add(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token() == Token.COMMENT) {
            this.lexer.nextToken();
            stmt.setComment(this.exprParser.primary());
        }
        if (this.lexer.token() == Token.PARTITIONED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier");
                }
                column = this.exprParser.parseColumn();
                stmt.getPartitionColumns().add(column);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (this.identifierEquals("LIFECYCLE")) {
            this.lexer.nextToken();
            stmt.setLifecycle(this.exprParser.expr());
        }
        return stmt;
    }
}

