/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.HostOffering;
import software.amazon.awssdk.services.ec2.model.HostOfferingSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHostReservationOfferingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHostReservationOfferingsResponse.getter(DescribeHostReservationOfferingsResponse::nextToken)).setter(DescribeHostReservationOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<HostOffering>> OFFERING_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OfferingSet").getter(DescribeHostReservationOfferingsResponse.getter(DescribeHostReservationOfferingsResponse::offeringSet)).setter(DescribeHostReservationOfferingsResponse.setter(Builder::offeringSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingSet").unmarshallLocationName("offeringSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, OFFERING_SET_FIELD));
    private final String nextToken;
    private final List<HostOffering> offeringSet;

    private DescribeHostReservationOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.offeringSet = builder.offeringSet;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOfferingSet() {
        return this.offeringSet != null && !(this.offeringSet instanceof SdkAutoConstructList);
    }

    public final List<HostOffering> offeringSet() {
        return this.offeringSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOfferingSet() ? this.offeringSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostReservationOfferingsResponse)) {
            return false;
        }
        DescribeHostReservationOfferingsResponse other = (DescribeHostReservationOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOfferingSet() == other.hasOfferingSet() && Objects.equals(this.offeringSet(), other.offeringSet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHostReservationOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("OfferingSet", this.hasOfferingSet() ? this.offeringSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OfferingSet": {
                return Optional.ofNullable(clazz.cast(this.offeringSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHostReservationOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeHostReservationOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<HostOffering> offeringSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostReservationOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.offeringSet(model.offeringSet);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<HostOffering.Builder> getOfferingSet() {
            List<HostOffering.Builder> result = HostOfferingSetCopier.copyToBuilder(this.offeringSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOfferingSet(Collection<HostOffering.BuilderImpl> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copyFromBuilder(offeringSet);
        }

        @Override
        public final Builder offeringSet(Collection<HostOffering> offeringSet) {
            this.offeringSet = HostOfferingSetCopier.copy(offeringSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(HostOffering ... offeringSet) {
            this.offeringSet(Arrays.asList(offeringSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offeringSet(Consumer<HostOffering.Builder> ... offeringSet) {
            this.offeringSet(Stream.of(offeringSet).map(c -> (HostOffering)((HostOffering.Builder)HostOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeHostReservationOfferingsResponse build() {
            return new DescribeHostReservationOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHostReservationOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder offeringSet(Collection<HostOffering> var1);

        public Builder offeringSet(HostOffering ... var1);

        public Builder offeringSet(Consumer<HostOffering.Builder> ... var1);
    }
}

