"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = alertingADPlugin;

var _constants = require("../../services/utils/constants");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function alertingADPlugin(Client, config, components) {
  const ca = components.clientAction.factory;
  Client.prototype.alertingAD = components.clientAction.namespaceFactory();
  const alertingAD = Client.prototype.alertingAD.prototype;
  alertingAD.getDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    method: 'GET'
  });
  alertingAD.searchDetectors = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/_search`
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.previewDetector = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/<%=detectorId%>/_preview`,
      req: {
        detectorId: {
          type: 'string',
          required: true
        }
      }
    },
    needBody: true,
    method: 'POST'
  });
  alertingAD.searchResults = ca({
    url: {
      fmt: `${_constants.AD_BASE_API}/results/_search`
    },
    needBody: true,
    method: 'POST'
  });
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkUGx1Z2luLmpzIl0sIm5hbWVzIjpbImFsZXJ0aW5nQURQbHVnaW4iLCJDbGllbnQiLCJjb25maWciLCJjb21wb25lbnRzIiwiY2EiLCJjbGllbnRBY3Rpb24iLCJmYWN0b3J5IiwicHJvdG90eXBlIiwiYWxlcnRpbmdBRCIsIm5hbWVzcGFjZUZhY3RvcnkiLCJnZXREZXRlY3RvciIsInVybCIsImZtdCIsIkFEX0JBU0VfQVBJIiwicmVxIiwiZGV0ZWN0b3JJZCIsInR5cGUiLCJyZXF1aXJlZCIsIm1ldGhvZCIsInNlYXJjaERldGVjdG9ycyIsIm5lZWRCb2R5IiwicHJldmlld0RldGVjdG9yIiwic2VhcmNoUmVzdWx0cyJdLCJtYXBwaW5ncyI6Ijs7Ozs7OztBQUtBOztBQUxBO0FBQ0E7QUFDQTtBQUNBO0FBSWUsU0FBU0EsZ0JBQVQsQ0FBMEJDLE1BQTFCLEVBQWtDQyxNQUFsQyxFQUEwQ0MsVUFBMUMsRUFBc0Q7QUFDbkUsUUFBTUMsRUFBRSxHQUFHRCxVQUFVLENBQUNFLFlBQVgsQ0FBd0JDLE9BQW5DO0FBRUFMLEVBQUFBLE1BQU0sQ0FBQ00sU0FBUCxDQUFpQkMsVUFBakIsR0FBOEJMLFVBQVUsQ0FBQ0UsWUFBWCxDQUF3QkksZ0JBQXhCLEVBQTlCO0FBQ0EsUUFBTUQsVUFBVSxHQUFHUCxNQUFNLENBQUNNLFNBQVAsQ0FBaUJDLFVBQWpCLENBQTRCRCxTQUEvQztBQUVBQyxFQUFBQSxVQUFVLENBQUNFLFdBQVgsR0FBeUJOLEVBQUUsQ0FBQztBQUMxQk8sSUFBQUEsR0FBRyxFQUFFO0FBQ0hDLE1BQUFBLEdBQUcsRUFBRyxHQUFFQyxzQkFBWSxrQkFEakI7QUFFSEMsTUFBQUEsR0FBRyxFQUFFO0FBQ0hDLFFBQUFBLFVBQVUsRUFBRTtBQUNWQyxVQUFBQSxJQUFJLEVBQUUsUUFESTtBQUVWQyxVQUFBQSxRQUFRLEVBQUU7QUFGQTtBQURUO0FBRkYsS0FEcUI7QUFVMUJDLElBQUFBLE1BQU0sRUFBRTtBQVZrQixHQUFELENBQTNCO0FBYUFWLEVBQUFBLFVBQVUsQ0FBQ1csZUFBWCxHQUE2QmYsRUFBRSxDQUFDO0FBQzlCTyxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLHNCQUFZO0FBRGpCLEtBRHlCO0FBSTlCTyxJQUFBQSxRQUFRLEVBQUUsSUFKb0I7QUFLOUJGLElBQUFBLE1BQU0sRUFBRTtBQUxzQixHQUFELENBQS9CO0FBT0FWLEVBQUFBLFVBQVUsQ0FBQ2EsZUFBWCxHQUE2QmpCLEVBQUUsQ0FBQztBQUM5Qk8sSUFBQUEsR0FBRyxFQUFFO0FBQ0hDLE1BQUFBLEdBQUcsRUFBRyxHQUFFQyxzQkFBWSwyQkFEakI7QUFFSEMsTUFBQUEsR0FBRyxFQUFFO0FBQ0hDLFFBQUFBLFVBQVUsRUFBRTtBQUNWQyxVQUFBQSxJQUFJLEVBQUUsUUFESTtBQUVWQyxVQUFBQSxRQUFRLEVBQUU7QUFGQTtBQURUO0FBRkYsS0FEeUI7QUFVOUJHLElBQUFBLFFBQVEsRUFBRSxJQVZvQjtBQVc5QkYsSUFBQUEsTUFBTSxFQUFFO0FBWHNCLEdBQUQsQ0FBL0I7QUFhQVYsRUFBQUEsVUFBVSxDQUFDYyxhQUFYLEdBQTJCbEIsRUFBRSxDQUFDO0FBQzVCTyxJQUFBQSxHQUFHLEVBQUU7QUFDSEMsTUFBQUEsR0FBRyxFQUFHLEdBQUVDLHNCQUFZO0FBRGpCLEtBRHVCO0FBSTVCTyxJQUFBQSxRQUFRLEVBQUUsSUFKa0I7QUFLNUJGLElBQUFBLE1BQU0sRUFBRTtBQUxvQixHQUFELENBQTdCO0FBT0QiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IEFEX0JBU0VfQVBJIH0gZnJvbSAnLi4vLi4vc2VydmljZXMvdXRpbHMvY29uc3RhbnRzJztcblxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gYWxlcnRpbmdBRFBsdWdpbihDbGllbnQsIGNvbmZpZywgY29tcG9uZW50cykge1xuICBjb25zdCBjYSA9IGNvbXBvbmVudHMuY2xpZW50QWN0aW9uLmZhY3Rvcnk7XG5cbiAgQ2xpZW50LnByb3RvdHlwZS5hbGVydGluZ0FEID0gY29tcG9uZW50cy5jbGllbnRBY3Rpb24ubmFtZXNwYWNlRmFjdG9yeSgpO1xuICBjb25zdCBhbGVydGluZ0FEID0gQ2xpZW50LnByb3RvdHlwZS5hbGVydGluZ0FELnByb3RvdHlwZTtcblxuICBhbGVydGluZ0FELmdldERldGVjdG9yID0gY2Eoe1xuICAgIHVybDoge1xuICAgICAgZm10OiBgJHtBRF9CQVNFX0FQSX0vPCU9ZGV0ZWN0b3JJZCU+YCxcbiAgICAgIHJlcToge1xuICAgICAgICBkZXRlY3RvcklkOiB7XG4gICAgICAgICAgdHlwZTogJ3N0cmluZycsXG4gICAgICAgICAgcmVxdWlyZWQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0sXG4gICAgbWV0aG9kOiAnR0VUJyxcbiAgfSk7XG5cbiAgYWxlcnRpbmdBRC5zZWFyY2hEZXRlY3RvcnMgPSBjYSh7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FEX0JBU0VfQVBJfS9fc2VhcmNoYCxcbiAgICB9LFxuICAgIG5lZWRCb2R5OiB0cnVlLFxuICAgIG1ldGhvZDogJ1BPU1QnLFxuICB9KTtcbiAgYWxlcnRpbmdBRC5wcmV2aWV3RGV0ZWN0b3IgPSBjYSh7XG4gICAgdXJsOiB7XG4gICAgICBmbXQ6IGAke0FEX0JBU0VfQVBJfS88JT1kZXRlY3RvcklkJT4vX3ByZXZpZXdgLFxuICAgICAgcmVxOiB7XG4gICAgICAgIGRldGVjdG9ySWQ6IHtcbiAgICAgICAgICB0eXBlOiAnc3RyaW5nJyxcbiAgICAgICAgICByZXF1aXJlZDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfSxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgICBtZXRob2Q6ICdQT1NUJyxcbiAgfSk7XG4gIGFsZXJ0aW5nQUQuc2VhcmNoUmVzdWx0cyA9IGNhKHtcbiAgICB1cmw6IHtcbiAgICAgIGZtdDogYCR7QURfQkFTRV9BUEl9L3Jlc3VsdHMvX3NlYXJjaGAsXG4gICAgfSxcbiAgICBuZWVkQm9keTogdHJ1ZSxcbiAgICBtZXRob2Q6ICdQT1NUJyxcbiAgfSk7XG59XG4iXX0=