/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search.comparators;

import java.io.IOException;
import java.math.BigInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.BigIntegerPoint;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.comparators.NumericComparator;
import org.opensearch.common.Numbers;

public class UnsignedLongComparator
extends NumericComparator<BigInteger> {
    private final BigInteger[] values;
    protected BigInteger topValue;
    protected BigInteger bottom;

    public UnsignedLongComparator(int numHits, String field, BigInteger missingValue, boolean reverse, boolean enableSkipping) {
        super(field, (Number)(missingValue != null ? missingValue : Numbers.MIN_UNSIGNED_LONG_VALUE), reverse, enableSkipping, 16);
        this.values = new BigInteger[numHits];
    }

    public int compare(int slot1, int slot2) {
        return this.values[slot1].compareTo(this.values[slot2]);
    }

    public void setTopValue(BigInteger value) {
        super.setTopValue((Number)value);
        this.topValue = value;
    }

    public BigInteger value(int slot) {
        return this.values[slot];
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new UnsignedLongLeafComparator(context);
    }

    public class UnsignedLongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public UnsignedLongLeafComparator(LeafReaderContext context) throws IOException {
            super((NumericComparator)UnsignedLongComparator.this, context);
        }

        private BigInteger getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Numbers.toUnsignedBigInteger((long)this.docValues.longValue());
            }
            return (BigInteger)UnsignedLongComparator.this.missingValue;
        }

        public void setBottom(int slot) throws IOException {
            UnsignedLongComparator.this.bottom = UnsignedLongComparator.this.values[slot];
            super.setBottom(slot);
        }

        public int compareBottom(int doc) throws IOException {
            return UnsignedLongComparator.this.bottom.compareTo(this.getValueForDoc(doc));
        }

        public int compareTop(int doc) throws IOException {
            return UnsignedLongComparator.this.topValue.compareTo(this.getValueForDoc(doc));
        }

        public void copy(int slot, int doc) throws IOException {
            UnsignedLongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        protected boolean isMissingValueCompetitive() {
            int result = ((BigInteger)UnsignedLongComparator.this.missingValue).compareTo(UnsignedLongComparator.this.bottom);
            return UnsignedLongComparator.this.reverse ? result >= 0 : result <= 0;
        }

        protected void encodeBottom(byte[] packedValue) {
            BigIntegerPoint.encodeDimension((BigInteger)UnsignedLongComparator.this.bottom, (byte[])packedValue, (int)0);
        }

        protected void encodeTop(byte[] packedValue) {
            BigIntegerPoint.encodeDimension((BigInteger)UnsignedLongComparator.this.topValue, (byte[])packedValue, (int)0);
        }
    }
}

