/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum AccessLogLevel {
    CALL("call", 0),
    EXCEPTION("exception", 1),
    RUNTIMEEXCEPTION("runtimeexception", 2),
    ERROR("error", 3),
    OFF("off", 4);

    private static AccessLogLevel accessLogLevelInstance;
    private final String description;
    private final byte hierarchy;
    private static final Log log;

    private AccessLogLevel(String description, byte hierarchy) {
        this.description = description;
        this.hierarchy = hierarchy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessLogLevel getValue(String accessLogLevelString, boolean debug) {
        if (null != accessLogLevelInstance) return accessLogLevelInstance;
        Class<AccessLogLevel> clazz = AccessLogLevel.class;
        synchronized (AccessLogLevel.class) {
            if (null != accessLogLevelInstance) return accessLogLevelInstance;
            try {
                accessLogLevelString = accessLogLevelString.toUpperCase();
                accessLogLevelInstance = AccessLogLevel.valueOf(accessLogLevelString);
            }
            catch (Exception e) {
                if (!debug) {
                    if (null != accessLogLevelString) {
                        log.info((Object)("DWR is disabling logging.  " + accessLogLevelString + " is not a valid accessLogLevel.  Valid accessLogLevel's are: CALL, EXCEPTION, RUNTIMEEXCEPTION, and ERROR"));
                    }
                    accessLogLevelInstance = OFF;
                }
                if (null != accessLogLevelString) {
                    log.info((Object)(accessLogLevelString + " is not a valid accessLogLevel.  Valid accessLogLevel's are: CALL, EXCEPTION, RUNTIMEEXCEPTION, and ERROR.  Since the debug init-param has been set to true DWR will log all Exceptions."));
                }
                accessLogLevelInstance = EXCEPTION;
            }
            return accessLogLevelInstance;
        }
    }

    public String description() {
        return this.description;
    }

    public byte hierarchy() {
        return this.hierarchy;
    }

    static {
        log = LogFactory.getLog(AccessLogLevel.class);
    }
}

