/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.rules.spelling.SpellingCheckRule;

public class MultitokenSpellerFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        AnalyzedSentence sentence;
        boolean keepSpaces = this.getOptional("keepSpaces", arguments, "true").equalsIgnoreCase("true");
        PatternRule pr = (PatternRule)match.getRule();
        SpellingCheckRule spellingRule = pr.getLanguage().getDefaultSpellingRule();
        RuleMatch[] matches = spellingRule.match(sentence = new AnalyzedSentence(new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", "")), new AnalyzedTokenReadings(new AnalyzedToken(match.getOriginalErrorStr(), null, null))}));
        if (matches.length < 1 || matches[0].getSuggestedReplacements().isEmpty()) {
            return null;
        }
        ArrayList<String> replacements = new ArrayList<String>();
        if (keepSpaces) {
            replacements.addAll(matches[0].getSuggestedReplacements().stream().filter(str -> str.contains(" ")).collect(Collectors.toList()));
        } else {
            replacements.addAll(matches[0].getSuggestedReplacements());
        }
        if (replacements.isEmpty()) {
            return null;
        }
        match.setSuggestedReplacements(replacements);
        return match;
    }
}

