/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;

public abstract class AbstractNumberInWordFilter
extends RuleFilter {
    protected final Language language;
    public static final Pattern typoPattern = Pattern.compile("[0-9]");

    protected AbstractNumberInWordFilter(Language language) {
        this.language = language;
    }

    @Override
    @Nullable
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens) throws IOException {
        String word = arguments.get("word");
        String wordReplacingZeroO = word.replaceAll("0", "o");
        String wordWithoutNumberCharacter = typoPattern.matcher(word).replaceAll("");
        ArrayList<String> replacements = new ArrayList<String>();
        if (!this.isMisspelled(wordReplacingZeroO) && !word.equals(wordReplacingZeroO)) {
            replacements.add(wordReplacingZeroO);
        }
        if (!this.isMisspelled(wordWithoutNumberCharacter)) {
            replacements.add(wordWithoutNumberCharacter);
        }
        if (replacements.isEmpty()) {
            List<String> suggestions = this.getSuggestions(wordWithoutNumberCharacter);
            replacements.addAll(suggestions);
        }
        if (!replacements.isEmpty()) {
            RuleMatch ruleMatch = new RuleMatch(match);
            ruleMatch.setSuggestedReplacements(replacements);
            return ruleMatch;
        }
        return null;
    }

    protected abstract boolean isMisspelled(String var1) throws IOException;

    protected abstract List<String> getSuggestions(String var1) throws IOException;
}

