/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableList;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.execution.history.changes.IncrementalInputChanges;
import org.gradle.internal.execution.history.changes.IncrementalInputProperties;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.execution.history.changes.NonIncrementalInputChanges;

public interface ExecutionStateChanges {
    public ImmutableList<String> getChangeDescriptions();

    public InputChangesInternal createInputChanges();

    public BeforeExecutionState getBeforeExecutionState();

    public static ExecutionStateChanges incremental(final ImmutableList<String> changeDescriptions, final BeforeExecutionState beforeExecutionState, final InputFileChanges inputFileChanges, final IncrementalInputProperties incrementalInputProperties) {
        return new ExecutionStateChanges(){

            @Override
            public ImmutableList<String> getChangeDescriptions() {
                return changeDescriptions;
            }

            @Override
            public InputChangesInternal createInputChanges() {
                return new IncrementalInputChanges(inputFileChanges, incrementalInputProperties);
            }

            @Override
            public BeforeExecutionState getBeforeExecutionState() {
                return beforeExecutionState;
            }
        };
    }

    public static ExecutionStateChanges nonIncremental(final ImmutableList<String> changeDescriptions, final BeforeExecutionState beforeExecutionState, final IncrementalInputProperties incrementalInputProperties) {
        return new ExecutionStateChanges(){

            @Override
            public ImmutableList<String> getChangeDescriptions() {
                return changeDescriptions;
            }

            @Override
            public InputChangesInternal createInputChanges() {
                return new NonIncrementalInputChanges(beforeExecutionState.getInputFileProperties(), incrementalInputProperties);
            }

            @Override
            public BeforeExecutionState getBeforeExecutionState() {
                return beforeExecutionState;
            }
        };
    }
}

