/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.map.INodeDuplicator;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.NodeRelativePath;
import org.freeplane.features.styles.MapStyleModel;
import org.freeplane.plugin.codeexplorer.dependencies.CodeDependency;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.map.EmptyNodeModel;
import org.freeplane.plugin.codeexplorer.map.SubprojectFinder;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;

public class CodeMap
extends MapModel {
    private DependencyJudge judge = new DependencyJudge();
    private SubprojectFinder subprojectFinder = SubprojectFinder.EMPTY;

    public CodeMap(INodeDuplicator nodeDuplicator) {
        super(nodeDuplicator);
        AttributeRegistry.getRegistry((MapModel)this);
        this.setRoot(new EmptyNodeModel(this, "No locations selected"));
        this.getRootNode().setFolded(false);
    }

    protected Map<String, NodeModel> createNodeByIdMap() {
        return new ConcurrentHashMap<String, NodeModel>(){

            @Override
            public NodeModel put(String key, NodeModel value) {
                if (value == null) {
                    return (NodeModel)this.remove(key);
                }
                return super.put(key, value);
            }
        };
    }

    public String getTitle() {
        return "Code: " + this.getRootNode().toString();
    }

    public void setJudge(DependencyJudge judge) {
        this.judge = judge;
    }

    public DependencyJudge getJudge() {
        return this.judge;
    }

    public void setRoot(NodeModel newRoot) {
        MapStyleModel mapStyles;
        NodeModel oldRoot = this.getRootNode();
        if (oldRoot != null && (mapStyles = (MapStyleModel)oldRoot.getExtension(MapStyleModel.class)) != null) {
            newRoot.addExtension((IExtension)mapStyles);
        }
        super.setRoot(newRoot);
    }

    public void setSubprojectFinder(SubprojectFinder subprojectFinder) {
        this.subprojectFinder = subprojectFinder;
    }

    DependencyVerdict judge(Dependency dependency, boolean goesUp) {
        return this.judge.judge(dependency, goesUp);
    }

    public int subprojectIndexOf(JavaClass javaClass) {
        return this.subprojectFinder.subprojectIndexOf(javaClass);
    }

    public Stream<JavaClass> allClasses() {
        return this.subprojectFinder.allClasses();
    }

    public String getClassNodeId(JavaClass javaClass) {
        int subprojectIndex = this.subprojectIndexOf(javaClass);
        return this.getClassNodeId(javaClass, subprojectIndex);
    }

    private String getClassNodeId(JavaClass javaClass, int subprojectIndex) {
        JavaClass nodeClass = CodeNode.findEnclosingNamedClass(javaClass);
        String nodeClassName = nodeClass.getName();
        String classNodeId = CodeNode.idWithSubprojectIndex(nodeClassName, subprojectIndex);
        return classNodeId;
    }

    public CodeNode getNodeByClass(JavaClass javaClass) {
        String existingNodeId = this.getExistingNodeId(javaClass);
        return existingNodeId == null ? null : (CodeNode)this.getNodeForID(existingNodeId);
    }

    String getExistingNodeId(JavaClass javaClass) {
        int subprojectIndex = this.subprojectIndexOf(javaClass);
        return this.getClassNodeId(javaClass, subprojectIndex);
    }

    public CodeDependency toCodeDependency(Dependency dependency) {
        CodeNode originNode = this.getNodeByClass(dependency.getOriginClass());
        CodeNode targetNode = this.getNodeByClass(dependency.getTargetClass());
        if (originNode == null || targetNode == null) {
            throw new IllegalStateException("Can not find nodes for dependency " + dependency);
        }
        NodeRelativePath nodeRelativePath = new NodeRelativePath((NodeModel)originNode, (NodeModel)targetNode);
        boolean goesUp = nodeRelativePath.compareNodePositions() > 0;
        return new CodeDependency(dependency, goesUp, this.judge(dependency, goesUp));
    }
}

