/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer;

import java.util.Hashtable;
import org.freeplane.core.util.Compat;
import org.freeplane.features.mode.Controller;
import org.freeplane.main.application.CommandLineOptions;
import org.freeplane.main.mindmapmode.stylemode.ExtensionInstaller;
import org.freeplane.main.osgi.IControllerExtensionProvider;
import org.freeplane.plugin.codeexplorer.CodeModeController;
import org.freeplane.plugin.codeexplorer.CodeModeControllerFactory;
import org.freeplane.plugin.codeexplorer.configurator.CodeProjectController;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private CodeModeController modeController;

    public void start(BundleContext context) throws Exception {
        if (Compat.isJavaVersionLessThan((String)"11.")) {
            System.out.println("Java 11 is required for code explorer mode. Disabled.");
        } else {
            this.registerMindMapModeExtension(context);
        }
    }

    private void registerMindMapModeExtension(BundleContext context) {
        Hashtable props = new Hashtable();
        context.registerService(IControllerExtensionProvider.class.getName(), (Object)new IControllerExtensionProvider(){

            public void installExtension(Controller controller, CommandLineOptions options, ExtensionInstaller.Context context) {
                if (context == ExtensionInstaller.Context.MAIN && Activator.this.modeController == null) {
                    Activator.this.modeController = CodeModeControllerFactory.createModeController();
                }
            }
        }, props);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.modeController != null) {
            ((CodeProjectController)this.modeController.getExtension(CodeProjectController.class)).saveConfiguration();
        }
    }
}

