/*
 * Decompiled with CFR 0.152.
 */
package io.github.gitbucket.markedj;

import io.github.gitbucket.markedj.Grammer;
import io.github.gitbucket.markedj.Options;
import io.github.gitbucket.markedj.Utils;
import io.github.gitbucket.markedj.rule.Rule;
import io.github.gitbucket.markedj.token.BlockquoteEndToken;
import io.github.gitbucket.markedj.token.BlockquoteStartToken;
import io.github.gitbucket.markedj.token.CodeToken;
import io.github.gitbucket.markedj.token.HeadingToken;
import io.github.gitbucket.markedj.token.HrToken;
import io.github.gitbucket.markedj.token.HtmlToken;
import io.github.gitbucket.markedj.token.ListEndToken;
import io.github.gitbucket.markedj.token.ListItemEndToken;
import io.github.gitbucket.markedj.token.ListItemStartToken;
import io.github.gitbucket.markedj.token.ListStartToken;
import io.github.gitbucket.markedj.token.LooseItemStartToken;
import io.github.gitbucket.markedj.token.ParagraphToken;
import io.github.gitbucket.markedj.token.SpaceToken;
import io.github.gitbucket.markedj.token.TableToken;
import io.github.gitbucket.markedj.token.TextToken;
import io.github.gitbucket.markedj.token.Token;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class Lexer {
    protected Options options;
    protected Map<String, Rule> rules = null;

    public Lexer(Options options) {
        this.options = options;
        this.rules = !options.isGfm() ? Grammer.BLOCK_RULES : (options.isTables() ? Grammer.BLOCK_TABLE_RULES : Grammer.BLOCK_GFM_RULES);
    }

    public LexerResult lex(String src) {
        LexerContext context = new LexerContext();
        this.token(src.replace("\r\n", "\n").replace("\r", "\n").replace("\t", "    ").replace("\u00a0", " ").replace("\u2424", "\n"), true, false, context);
        return new LexerResult(context.getTokens(), context.getLinks());
    }

    protected void token(String src, boolean top, boolean bq, LexerContext context) {
        while (src.length() > 0) {
            String[] columns;
            ArrayList<List<String>> rowList;
            int maxColumns;
            ArrayList<String> alignList;
            List<String> headerList;
            String[] rows;
            String[] aligns;
            String[] headers;
            List<String> cap = this.rules.get("newline").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                if (cap.get(0).length() > 1) {
                    context.pushToken(new SpaceToken());
                }
            }
            if (!(cap = this.rules.get("code").exec(src)).isEmpty()) {
                src = src.substring(cap.get(0).length());
                String code = cap.get(0).replaceAll("(?m)^ {4}", "");
                context.pushToken(new CodeToken(code.replaceAll("\\n+$", ""), null, false));
                continue;
            }
            cap = this.rules.get("fences").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                String lang = cap.get(2);
                if (lang != null) {
                    lang = lang.replaceFirst("\\{.*}", "");
                }
                context.pushToken(new CodeToken(cap.get(3), Utils.trim(lang), false));
                continue;
            }
            cap = this.rules.get("heading").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                context.pushToken(new HeadingToken(cap.get(1).length(), cap.get(2)));
                continue;
            }
            if (top && !(cap = this.rules.get("nptable").exec(src)).isEmpty()) {
                src = src.substring(cap.get(0).length());
                headers = cap.get(1).replaceAll("^ *| *\\| *$", "").split(" *\\| *");
                aligns = cap.get(2).replaceAll("^ *|\\| *$", "").split(" *\\| *");
                rows = cap.get(3).replaceAll("\n$", "").split("\n");
                headerList = Utils.array2list(headers);
                alignList = new ArrayList<String>();
                for (String string : aligns) {
                    if (string.matches("^ *-+: *$")) {
                        alignList.add("right");
                        continue;
                    }
                    if (string.matches("^ *:-+: *$")) {
                        alignList.add("center");
                        continue;
                    }
                    if (string.matches("^ *:-+ *$")) {
                        alignList.add("left");
                        continue;
                    }
                    alignList.add(null);
                }
                maxColumns = Math.max(headers.length, aligns.length);
                rowList = new ArrayList<List<String>>();
                for (String string : rows) {
                    columns = string.split(" *\\| *");
                    if (maxColumns < columns.length) {
                        maxColumns = columns.length;
                    }
                    rowList.add(Utils.array2list(columns));
                }
                Utils.fillList(headerList, maxColumns, "");
                Utils.fillList(alignList, maxColumns, null);
                for (List list : rowList) {
                    Utils.fillList(list, maxColumns, "");
                }
                context.pushToken(new TableToken(headerList, alignList, rowList));
                continue;
            }
            cap = this.rules.get("lheading").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                if (cap.get(2).equals("=")) {
                    context.pushToken(new HeadingToken(1, cap.get(1)));
                    continue;
                }
                context.pushToken(new HeadingToken(2, cap.get(1)));
                continue;
            }
            cap = this.rules.get("hr").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                context.pushToken(new HrToken());
                continue;
            }
            cap = this.rules.get("blockquote").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                context.pushToken(new BlockquoteStartToken());
                this.token(cap.get(0).replaceAll("(?m)^ *> ?", ""), top, true, context);
                context.pushToken(new BlockquoteEndToken());
                continue;
            }
            cap = this.rules.get("list").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                String bull = cap.get(2);
                context.pushToken(new ListStartToken(bull.matches("^[0-9]+\\.$")));
                boolean next = false;
                cap = this.rules.get("item").exec(cap.get(0));
                if (!cap.isEmpty()) {
                    for (int i = 0; i < cap.size(); ++i) {
                        boolean loose;
                        String item = cap.get(i);
                        int space = item.length();
                        if ((item = item.replaceAll("^ *([*+-]|\\d+\\.) +", "")).indexOf("\n ") > 0) {
                            space -= item.length();
                            item = item.replaceAll("(?m)^ {1," + space + "}", "");
                        }
                        boolean bl = loose = next || item.matches("\\n\\n(?!\\s*$)");
                        if (i != cap.size() - 1) {
                            boolean bl2 = next = !item.isEmpty() && item.charAt(item.length() - 1) == '\n';
                            if (!loose) {
                                loose = next;
                            }
                        }
                        if (loose) {
                            context.pushToken(new LooseItemStartToken());
                        } else {
                            context.pushToken(new ListItemStartToken());
                        }
                        this.token(item, false, bq, context);
                        context.pushToken(new ListItemEndToken());
                    }
                }
                context.pushToken(new ListEndToken());
                continue;
            }
            cap = this.rules.get("html").exec(src);
            if (!cap.isEmpty()) {
                src = src.substring(cap.get(0).length());
                if (this.options.isSanitize()) {
                    context.pushToken(new ParagraphToken(cap.get(0)));
                    continue;
                }
                context.pushToken(new HtmlToken(cap.get(0)));
                continue;
            }
            if (!bq && top && !(cap = this.rules.get("def").exec(src)).isEmpty()) {
                src = src.substring(cap.get(0).length());
                context.defineLink(cap.get(1).toLowerCase(), new Link(cap.get(2), cap.get(3)));
                continue;
            }
            if (top && !(cap = this.rules.get("table").exec(src)).isEmpty()) {
                src = src.substring(cap.get(0).length());
                headers = cap.get(1).replaceAll("^ *| *\\| *$", "").split(" *\\| *");
                aligns = cap.get(2).replaceAll("^ *|\\| *$", "").split(" *\\| *");
                rows = cap.get(3).replaceAll("(?: *\\| *)?\\n$", "").split("\\n");
                headerList = Utils.array2list(headers);
                alignList = new ArrayList();
                for (String string : aligns) {
                    if (string.matches("^ *-+: *$")) {
                        alignList.add("right");
                        continue;
                    }
                    if (string.matches("^ *:-+: *$")) {
                        alignList.add("center");
                        continue;
                    }
                    if (string.matches("^ *:-+ *$")) {
                        alignList.add("left");
                        continue;
                    }
                    alignList.add(null);
                }
                maxColumns = Math.max(headers.length, aligns.length);
                rowList = new ArrayList();
                for (String string : rows) {
                    columns = string.replaceAll("^ *\\| *| *\\| *$", "").split(" *\\| *");
                    if (maxColumns < columns.length) {
                        maxColumns = columns.length;
                    }
                    rowList.add(Utils.array2list(columns));
                }
                Utils.fillList(headerList, maxColumns, "");
                Utils.fillList(alignList, maxColumns, null);
                for (List list : rowList) {
                    Utils.fillList(list, maxColumns, "");
                }
                context.pushToken(new TableToken(headerList, alignList, rowList));
                continue;
            }
            if (top && !(cap = this.rules.get("paragraph").exec(src)).isEmpty()) {
                src = src.substring(cap.get(0).length());
                if (cap.get(1).charAt(cap.get(1).length() - 1) == '\n') {
                    context.pushToken(new ParagraphToken(cap.get(1).substring(0, cap.get(1).length() - 1)));
                    continue;
                }
                context.pushToken(new ParagraphToken(cap.get(1)));
                continue;
            }
            cap = this.rules.get("text").exec(src);
            if (cap.isEmpty()) continue;
            src = src.substring(cap.get(0).length());
            context.pushToken(new TextToken(cap.get(0)));
        }
    }

    public static class Link {
        private String href;
        private String title;

        public Link(String href, String title) {
            this.href = href;
            this.title = title;
        }

        public String getHref() {
            return this.href;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class LexerResult {
        private Stack<Token> tokens;
        private Map<String, Link> links = new HashMap<String, Link>();

        public LexerResult(Stack<Token> tokens, Map<String, Link> links) {
            this.tokens = tokens;
            this.links = links;
        }

        public Stack<Token> getTokens() {
            return this.tokens;
        }

        public Map<String, Link> getLinks() {
            return this.links;
        }
    }

    public static class LexerContext {
        private Stack<Token> tokens = new Stack();
        private Map<String, Link> links = new HashMap<String, Link>();

        public void pushToken(Token token) {
            this.tokens.push(token);
        }

        public void defineLink(String key, Link link) {
            this.links.put(key, link);
        }

        public Stack<Token> getTokens() {
            return this.tokens;
        }

        public Map<String, Link> getLinks() {
            return this.links;
        }
    }
}

