/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodestyle;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collection;
import org.freeplane.api.Dash;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.api.TextWritingDirection;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.CombinedPropertyChain;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.FontUtils;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeCssHook;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleBuilder;
import org.freeplane.features.nodestyle.NodeStyleModel;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class NodeStyleController
implements IExtension {
    public static Color standardNodeTextColor = Color.BLACK;
    private final ExclusivePropertyChain<Color, NodeModel> backgroundColorHandlers;
    private final CombinedPropertyChain<Font, NodeModel> fontHandlers;
    private final ModeController modeController;
    public final ExclusivePropertyChain<NodeGeometryModel, NodeModel> shapeHandlers;
    private final ExclusivePropertyChain<Color, NodeModel> textColorHandlers;
    private final ExclusivePropertyChain<HorizontalTextAlignment, NodeModel> horizontalTextAlignmentHandlers;
    private final ExclusivePropertyChain<TextWritingDirection, NodeModel> textWritingDirectionHandlers;
    public static final String NODE_NUMBERING = "NodeNumbering";
    private static final Quantity<LengthUnit> DEFAULT_MINIMUM_WIDTH = new Quantity(0.0, (Enum)LengthUnit.cm);
    private static final Quantity<LengthUnit> DEFAULT_MAXIMUM_WIDTH = new Quantity(10.0, (Enum)LengthUnit.cm);

    public static NodeStyleController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return NodeStyleController.getController(modeController);
    }

    public static NodeStyleController getController(ModeController modeController) {
        return modeController.getExtension(NodeStyleController.class);
    }

    public static void install(NodeStyleController styleController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(NodeStyleController.class, styleController);
    }

    public NodeStyleController(final ModeController modeController) {
        this.modeController = modeController;
        new NodeCssHook();
        this.fontHandlers = new CombinedPropertyChain(true);
        this.fontHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Font, NodeModel>(){

            @Override
            public Font getProperty(NodeModel node, LogicalStyleController.StyleOption option, Font currentValue) {
                Font defaultFont = NodeStyleController.getDefaultFont();
                return defaultFont;
            }
        });
        this.fontHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<Font, NodeModel>(){

            @Override
            public Font getProperty(NodeModel node, LogicalStyleController.StyleOption option, Font currentValue) {
                Font defaultFont = NodeStyleController.this.getStyleFont(currentValue, node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
                return defaultFont;
            }
        });
        this.textColorHandlers = new ExclusivePropertyChain();
        this.textColorHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, LogicalStyleController.StyleOption option, Color currentValue) {
                return standardNodeTextColor;
            }
        });
        this.textColorHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, LogicalStyleController.StyleOption option, Color currentValue) {
                return NodeStyleController.this.getStyleTextColor(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.backgroundColorHandlers = new ExclusivePropertyChain();
        this.backgroundColorHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<Color, NodeModel>(){

            @Override
            public Color getProperty(NodeModel node, LogicalStyleController.StyleOption option, Color currentValue) {
                return NodeStyleController.this.getStyleBackgroundColor(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.shapeHandlers = new ExclusivePropertyChain();
        this.shapeHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<NodeGeometryModel, NodeModel>(){

            @Override
            public NodeGeometryModel getProperty(NodeModel node, LogicalStyleController.StyleOption option, NodeGeometryModel currentValue) {
                MapModel map = node.getMap();
                LogicalStyleController styleController = LogicalStyleController.getController(modeController);
                Collection<IStyle> style = styleController.getStyles(node, option);
                NodeGeometryModel returnedShape = NodeStyleController.this.getStyleShape(map, style);
                return returnedShape;
            }
        });
        this.shapeHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<NodeGeometryModel, NodeModel>(){

            @Override
            public NodeGeometryModel getProperty(NodeModel node, LogicalStyleController.StyleOption option, NodeGeometryModel currentValue) {
                return NodeGeometryModel.AS_PARENT;
            }
        });
        this.horizontalTextAlignmentHandlers = new ExclusivePropertyChain();
        this.horizontalTextAlignmentHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<HorizontalTextAlignment, NodeModel>(){

            @Override
            public HorizontalTextAlignment getProperty(NodeModel node, LogicalStyleController.StyleOption option, HorizontalTextAlignment currentValue) {
                return HorizontalTextAlignment.DEFAULT;
            }
        });
        this.horizontalTextAlignmentHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<HorizontalTextAlignment, NodeModel>(){

            @Override
            public HorizontalTextAlignment getProperty(NodeModel node, LogicalStyleController.StyleOption option, HorizontalTextAlignment currentValue) {
                return NodeStyleController.this.getHorizontalTextAlignment(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        this.textWritingDirectionHandlers = new ExclusivePropertyChain();
        this.textWritingDirectionHandlers.addGetter(IPropertyHandler.DEFAULT, new IPropertyHandler<TextWritingDirection, NodeModel>(){

            @Override
            public TextWritingDirection getProperty(NodeModel node, LogicalStyleController.StyleOption option, TextWritingDirection currentValue) {
                return TextWritingDirection.DEFAULT;
            }
        });
        this.textWritingDirectionHandlers.addGetter(IPropertyHandler.STYLE, new IPropertyHandler<TextWritingDirection, NodeModel>(){

            @Override
            public TextWritingDirection getProperty(NodeModel node, LogicalStyleController.StyleOption option, TextWritingDirection currentValue) {
                return NodeStyleController.this.getTextWritingDirection(node.getMap(), LogicalStyleController.getController(modeController).getStyles(node, option));
            }
        });
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        NodeStyleBuilder styleBuilder = new NodeStyleBuilder(this);
        styleBuilder.registerBy(readManager, writeManager);
    }

    public NodeCss getStyleSheet(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getStyleSheet(node.getMap(), LogicalStyleController.getController(this.modeController).getStyles(node, option));
    }

    private NodeCss getStyleSheet(MapModel map, Collection<IStyle> style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : style) {
            NodeCss nodeCss;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (nodeCss = styleNode.getExtension(NodeCss.class)) == null) continue;
            return nodeCss;
        }
        return NodeCss.EMPTY;
    }

    public Color getBackgroundColor(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.backgroundColorHandlers.getProperty(node, option);
    }

    public Color getColor(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.textColorHandlers.getProperty(node, option);
    }

    private Color getStyleBackgroundColor(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Color styleColor;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (styleColor = styleModel.getBackgroundColor()) == null) continue;
            return styleColor;
        }
        return null;
    }

    private Quantity<LengthUnit> getMaxNodeWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> maxTextWidth;
            NodeSizeModel sizeModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (sizeModel = NodeSizeModel.getModel(styleNode)) == null || (maxTextWidth = sizeModel.getMaxNodeWidth()) == null) continue;
            return maxTextWidth;
        }
        return DEFAULT_MAXIMUM_WIDTH;
    }

    private Quantity<LengthUnit> getStyleMinWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> minWidth;
            NodeSizeModel sizeModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (sizeModel = NodeSizeModel.getModel(styleNode)) == null || (minWidth = sizeModel.getMinNodeWidth()) == null) continue;
            return minWidth;
        }
        return DEFAULT_MINIMUM_WIDTH;
    }

    private Boolean getBorderWidthMatchesEdgeWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Boolean borderWidthMatchesEdgeWidth;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderWidthMatchesEdgeWidth = borderModel.getBorderWidthMatchesEdgeWidth()) == null) continue;
            return borderWidthMatchesEdgeWidth;
        }
        return false;
    }

    private Quantity<LengthUnit> getBorderWidth(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> borderWidth;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderWidth = borderModel.getBorderWidth()) == null) continue;
            return borderWidth;
        }
        return null;
    }

    private Boolean getBorderDashMatchesEdgeDash(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Boolean borderDashMatchesEdgeDash;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderDashMatchesEdgeDash = borderModel.getBorderDashMatchesEdgeDash()) == null) continue;
            return borderDashMatchesEdgeDash;
        }
        return false;
    }

    private Dash getBorderDash(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Dash borderDash;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderDash = borderModel.getBorderDash()) == null) continue;
            return borderDash;
        }
        return Dash.DEFAULT;
    }

    private Boolean getBorderColorMatchesEdgeColor(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Boolean borderColorMatchesEdgeColor;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderColorMatchesEdgeColor = borderModel.getBorderColorMatchesEdgeColor()) == null) continue;
            return borderColorMatchesEdgeColor;
        }
        return true;
    }

    private Color getBorderColor(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Color borderColor;
            NodeBorderModel borderModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (borderModel = NodeBorderModel.getModel(styleNode)) == null || (borderColor = borderModel.getBorderColor()) == null) continue;
            return borderColor;
        }
        return EdgeController.STANDARD_EDGE_COLOR;
    }

    private static Font getDefaultFont() {
        int fontSize = NodeStyleController.getDefaultFontSize();
        int fontStyle = NodeStyleController.getDefaultFontStyle();
        String fontFamily = NodeStyleController.getDefaultFontFamilyName();
        return new Font(fontFamily, fontStyle, fontSize);
    }

    private static String getDefaultFontFamilyName() {
        return ResourceController.getResourceController().getProperty("defaultfont");
    }

    private static int getDefaultFontStyle() {
        return ResourceController.getResourceController().getIntProperty("defaultfontstyle", 0);
    }

    private static int getDefaultFontSize() {
        return ResourceController.getResourceController().getIntProperty("defaultfontsize", 10);
    }

    private Font getStyleFont(Font baseFont, MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        Boolean bold = null;
        Boolean strikedThrough = null;
        Boolean italic = null;
        String fontFamilyName = null;
        Integer fontSize = null;
        for (IStyle styleKey : collection) {
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null) continue;
            if (bold == null) {
                bold = styleModel.isBold();
            }
            if (strikedThrough == null) {
                strikedThrough = styleModel.isStrikedThrough();
            }
            if (italic == null) {
                italic = styleModel.isItalic();
            }
            if (fontFamilyName == null) {
                fontFamilyName = styleModel.getFontFamilyName();
            }
            if (fontSize == null) {
                fontSize = styleModel.getFontSize();
            }
            if (bold == null || italic == null || fontFamilyName == null || fontSize == null || strikedThrough != null) continue;
            break;
        }
        return this.createFont(baseFont, fontFamilyName, fontSize, bold, italic, strikedThrough);
    }

    public HorizontalTextAlignment getHorizontalTextAlignment(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.horizontalTextAlignmentHandlers.getProperty(node, option);
    }

    public TextWritingDirection getTextWritingDirection(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.textWritingDirectionHandlers.getProperty(node, option);
    }

    private Font createFont(Font baseFont, String family, Integer size, Boolean bold, Boolean italic, Boolean strikedThrough) {
        if (family == null && size == null && bold == null && italic == null) {
            return baseFont;
        }
        if (family == null) {
            family = baseFont.getFamily();
        }
        if (size == null) {
            size = baseFont.getSize();
        }
        if (bold == null) {
            bold = baseFont.isBold();
        }
        if (italic == null) {
            italic = baseFont.isItalic();
        }
        int style = 0;
        if (bold.booleanValue()) {
            ++style;
        }
        if (italic.booleanValue()) {
            style += 2;
        }
        Font font = new Font(family, style, size);
        if (strikedThrough == TextAttribute.STRIKETHROUGH_ON) {
            return FontUtils.strikeThrough(font);
        }
        return font;
    }

    private NodeGeometryModel getStyleShape(MapModel map, Collection<IStyle> style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : style) {
            NodeGeometryModel shapeConfiguration;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (shapeConfiguration = styleModel.getShapeConfiguration()).getShape() == null) continue;
            return shapeConfiguration;
        }
        return null;
    }

    private Color getStyleTextColor(MapModel map, Collection<IStyle> collection) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : collection) {
            Color styleColor;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null) continue;
            Color color = styleColor = styleModel == null ? null : styleModel.getColor();
            if (styleColor == null) continue;
            return styleColor;
        }
        return null;
    }

    private HorizontalTextAlignment getHorizontalTextAlignment(MapModel map, Collection<IStyle> style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : style) {
            HorizontalTextAlignment textAlignment;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (textAlignment = styleModel.getHorizontalTextAlignment()) == null) continue;
            return textAlignment;
        }
        return null;
    }

    private TextWritingDirection getTextWritingDirection(MapModel map, Collection<IStyle> style) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : style) {
            TextWritingDirection textAlignment;
            NodeStyleModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = NodeStyleModel.getModel(styleNode)) == null || (textAlignment = styleModel.getTextWritingDirection()) == null) continue;
            return textAlignment;
        }
        return null;
    }

    public Font getFont(NodeModel node, LogicalStyleController.StyleOption option) {
        Font font = this.fontHandlers.getProperty(node, option, null);
        return font;
    }

    public String getFontFamilyName(NodeModel node, LogicalStyleController.StyleOption option) {
        Font font = this.getFont(node, option);
        return font.getFamily();
    }

    public int getFontSize(NodeModel node, LogicalStyleController.StyleOption option) {
        Font font = this.getFont(node, option);
        return font.getSize();
    }

    public NodeStyleShape getShape(NodeModel node, LogicalStyleController.StyleOption option) {
        NodeGeometryModel shapeConfiguration = this.shapeHandlers.getProperty(node, option);
        return shapeConfiguration.getShape();
    }

    public NodeGeometryModel getShapeConfiguration(NodeModel node, LogicalStyleController.StyleOption option) {
        NodeGeometryModel shapeConfiguration = this.shapeHandlers.getProperty(node, option);
        return shapeConfiguration;
    }

    public boolean isBold(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getFont(node, option).isBold();
    }

    public boolean isItalic(NodeModel node, LogicalStyleController.StyleOption option) {
        return this.getFont(node, option).isItalic();
    }

    public String getNodeFormat(NodeModel node) {
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            String format;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (format = NodeStyleModel.getNodeFormat(styleNode)) == null) continue;
            return format;
        }
        return "STANDARD_FORMAT";
    }

    public boolean getNodeNumbering(NodeModel node) {
        if (SummaryNode.isFirstGroupNode(node) || SummaryNode.isSummaryNode(node)) {
            return false;
        }
        Collection<IStyle> collection = LogicalStyleController.getController(this.modeController).getStyles(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        MapStyleModel model = MapStyleModel.getExtension(node.getMap());
        for (IStyle styleKey : collection) {
            Boolean numbering;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (numbering = NodeStyleModel.getNodeNumbering(styleNode)) == null) continue;
            return numbering;
        }
        return false;
    }

    public Quantity<LengthUnit> getMaxWidth(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Quantity<LengthUnit> maxTextWidth = this.getMaxNodeWidth(map, style);
        return maxTextWidth;
    }

    public Quantity<LengthUnit> getMinWidth(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> styles = styleController.getStyles(node, option);
        Quantity<LengthUnit> minWidth = this.getStyleMinWidth(map, styles);
        return minWidth;
    }

    public ModeController getModeController() {
        return this.modeController;
    }

    public Boolean getBorderWidthMatchesEdgeWidth(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Boolean borderWidthMatchesEdgeWidth = this.getBorderWidthMatchesEdgeWidth(map, style);
        return borderWidthMatchesEdgeWidth;
    }

    public Boolean getBorderDashMatchesEdgeDash(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Boolean borderDashMatchesEdgeDash = this.getBorderDashMatchesEdgeDash(map, style);
        return borderDashMatchesEdgeDash;
    }

    public Quantity<LengthUnit> getBorderWidth(NodeModel node, LogicalStyleController.StyleOption option) {
        LogicalStyleController styleController;
        Collection<IStyle> style;
        MapModel map = node.getMap();
        Quantity borderWidth = this.getBorderWidth(map, style = (styleController = LogicalStyleController.getController(this.modeController)).getStyles(node, option));
        return borderWidth != null ? borderWidth : new Quantity(1.0, (Enum)LengthUnit.px);
    }

    public Dash getBorderDash(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Dash borderDash = this.getBorderDash(map, style);
        return borderDash;
    }

    public Boolean getBorderColorMatchesEdgeColor(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Boolean borderColorMatchesEdgeColor = this.getBorderColorMatchesEdgeColor(map, style);
        return borderColorMatchesEdgeColor;
    }

    public Color getBorderColor(NodeModel node, LogicalStyleController.StyleOption option) {
        MapModel map = node.getMap();
        LogicalStyleController styleController = LogicalStyleController.getController(this.modeController);
        Collection<IStyle> style = styleController.getStyles(node, option);
        Color borderColor = this.getBorderColor(map, style);
        return borderColor;
    }

    public boolean isStrikedThrough(NodeModel node, LogicalStyleController.StyleOption option) {
        return FontUtils.isStrikedThrough(this.getFont(node, option));
    }
}

