/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.BreakStatement;
import org.eclipse.jdt.internal.compiler.ast.CaseStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FakeDefaultLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.GuardedPattern;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Pattern;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchExpression;
import org.eclipse.jdt.internal.compiler.ast.ThrowStatement;
import org.eclipse.jdt.internal.compiler.ast.YieldStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CaseLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.JavaFeature;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Expression {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public BranchLabel breakLabel;
    public CaseStatement[] cases;
    public CaseStatement defaultCase;
    public CaseStatement nullCase;
    public int blockStart;
    public int caseCount;
    int[] constants;
    int[] constMapping;
    public CaseStatement.ResolvedCase[] otherConstants;
    public int nConstants;
    public int switchBits;
    public boolean containsPatterns;
    public boolean containsNull;
    private BranchLabel switchPatternRestartTarget;
    Pattern totalPattern;
    public static final int CASE = 0;
    public static final int FALLTHROUGH = 1;
    public static final int ESCAPING = 2;
    public static final int BREAKING = 3;
    public static final int LabeledRules = 1;
    public static final int NullCase = 2;
    public static final int TotalPattern = 4;
    public static final int Exhaustive = 8;
    public static final int Enhanced = 16;
    private static final char[] SecretStringVariableName = " switchDispatchString".toCharArray();
    static final char[] SecretPatternVariableName = " switchDispatchPattern".toCharArray();
    private static final char[] SecretPatternRestartIndexName = " switchPatternRestartIndex".toCharArray();
    public SyntheticMethodBinding synthetic;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;
    Statement[] duplicateCases = null;
    int duplicateCaseCounter = 0;
    private LocalVariableBinding dispatchStringCopy = null;
    private LocalVariableBinding dispatchPatternCopy = null;
    private LocalVariableBinding restartIndexLocal = null;
    boolean isNonTraditional = false;
    List<Pattern> caseLabelElements = new ArrayList<Pattern>(0);
    public List<TypeBinding> caseLabelElementTypes = new ArrayList<TypeBinding>(0);

    protected int getFallThroughState(Statement statement, BlockScope blockScope) {
        if ((this.switchBits & 1) != 0) {
            if (statement instanceof Expression && ((Expression)statement).isTrulyExpression() || statement instanceof ThrowStatement) {
                return 3;
            }
            if (!statement.canCompleteNormally()) {
                return 3;
            }
            if (statement instanceof Block) {
                int n;
                Block block = (Block)statement;
                BreakStatement breakStatement = new BreakStatement(null, block.sourceEnd - 1, block.sourceEnd);
                breakStatement.isSynthetic = true;
                int n2 = n = block.statements == null ? 0 : block.statements.length;
                if (n == 0) {
                    block.statements = new Statement[]{breakStatement};
                    block.scope = this.scope;
                } else {
                    Statement[] statementArray = new Statement[n + 1];
                    System.arraycopy(block.statements, 0, statementArray, 0, n);
                    statementArray[n] = breakStatement;
                    block.statements = statementArray;
                }
                return 3;
            }
        }
        return 1;
    }

    protected void completeNormallyCheck(BlockScope blockScope) {
    }

    protected boolean needToCheckFlowInAbsenceOfDefaultBranch() {
        return !this.isExhaustive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            TypeBinding typeBinding;
            flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo);
            if (this.isNullHostile()) {
                this.expression.checkNPE(blockScope, flowContext, flowInfo, 1);
            }
            this.breakLabel = new BranchLabel();
            SwitchFlowContext switchFlowContext = new SwitchFlowContext(flowContext, this, this.breakLabel, true, true);
            switchFlowContext.isExpression = this instanceof SwitchExpression;
            FlowInfo flowInfo2 = FlowInfo.DEAD_END;
            this.preSwitchInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
            int n = 0;
            if (this.statements != null) {
                int n2;
                int n3 = n2 = (flowInfo.reachMode() & 3) != 0 ? 1 : 0;
                int n4 = 0;
                for (Statement statement : this.statements) {
                    Statement statement2;
                    if (n < this.caseCount && statement == this.cases[n]) {
                        this.scope.enclosingCase = this.cases[n];
                        ++n;
                        if (n4 == 1) {
                            if (((CaseStatement)statement).containsPatternVariable()) {
                                this.scope.problemReporter().IllegalFallThroughToPattern(this.scope.enclosingCase);
                            } else if ((statement.bits & 0x20000000) == 0) {
                                this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                            }
                        }
                        flowInfo2 = flowInfo2.mergedWith(flowInfo.unconditionalInits());
                        n3 = n2;
                        n4 = this.containsPatterns ? 1 : 0;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (n4 == 1 && (statement.bits & 0x20000000) == 0) {
                            this.scope.problemReporter().possibleFallThroughCase(this.scope.enclosingCase);
                        }
                        flowInfo2 = flowInfo2.mergedWith(flowInfo.unconditionalInits());
                        if ((this.switchBits & 1) != 0 && this.expression.resolvedType instanceof ReferenceBinding) {
                            if (this.expression instanceof NameReference) {
                                statement2 = (NameReference)this.expression;
                                if (((Expression)statement2).localVariableBinding() != null) {
                                    flowInfo2.markAsDefinitelyNonNull(((Expression)statement2).localVariableBinding());
                                } else if (((NameReference)statement2).lastFieldBinding() != null && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                    switchFlowContext.recordNullCheckedFieldReference((Reference)statement2, 2);
                                }
                            } else if (this.expression instanceof FieldReference && this.scope.compilerOptions().enableSyntacticNullAnalysisForFields) {
                                switchFlowContext.recordNullCheckedFieldReference((FieldReference)this.expression, 2);
                            }
                        }
                        n3 = n2;
                        n4 = this.containsPatterns ? 1 : 0;
                    } else {
                        if (!(this instanceof SwitchExpression) && blockScope.compilerOptions().complianceLevel >= 0x3A0000L && statement instanceof YieldStatement && ((YieldStatement)statement).isImplicit) {
                            statement2 = (YieldStatement)statement;
                            Expression expression = ((YieldStatement)statement).expression;
                            if (!((YieldStatement)statement2).expression.statementExpression()) {
                                this.scope.problemReporter().invalidExpressionAsStatement(expression);
                            }
                        }
                        n4 = this.getFallThroughState(statement, blockScope);
                    }
                    n3 = statement.complainIfUnreachable(flowInfo2, this.scope, n3, true);
                    if (n3 >= 2) continue;
                    if ((flowInfo2 = statement.analyseCode(this.scope, switchFlowContext, flowInfo2)) == FlowInfo.DEAD_END) {
                        n4 = 2;
                    }
                    switchFlowContext.expireNullCheckedFieldInfo();
                }
                this.completeNormallyCheck(blockScope);
            }
            if ((typeBinding = this.expression.resolvedType).isEnum()) {
                SourceTypeBinding sourceTypeBinding = blockScope.classScope().referenceContext.binding;
                this.synthetic = sourceTypeBinding.addSyntheticMethodForSwitchEnum(typeBinding, this);
            }
            if (this.defaultCase == null && this.needToCheckFlowInAbsenceOfDefaultBranch()) {
                flowInfo.addPotentialInitializationsFrom(flowInfo2.mergedWith(switchFlowContext.initsOnBreak));
                this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(flowInfo);
                FlowInfo flowInfo3 = flowInfo;
                return flowInfo3;
            }
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo2.mergedWith(switchFlowContext.initsOnBreak);
            this.mergedInitStateIndex = blockScope.methodScope().recordInitializationStates(unconditionalFlowInfo);
            UnconditionalFlowInfo unconditionalFlowInfo2 = unconditionalFlowInfo;
            return unconditionalFlowInfo2;
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private boolean isNullHostile() {
        if ((this.expression.implicitConversion & 0x400) != 0) {
            return true;
        }
        if (this.expression.resolvedType != null && (this.expression.resolvedType.id == 11 || this.expression.resolvedType.isEnum())) {
            return true;
        }
        return (this.switchBits & 3) == 1 && this.totalPattern == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateCodeForStringSwitch(BlockScope blockScope, CodeStream codeStream) {
        try {
            int n;
            int n2;
            int n3;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int n4 = codeStream.position;
            boolean bl = this.caseCount != 0;
            int n5 = bl ? this.otherConstants.length : 0;
            BranchLabel[] branchLabelArray = this.gatherLabels(codeStream, new BranchLabel[this.nConstants], BranchLabel::new);
            class StringSwitchCase
            implements Comparable {
                int hashCode;
                String string;
                BranchLabel label;

                public StringSwitchCase(int n, String string, BranchLabel branchLabel) {
                    this.hashCode = n;
                    this.string = string;
                    this.label = branchLabel;
                }

                public int compareTo(Object object) {
                    StringSwitchCase stringSwitchCase = (StringSwitchCase)object;
                    if (this.hashCode == stringSwitchCase.hashCode) {
                        return 0;
                    }
                    if (this.hashCode > stringSwitchCase.hashCode) {
                        return 1;
                    }
                    return -1;
                }

                public String toString() {
                    return "StringSwitchCase :\ncase " + this.hashCode + ":(" + this.string + ")\n";
                }
            }
            Object[] objectArray = new StringSwitchCase[n5];
            CaseLabel[] caseLabelArray = new CaseLabel[n5];
            this.constants = new int[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                String string = this.otherConstants[n3].c.stringValue();
                objectArray[n3] = new StringSwitchCase(string.hashCode(), string, branchLabelArray[this.constMapping[n3]]);
                caseLabelArray[n3] = new CaseLabel(codeStream);
                caseLabelArray[n3].tagBits |= 2;
            }
            Arrays.sort(objectArray);
            n3 = 0;
            int n6 = 0;
            int n7 = n5;
            for (int i = 0; i < n7; ++i) {
                int n8 = ((StringSwitchCase)objectArray[i]).hashCode;
                if (i != 0 && n8 == n6) continue;
                int n9 = n3++;
                int n10 = n8;
                this.constants[n9] = n10;
                n6 = n10;
            }
            if (n3 != n5) {
                this.constants = new int[n3];
                System.arraycopy(this.constants, 0, this.constants, 0, n3);
                CaseLabel[] caseLabelArray2 = caseLabelArray;
                caseLabelArray = new CaseLabel[n3];
                System.arraycopy(caseLabelArray2, 0, caseLabelArray, 0, n3);
            }
            int[] nArray = new int[n3];
            for (n7 = 0; n7 < n3; ++n7) {
                nArray[n7] = n7;
            }
            CaseLabel caseLabel = new CaseLabel(codeStream);
            caseLabel.tagBits |= 2;
            this.breakLabel.initialize(codeStream);
            BranchLabel branchLabel = new BranchLabel(codeStream);
            if (bl) {
                branchLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = branchLabel;
            }
            this.expression.generateCode(blockScope, codeStream, true);
            codeStream.store(this.dispatchStringCopy, true);
            codeStream.addVariable(this.dispatchStringCopy);
            codeStream.invokeStringHashCode();
            if (bl) {
                codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                int n11 = 0;
                n2 = n5;
                for (n = 0; n < n2; ++n) {
                    int n12 = ((StringSwitchCase)objectArray[n]).hashCode;
                    if (n == 0 || n12 != n6) {
                        n6 = n12;
                        if (n != 0) {
                            codeStream.goto_(branchLabel);
                        }
                        caseLabelArray[n11++].place();
                    }
                    codeStream.load(this.dispatchStringCopy);
                    codeStream.ldc(((StringSwitchCase)objectArray[n]).string);
                    codeStream.invokeStringEquals();
                    codeStream.ifne(((StringSwitchCase)objectArray[n]).label);
                }
                codeStream.goto_(branchLabel);
            } else {
                codeStream.pop();
            }
            n = 0;
            if (this.statements != null) {
                for (Statement statement : this.statements) {
                    if (n < this.caseCount && statement == this.cases[n]) {
                        this.scope.enclosingCase = this.cases[n];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                        if (statement == this.defaultCase) {
                            caseLabel.place();
                        }
                        ++n;
                    } else if (statement == this.defaultCase) {
                        caseLabel.place();
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                    }
                    this.statementGenerateCode(blockScope, codeStream, statement);
                }
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            codeStream.removeVariable(this.dispatchStringCopy);
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                caseLabel.place();
                branchLabel.place();
            }
            if (this.expectedType() != null) {
                TypeBinding typeBinding = this.expectedType().erasure();
                n2 = codeStream.lastAbruptCompletion == -1 ? 1 : 0;
                codeStream.recordExpressionType(typeBinding, n2 != 0 ? 0 : 1, n2 != 0);
            }
            codeStream.recordPositionsFrom(n4, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private <T extends BranchLabel> T[] gatherLabels(CodeStream codeStream, T[] TArray, Function<CodeStream, T> function) {
        int n = 0;
        int n2 = this.caseCount;
        for (int i = 0; i < n2; ++i) {
            CaseStatement caseStatement = this.cases[i];
            int n3 = caseStatement.constantExpressions.length;
            BranchLabel[] branchLabelArray = new BranchLabel[n3];
            int n4 = 0;
            for (int j = 0; j < n3; ++j) {
                Expression expression = caseStatement.constantExpressions[j];
                if (expression instanceof FakeDefaultLiteral) continue;
                int n5 = n4++;
                TArray[n] = (BranchLabel)function.apply(codeStream);
                branchLabelArray[n5] = TArray[n];
                if (expression == this.totalPattern) {
                    this.defaultCase = caseStatement;
                }
                ((BranchLabel)TArray[n++]).tagBits |= 2;
            }
            caseStatement.targetLabels = new BranchLabel[n4];
            System.arraycopy(branchLabelArray, 0, caseStatement.targetLabels, 0, n4);
        }
        return TArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.expression.resolvedType.id == 11 && !this.isNonTraditional) {
            this.generateCodeForStringSwitch(blockScope, codeStream);
            return;
        }
        try {
            boolean bl;
            int n;
            boolean bl2;
            if ((this.bits & Integer.MIN_VALUE) == 0) {
                return;
            }
            int n2 = codeStream.position;
            this.breakLabel.initialize(codeStream);
            int n3 = this.otherConstants == null ? 0 : this.otherConstants.length;
            CaseLabel[] caseLabelArray = (CaseLabel[])this.gatherLabels(codeStream, new CaseLabel[this.nConstants], CaseLabel::new);
            CaseLabel caseLabel = new CaseLabel(codeStream);
            boolean bl3 = bl2 = this.caseCount != 0;
            if (bl2) {
                caseLabel.tagBits |= 2;
            }
            if (this.defaultCase != null) {
                this.defaultCase.targetLabel = caseLabel;
            }
            TypeBinding typeBinding = this.expression.resolvedType;
            boolean bl4 = false;
            if (this.containsPatterns) {
                this.generateCodeSwitchPatternPrologue(blockScope, codeStream);
                bl4 = true;
            } else if (typeBinding.isEnum()) {
                codeStream.invoke((byte)-72, this.synthetic, null);
                this.expression.generateCode(blockScope, codeStream, true);
                codeStream.invokeEnumOrdinal(typeBinding.constantPoolName());
                codeStream.iaload();
                if (!bl2) {
                    codeStream.pop();
                }
                bl4 = bl2;
            } else {
                bl4 = this.expression.constant == Constant.NotAConstant || bl2;
                this.expression.generateCode(blockScope, codeStream, bl4);
            }
            if (bl2) {
                int[] nArray = new int[n3];
                for (int i = 0; i < n3; ++i) {
                    nArray[i] = i;
                }
                int[] nArray2 = new int[n3];
                System.arraycopy(this.constants, 0, nArray2, 0, n3);
                CodeStream.sort(nArray2, 0, n3 - 1, nArray);
                n = nArray2[n3 - 1];
                int n4 = nArray2[0];
                if ((long)((double)n3 * 2.5) > (long)n - (long)n4) {
                    if (n > 0x7FFF0000 && blockScope.compilerOptions().complianceLevel < 0x300000L) {
                        codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                    } else {
                        codeStream.tableswitch(caseLabel, n4, n, this.constants, nArray, this.constMapping, caseLabelArray);
                    }
                } else {
                    codeStream.lookupswitch(caseLabel, this.constants, nArray, caseLabelArray);
                }
                codeStream.recordPositionsFrom(codeStream.position, this.expression.sourceEnd);
            } else if (bl4) {
                codeStream.pop();
            }
            int n5 = 0;
            if (this.statements != null) {
                for (Statement statement : this.statements) {
                    CaseStatement caseStatement = null;
                    if (n5 < n3 && statement == this.cases[n5]) {
                        this.scope.enclosingCase = this.cases[n5];
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                        caseStatement = (CaseStatement)statement;
                        this.patternCaseExitPreviousCaseScope(codeStream, n5);
                        ++n5;
                    } else if (statement == this.defaultCase) {
                        this.scope.enclosingCase = this.defaultCase;
                        if (this.preSwitchInitStateIndex != -1) {
                            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                        }
                    }
                    this.statementGenerateCode(blockScope, codeStream, statement);
                    this.generateCodePatternCaseEpilogue(codeStream, n5, caseStatement);
                }
            }
            boolean bl5 = typeBinding.isEnum() && this instanceof SwitchExpression;
            n = this.defaultCase == null && bl5 ? 1 : 0;
            CompilerOptions compilerOptions = this.scope != null ? this.scope.compilerOptions() : null;
            boolean bl6 = bl = this.defaultCase == null && compilerOptions != null && this.containsPatterns && JavaFeature.SEALED_CLASSES.isSupported(compilerOptions) && JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && this.expression.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.expression.resolvedType).isSealed();
            if (n != 0 || bl) {
                if (this.preSwitchInitStateIndex != -1) {
                    codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.preSwitchInitStateIndex);
                }
                caseLabel.place();
                codeStream.newJavaLangIncompatibleClassChangeError();
                codeStream.dup();
                codeStream.invokeJavaLangIncompatibleClassChangeErrorDefaultConstructor();
                codeStream.athrow();
            }
            if (this.mergedInitStateIndex != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.mergedInitStateIndex);
            }
            this.generateCodeSwitchPatternEpilogue(codeStream);
            if (this.scope != blockScope) {
                codeStream.exitUserScope(this.scope);
            }
            this.breakLabel.place();
            if (this.defaultCase == null && !bl5 && !bl) {
                codeStream.recordPositionsFrom(codeStream.position, this.sourceEnd, true);
                caseLabel.place();
            }
            if (this instanceof SwitchExpression) {
                TypeBinding typeBinding2 = this.resolvedType;
                if (this.expectedType() != null) {
                    typeBinding2 = this.expectedType().erasure();
                }
                boolean bl7 = codeStream.lastAbruptCompletion == -1;
                codeStream.recordExpressionType(typeBinding2, bl7 ? 0 : 1, bl7 || n != 0);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private void generateCodeSwitchPatternEpilogue(CodeStream codeStream) {
        if (this.containsPatterns && this.caseLabelElements.size() > 0) {
            codeStream.removeVariable(this.dispatchPatternCopy);
            codeStream.removeVariable(this.restartIndexLocal);
        }
    }

    private void patternCaseExitPreviousCaseScope(CodeStream codeStream, int n) {
        CaseStatement caseStatement;
        if (n > 0 && (caseStatement = this.cases[n]).containsPatternVariable()) {
            caseStatement.patternCaseRemovePatternLocals(codeStream);
        }
    }

    private void generateCodePatternCaseEpilogue(CodeStream codeStream, int n, CaseStatement caseStatement) {
        Pattern pattern;
        if (this.switchPatternRestartTarget != null && caseStatement != null && caseStatement.patternIndex != -1 && (pattern = (Pattern)caseStatement.constantExpressions[caseStatement.patternIndex]) instanceof GuardedPattern) {
            codeStream.loadInt(n);
            codeStream.store(this.restartIndexLocal, false);
            codeStream.goto_(this.switchPatternRestartTarget);
            ((GuardedPattern)pattern).thenTarget.place();
        }
    }

    private void generateCodeSwitchPatternPrologue(BlockScope blockScope, CodeStream codeStream) {
        this.expression.generateCode(blockScope, codeStream, true);
        if ((this.switchBits & 2) == 0 && this.totalPattern == null) {
            codeStream.dup();
            codeStream.invokeJavaUtilObjectsrequireNonNull();
            codeStream.pop();
        }
        codeStream.store(this.dispatchPatternCopy, false);
        codeStream.addVariable(this.dispatchPatternCopy);
        int n = 0;
        codeStream.loadInt(n);
        codeStream.store(this.restartIndexLocal, false);
        codeStream.addVariable(this.restartIndexLocal);
        this.switchPatternRestartTarget = new BranchLabel(codeStream);
        this.switchPatternRestartTarget.place();
        codeStream.load(this.dispatchPatternCopy);
        codeStream.load(this.restartIndexLocal);
        int n2 = codeStream.classFile.recordBootstrapMethod(this);
        codeStream.invokeDynamic(n2, 2, 1, "typeSwitch".toCharArray(), "(Ljava/lang/Object;I)I".toCharArray(), 10, TypeBinding.INT);
    }

    protected void statementGenerateCode(BlockScope blockScope, CodeStream codeStream, Statement statement) {
        statement.generateCode(this.scope, codeStream);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        this.generateCode(blockScope, codeStream);
    }

    @Override
    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        SwitchStatement.printIndent(n, stringBuffer).append("switch (");
        this.expression.printExpression(0, stringBuffer).append(") {");
        if (this.statements != null) {
            for (int i = 0; i < this.statements.length; ++i) {
                stringBuffer.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(n, stringBuffer);
                    continue;
                }
                this.statements[i].printStatement(n + 2, stringBuffer);
            }
        }
        stringBuffer.append("\n");
        return SwitchStatement.printIndent(n, stringBuffer).append('}');
    }

    private int getNConstants() {
        int n = 0;
        for (Statement statement : this.statements) {
            if (!(statement instanceof CaseStatement)) continue;
            Expression[] expressionArray = ((CaseStatement)statement).constantExpressions;
            int n2 = 0;
            if (expressionArray != null) {
                for (Expression expression : expressionArray) {
                    if (expression instanceof FakeDefaultLiteral) continue;
                    ++n2;
                }
            }
            n += n2;
        }
        return n;
    }

    protected void addSecretTryResultVariable() {
    }

    boolean isAllowedType(TypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.id) {
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void resolve(BlockScope var1_1) {
        try {
            block45: {
                block47: {
                    block46: {
                        var2_2 = false;
                        var3_3 = false;
                        var4_4 = this.expression.resolveType(var1_1);
                        var5_5 = var1_1.compilerOptions();
                        var6_6 = this.checkAndSetEnhanced(var1_1, var4_4);
                        if (var4_4 == null) break block45;
                        this.expression.computeConversion(var1_1, var4_4, var4_4);
                        if (var4_4.isValidBinding()) break block46;
                        var4_4 = null;
                        break block45;
                    }
                    if (!var4_4.isBaseType()) break block47;
                    if (!this.expression.isConstantValueOfTypeAssignableToType(var4_4, TypeBinding.INT) && !var4_4.isCompatibleWith(TypeBinding.INT)) ** GOTO lbl-1000
                    break block45;
                }
                if (var4_4.isEnum()) {
                    var2_2 = true;
                    if (var5_5.complianceLevel < 0x310000L) {
                        var1_1.problemReporter().incorrectSwitchType(this.expression, var4_4);
                    }
                } else if (!this.containsPatterns && var1_1.isBoxingCompatibleWith(var4_4, TypeBinding.INT)) {
                    this.expression.computeConversion(var1_1, TypeBinding.INT, var4_4);
                } else if (var5_5.complianceLevel >= 0x330000L && var4_4.id == 11) {
                    if (this.containsPatterns) {
                        var3_3 = JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(var5_5) == false;
                        this.isNonTraditional = true;
                    } else {
                        var3_3 = true;
                    }
                } else if (!JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(var5_5)) {
                    var1_1.problemReporter().incorrectSwitchType(this.expression, var4_4);
                    var4_4 = null;
                } else {
                    this.isNonTraditional = true;
                }
            }
            if (var3_3) {
                this.dispatchStringCopy = new LocalVariableBinding(SwitchStatement.SecretStringVariableName, (TypeBinding)var1_1.getJavaLangString(), 0, false);
                var1_1.addLocalVariable(this.dispatchStringCopy);
                this.dispatchStringCopy.setConstant(Constant.NotAConstant);
                this.dispatchStringCopy.useFlag = 1;
            }
            this.addSecretPatternSwitchVariables(var1_1);
            if (this.statements != null) {
                if (this.scope == null) {
                    this.scope = new BlockScope(var1_1);
                }
                var7_7 = this.statements.length;
                this.cases = new CaseStatement[var7_7];
                this.nConstants = this.getNConstants();
                this.constants = new int[this.nConstants];
                this.otherConstants = new CaseStatement.ResolvedCase[this.nConstants];
                this.constMapping = new int[this.nConstants];
                var8_8 = 0;
                var9_10 = 0;
                var10_11 = new Pattern[this.nConstants];
                var11_13 /* !! */  = new int[this.nConstants];
                var12_14 = null;
                for (var13_16 = 0; var13_16 < var7_7; ++var13_16) {
                    var15_18 = this.statements[var13_16];
                    if (var15_18 instanceof CaseStatement) {
                        if (var15_18.containsPatternVariable()) {
                            ((CaseStatement)var15_18).collectPatternVariablesToScope(null, this.scope);
                            var12_14 = var15_18.getPatternVariablesWhenTrue();
                        } else {
                            var12_14 = null;
                        }
                    } else {
                        var15_18.resolveWithPatternVariablesInScope(var12_14, this.scope);
                        continue;
                    }
                    var16_19 = (CaseStatement)var15_18;
                    var14_17 = var16_19.resolveCase(this.scope, var4_4, this);
                    if (var14_17 != CaseStatement.ResolvedCase.UnresolvedCase) {
                        for (CaseStatement.ResolvedCase var20_23 : var14_17) {
                            var21_24 = var20_23.c;
                            if (var21_24 == Constant.NotAConstant) continue;
                            this.otherConstants[var8_8] = var20_23;
                            this.constants[var8_8] = var22_25 = this.containsPatterns ? (var20_23.intValue() == -1 ? -1 : var8_8) : var20_23.intValue();
                            for (var23_26 = 0; var23_26 < var8_8; ++var23_26) {
                                var24_27 = (IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$resolve$0(org.eclipse.jdt.internal.compiler.impl.Constant int int ), (I)Z)((SwitchStatement)this, (Constant)var21_24, (int)var22_25);
                                var25_28 = var20_23.e.resolvedType;
                                if (!var25_28.isValidBinding()) continue;
                                var26_29 = var10_11[var23_26];
                                if (var26_29 != null) {
                                    if (var20_23.isPattern()) {
                                        if (!var26_29.dominates((Pattern)var20_23.e)) continue;
                                        this.scope.problemReporter().patternDominatedByAnother(var20_23.e);
                                        continue;
                                    }
                                    if (var25_28.id == 12) continue;
                                    if (var25_28.isBaseType()) {
                                        var25_28 = this.scope.environment().computeBoxingType(var25_28);
                                    }
                                    if (!var26_29.isTotalForType(var25_28)) continue;
                                    this.scope.problemReporter().patternDominatedByAnother(var20_23.e);
                                    continue;
                                }
                                if (var20_23.isPattern() || !var24_27.test(var23_26)) continue;
                                if (this.isNonTraditional) {
                                    this.reportDuplicateCase(var20_23.e, this.otherConstants[var23_26].e, var7_7);
                                    continue;
                                }
                                this.reportDuplicateCase(var16_19, this.cases[var11_13 /* !! */ [var23_26]], var7_7);
                            }
                            this.constMapping[var8_8] = var8_8;
                            var11_13 /* !! */ [var8_8] = var9_10;
                            if (var20_23.e instanceof Pattern) {
                                var10_11[var8_8] = (Pattern)var20_23.e;
                            }
                            ++var8_8;
                        }
                    }
                    ++var9_10;
                }
                if (var7_7 != var8_8) {
                    this.otherConstants = new CaseStatement.ResolvedCase[var8_8];
                    System.arraycopy(this.otherConstants, 0, this.otherConstants, 0, var8_8);
                    this.constants = new int[var8_8];
                    System.arraycopy(this.constants, 0, this.constants, 0, var8_8);
                    this.constMapping = new int[var8_8];
                    System.arraycopy(this.constMapping, 0, this.constMapping, 0, var8_8);
                }
            } else if ((this.bits & 8) != 0) {
                var1_1.problemReporter().undocumentedEmptyBlock(this.blockStart, this.sourceEnd);
            }
            this.reportMixingCaseTypes();
            this.checkAndFlagDefaultSealed(var1_1, var5_5);
            if (this.defaultCase == null) {
                if (this.ignoreMissingDefaultCase(var5_5, var2_2) && var2_2) {
                    var1_1.methodScope().hasMissingSwitchDefault = true;
                } else if (!this.isExhaustive()) {
                    if (var6_6) {
                        var1_1.problemReporter().enhancedSwitchMissingDefaultCase(this.expression);
                    } else {
                        var1_1.problemReporter().missingDefaultCase(this, var2_2, var4_4);
                    }
                }
            }
            if (var2_2 && var5_5.complianceLevel >= 0x310000L && (this.defaultCase == null || var5_5.reportMissingEnumCaseDespiteDefault)) {
                v0 = var7_7 = this.otherConstants == null ? 0 : this.otherConstants.length;
                if ((this.switchBits & 4) == 0 && (this.containsPatterns || var7_7 >= this.caseCount && var7_7 != ((ReferenceBinding)var4_4).enumConstantCount())) {
                    var8_9 = ((ReferenceBinding)var4_4.erasure()).fields();
                    var10_12 = var8_9.length;
                    block6: for (var9_10 = 0; var9_10 < var10_12; ++var9_10) {
                        var11_13 /* !! */  = (int[])var8_9[var9_10];
                        if ((var11_13 /* !! */ .modifiers & 16384) == 0) continue;
                        for (var12_15 = 0; var12_15 < var7_7; ++var12_15) {
                            if (var11_13 /* !! */ .id + 1 == this.otherConstants[var12_15].c.intValue()) continue block6;
                        }
                        this.switchBits &= -257;
                        v1 = var12_15 = this.defaultCase != null && (this.defaultCase.bits & 0x40000000) != 0 ? 1 : 0;
                        if (var12_15 != 0) continue;
                        this.reportMissingEnumConstantCase(var1_1, (FieldBinding)var11_13 /* !! */ );
                    }
                }
            }
        }
        finally {
            if (this.scope != null) {
                this.scope.enclosingCase = null;
            }
        }
    }

    private boolean isExhaustive() {
        return (this.switchBits & 8) != 0;
    }

    public boolean isEnhanced() {
        return (this.switchBits & 0x10) != 0;
    }

    private boolean checkAndSetEnhanced(BlockScope blockScope, TypeBinding typeBinding) {
        if (JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(blockScope.compilerOptions()) && typeBinding != null && !(this instanceof SwitchExpression)) {
            boolean bl = !typeBinding.isEnum();
            switch (typeBinding.id) {
                case 2: 
                case 3: 
                case 4: 
                case 10: 
                case 11: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    bl = false;
                }
            }
            if (bl || this.containsPatterns || this.containsNull) {
                this.switchBits |= 0x10;
                return true;
            }
        }
        return false;
    }

    private void checkAndFlagDefaultSealed(BlockScope blockScope, CompilerOptions compilerOptions) {
        boolean bl;
        if (this.defaultCase != null) {
            this.switchBits |= 8;
            return;
        }
        boolean bl2 = bl = this.containsPatterns && JavaFeature.SEALED_CLASSES.isSupported(compilerOptions) && JavaFeature.PATTERN_MATCHING_IN_SWITCH.isSupported(compilerOptions) && this.expression.resolvedType instanceof ReferenceBinding && ((ReferenceBinding)this.expression.resolvedType).isSealed();
        if (!bl) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.expression.resolvedType;
        if (!referenceBinding.isSealed()) {
            return;
        }
        List<ReferenceBinding> list = Arrays.asList(referenceBinding.permittedTypes());
        for (TypeBinding typeBinding : list) {
            if (this.caseLabelElementTypes.contains(typeBinding)) continue;
            blockScope.problemReporter().missingDefaultCase(this, false, referenceBinding);
            return;
        }
        this.switchBits |= 8;
    }

    private void addSecretPatternSwitchVariables(BlockScope blockScope) {
        if (this.containsPatterns) {
            this.scope = new BlockScope(blockScope);
            this.dispatchPatternCopy = new LocalVariableBinding(SecretPatternVariableName, this.expression.resolvedType, 0, false);
            this.scope.addLocalVariable(this.dispatchPatternCopy);
            this.dispatchPatternCopy.setConstant(Constant.NotAConstant);
            this.dispatchPatternCopy.useFlag = 1;
            this.restartIndexLocal = new LocalVariableBinding(SecretPatternRestartIndexName, (TypeBinding)TypeBinding.INT, 0, false);
            this.scope.addLocalVariable(this.restartIndexLocal);
            this.restartIndexLocal.setConstant(Constant.NotAConstant);
            this.restartIndexLocal.useFlag = 1;
        }
    }

    protected void reportMissingEnumConstantCase(BlockScope blockScope, FieldBinding fieldBinding) {
        blockScope.problemReporter().missingEnumConstantCase(this, fieldBinding);
    }

    protected boolean ignoreMissingDefaultCase(CompilerOptions compilerOptions, boolean bl) {
        return compilerOptions.getSeverity(0x40008000) == 256;
    }

    @Override
    public boolean isTrulyExpression() {
        return false;
    }

    private void reportMixingCaseTypes() {
        if (this.caseCount == 0) {
            if (this.defaultCase != null && this.defaultCase.isExpr) {
                this.switchBits |= 1;
            }
            return;
        }
        if (this.cases[0] == null) {
            return;
        }
        boolean bl = this.cases[0].isExpr;
        if (bl) {
            this.switchBits |= 1;
        }
        int n = this.caseCount;
        for (int i = 1; i < n; ++i) {
            if (this.cases[i].isExpr == bl) continue;
            this.scope.problemReporter().switchExpressionMixedCase(this.cases[i]);
            return;
        }
        if (this.defaultCase != null && this.defaultCase.isExpr != bl) {
            this.scope.problemReporter().switchExpressionMixedCase(this.defaultCase);
        }
    }

    private void reportDuplicateCase(Statement statement, Statement statement2, int n) {
        if (this.duplicateCases == null) {
            this.scope.problemReporter().duplicateCase(statement2);
            if (statement != statement2) {
                this.scope.problemReporter().duplicateCase(statement);
            }
            this.duplicateCases = new Statement[n];
            this.duplicateCases[this.duplicateCaseCounter++] = statement2;
            if (statement != statement2) {
                this.duplicateCases[this.duplicateCaseCounter++] = statement;
            }
        } else {
            boolean bl = false;
            for (int i = 2; i < this.duplicateCaseCounter; ++i) {
                if (this.duplicateCases[i] != statement) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.scope.problemReporter().duplicateCase(statement);
                this.duplicateCases[this.duplicateCaseCounter++] = statement;
            }
        }
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            if (this.statements != null) {
                int n = this.statements.length;
                for (int i = 0; i < n; ++i) {
                    this.statements[i].traverse(aSTVisitor, this.scope);
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    @Override
    public void branchChainTo(BranchLabel branchLabel) {
        if (this.breakLabel.forwardReferenceCount() > 0) {
            branchLabel.becomeDelegateFor(this.breakLabel);
        }
    }

    @Override
    public boolean doesNotCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        int n = this.statements.length;
        for (int i = 0; i < n; ++i) {
            if (!this.statements[i].breaksOut(null)) continue;
            return false;
        }
        return this.statements[this.statements.length - 1].doesNotCompleteNormally();
    }

    @Override
    public boolean completesByContinue() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        int n = this.statements.length;
        for (int i = 0; i < n; ++i) {
            if (!this.statements[i].completesByContinue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canCompleteNormally() {
        if (this.statements == null || this.statements.length == 0) {
            return true;
        }
        if ((this.switchBits & 1) == 0) {
            if (this.statements[this.statements.length - 1].canCompleteNormally()) {
                return true;
            }
            if (this.defaultCase == null) {
                return true;
            }
            int n = this.statements.length;
            for (int i = 0; i < n; ++i) {
                if (!this.statements[i].breaksOut(null)) continue;
                return true;
            }
        } else {
            for (Statement statement : this.statements) {
                if (statement instanceof CaseStatement) continue;
                if (this.defaultCase == null) {
                    return true;
                }
                if (statement instanceof Expression) {
                    return true;
                }
                if (statement.canCompleteNormally()) {
                    return true;
                }
                if (statement instanceof YieldStatement && ((YieldStatement)statement).isImplicit) {
                    return true;
                }
                if (!(statement instanceof Block)) continue;
                Block block = (Block)statement;
                if (block.canCompleteNormally()) {
                    return true;
                }
                if (!block.breaksOut(null)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean continueCompletes() {
        if (this.statements == null || this.statements.length == 0) {
            return false;
        }
        int n = this.statements.length;
        for (int i = 0; i < n; ++i) {
            if (!this.statements[i].continueCompletes()) continue;
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer printExpression(int n, StringBuffer stringBuffer) {
        return this.printStatement(n, stringBuffer);
    }

    private /* synthetic */ boolean lambda$resolve$0(Constant constant, int n, int n2) {
        Constant constant2 = this.otherConstants[n2].c;
        if (constant.typeID() == 11) {
            return constant2.stringValue().equals(constant.stringValue());
        }
        return constant2.typeID() == 11 ? false : constant2.intValue() == n;
    }
}

