# Changelog

## [v1.12.0](https://github.com/netdata/netdata/tree/v1.12.0) (2019-02-06)

**Fixed bugs:**

- cups.plugin fails to be compiled [\#5324](https://github.com/netdata/netdata/issues/5324)
- Slack alert displaying URL after manual update of net-data [\#5301](https://github.com/netdata/netdata/issues/5301)
- Netdata update in a /tmp hardened system [\#5289](https://github.com/netdata/netdata/issues/5289)
- Certificate error while running netdata kickstart script [\#5273](https://github.com/netdata/netdata/issues/5273)
- Netdata won't update anymore [\#5272](https://github.com/netdata/netdata/issues/5272)
- alarm-notify.sh not working with latest update of netdata [\#5261](https://github.com/netdata/netdata/issues/5261)
- /etc/netdata/edit-config charts.d.conf [\#5252](https://github.com/netdata/netdata/issues/5252)
- Cannot install netdata from source \(the source directory does not include netdata-installer.sh\) [\#5251](https://github.com/netdata/netdata/issues/5251)
- Non-interactive install fails if required packages are already present [\#5240](https://github.com/netdata/netdata/issues/5240)
- apps.plugin memory usage bug [\#5237](https://github.com/netdata/netdata/issues/5237)
- Automatic updates \(via CRON\) giving error [\#5229](https://github.com/netdata/netdata/issues/5229)
- Updater script no longer seems to be working after a recent update [\#5228](https://github.com/netdata/netdata/issues/5228)
- Cron Update fails \(again\) [\#5208](https://github.com/netdata/netdata/issues/5208)
- It is netdata instalation hacked ? [\#5207](https://github.com/netdata/netdata/issues/5207)
- Wrong version string in GUI [\#5204](https://github.com/netdata/netdata/issues/5204)
- GUI links to github wiki [\#5202](https://github.com/netdata/netdata/issues/5202)
- Version checker shouldn't compare commits [\#5201](https://github.com/netdata/netdata/issues/5201)
- python.d/dockerd plugin update error [\#5200](https://github.com/netdata/netdata/issues/5200)
- Netdata registry with basic auth \(behind nginx proxy\) results in error 409 [\#5180](https://github.com/netdata/netdata/issues/5180)
- alarm-notify.sh: WARNING: Cannot find file [\#5136](https://github.com/netdata/netdata/issues/5136)
- Netdata w/ Docker Container not show Disk space utilization for mounts [\#5071](https://github.com/netdata/netdata/issues/5071)
- zfs charts appear, even when they are zero [\#4115](https://github.com/netdata/netdata/issues/4115)
- Ceph - No JSON object could be decoded [\#3563](https://github.com/netdata/netdata/issues/3563)

**Closed issues:**

- integrate go-orchestrator into go.d.plugin [\#5308](https://github.com/netdata/netdata/issues/5308)
- Update not working or UI just showing wrong information? How to uninstall? [\#5285](https://github.com/netdata/netdata/issues/5285)
- Slack Notifications Ignored by alarm-notify.sh [\#5267](https://github.com/netdata/netdata/issues/5267)
- varnish plugin doesn't support custom varnishd working directory [\#5262](https://github.com/netdata/netdata/issues/5262)
- Developing a new plugin questions [\#5235](https://github.com/netdata/netdata/issues/5235)
- Split go.d plugin into two packages [\#5195](https://github.com/netdata/netdata/issues/5195)
- move python module nvidia\_smi to go.d [\#5190](https://github.com/netdata/netdata/issues/5190)
- Logstash monitoring [\#5147](https://github.com/netdata/netdata/issues/5147)
- integrate go.d into netdata [\#5006](https://github.com/netdata/netdata/issues/5006)
- new database format design [\#4687](https://github.com/netdata/netdata/issues/4687)
- \[REQUEST\] Prowl integration for iOS users? [\#3788](https://github.com/netdata/netdata/issues/3788)
- CUPS information [\#857](https://github.com/netdata/netdata/issues/857)

**Merged pull requests:**

- Fix Codacy issues for FreeBSD plugin [\#5334](https://github.com/netdata/netdata/pull/5334) ([vlvkobal](https://github.com/vlvkobal))
- portcheck: remove unused var [\#5332](https://github.com/netdata/netdata/pull/5332) ([ilyam8](https://github.com/ilyam8))
- fix some python codacy errors [\#5331](https://github.com/netdata/netdata/pull/5331) ([ilyam8](https://github.com/ilyam8))
- Remove codacy warnings from sma\_webbox [\#5330](https://github.com/netdata/netdata/pull/5330) ([cakrit](https://github.com/cakrit))
- Allow user to override the default behavior for read-only mounts [\#5327](https://github.com/netdata/netdata/pull/5327) ([vlvkobal](https://github.com/vlvkobal))
- Remove deprecated API call [\#5326](https://github.com/netdata/netdata/pull/5326) ([Aisbergg](https://github.com/Aisbergg))
- fix compilation of cups.plugin; fixes \#5324 [\#5325](https://github.com/netdata/netdata/pull/5325) ([ktsaou](https://github.com/ktsaou))
- Clarify that uninstaller.sh needs to be downloaded [\#5315](https://github.com/netdata/netdata/pull/5315) ([cakrit](https://github.com/cakrit))
- Remove registrypath from alarm-notify [\#5302](https://github.com/netdata/netdata/pull/5302) ([cakrit](https://github.com/cakrit))
- Minor updates to anonymous statistics [\#5295](https://github.com/netdata/netdata/pull/5295) ([cakrit](https://github.com/cakrit))
- kickstart: noexec detection [\#5293](https://github.com/netdata/netdata/pull/5293) ([paulfantom](https://github.com/paulfantom))
- Correct info on what kickstart.sh does [\#5292](https://github.com/netdata/netdata/pull/5292) ([cakrit](https://github.com/cakrit))
- Add errno to fatal event for statistics [\#5291](https://github.com/netdata/netdata/pull/5291) ([cakrit](https://github.com/cakrit))
- updated cncf landscape url [\#5288](https://github.com/netdata/netdata/pull/5288) ([ktsaou](https://github.com/ktsaou))
- Add back the symlink netdata-latest.gz.run [\#5286](https://github.com/netdata/netdata/pull/5286) ([cakrit](https://github.com/cakrit))
- Additional UI fixes [\#5284](https://github.com/netdata/netdata/pull/5284) ([gmosx](https://github.com/gmosx))
- GUI Update check - use version instead of commit [\#5283](https://github.com/netdata/netdata/pull/5283) ([cakrit](https://github.com/cakrit))
- Correct auto-updater to netdata-updater [\#5281](https://github.com/netdata/netdata/pull/5281) ([cakrit](https://github.com/cakrit))
- netdata update instructions after recent changes [\#5277](https://github.com/netdata/netdata/pull/5277) ([cakrit](https://github.com/cakrit))
- Fix incorrect parsing of ACLs [\#5275](https://github.com/netdata/netdata/pull/5275) ([cakrit](https://github.com/cakrit))
- Improve apps grouping config and docs [\#5269](https://github.com/netdata/netdata/pull/5269) ([vlvkobal](https://github.com/vlvkobal))
- Always run make clean before make [\#5265](https://github.com/netdata/netdata/pull/5265) ([cakrit](https://github.com/cakrit))
- varnish module: add instance\_name option [\#5264](https://github.com/netdata/netdata/pull/5264) ([ilyam8](https://github.com/ilyam8))
- Bug fix for 5261 [\#5263](https://github.com/netdata/netdata/pull/5263) ([cakrit](https://github.com/cakrit))
- ceph module bugfix: fix invalid json response [\#5260](https://github.com/netdata/netdata/pull/5260) ([ilyam8](https://github.com/ilyam8))
- Fix typo in docs/configuration-guide.md [\#5259](https://github.com/netdata/netdata/pull/5259) ([u32i64](https://github.com/u32i64))
- SUSE addition [\#5258](https://github.com/netdata/netdata/pull/5258) ([dannysauer](https://github.com/dannysauer))
- Check version.txt in correct directory and fix link to docs [\#5256](https://github.com/netdata/netdata/pull/5256) ([cakrit](https://github.com/cakrit))
- Mysql charts fix [\#5250](https://github.com/netdata/netdata/pull/5250) ([ilyam8](https://github.com/ilyam8))
- plugins.d doc: Remove empty similar headline [\#5245](https://github.com/netdata/netdata/pull/5245) ([simonnagl](https://github.com/simonnagl))
- Pass correct options to the configure command [\#5244](https://github.com/netdata/netdata/pull/5244) ([cakrit](https://github.com/cakrit))
- Update kickstart.sh md5sum in docs [\#5242](https://github.com/netdata/netdata/pull/5242) ([cakrit](https://github.com/cakrit))
- Fix check for install-required-packages.sh [\#5241](https://github.com/netdata/netdata/pull/5241) ([cakrit](https://github.com/cakrit))
- Fix nightly builds and cron autoupdater [\#5232](https://github.com/netdata/netdata/pull/5232) ([paulfantom](https://github.com/paulfantom))
- Remove v before the version [\#5223](https://github.com/netdata/netdata/pull/5223) ([cakrit](https://github.com/cakrit))
- Instruct users to use edit-config [\#5222](https://github.com/netdata/netdata/pull/5222) ([cakrit](https://github.com/cakrit))
- Improvements to QoS \(tc\) documentation [\#5221](https://github.com/netdata/netdata/pull/5221) ([cakrit](https://github.com/cakrit))
- python dockerd module: check version [\#5217](https://github.com/netdata/netdata/pull/5217) ([ilyam8](https://github.com/ilyam8))
- Bug fix for netdata behind authenticated proxies [\#5216](https://github.com/netdata/netdata/pull/5216) ([cakrit](https://github.com/cakrit))
- add go.d.plugin to apps\_groups.conf [\#5214](https://github.com/netdata/netdata/pull/5214) ([ilyam8](https://github.com/ilyam8))
- Don't show zero charts for ZFS filesystem [\#5211](https://github.com/netdata/netdata/pull/5211) ([vlvkobal](https://github.com/vlvkobal))
- install go.d.plugin [\#5199](https://github.com/netdata/netdata/pull/5199) ([paulfantom](https://github.com/paulfantom))
- Correct link to Rest API [\#5193](https://github.com/netdata/netdata/pull/5193) ([cakrit](https://github.com/cakrit))
- CUPS plugin [\#5188](https://github.com/netdata/netdata/pull/5188) ([simonnagl](https://github.com/simonnagl))
- alarm-notify: Add Prowl integration for iOS users. [\#5132](https://github.com/netdata/netdata/pull/5132) ([Ferroin](https://github.com/Ferroin))
- Anonymous statistics [\#5113](https://github.com/netdata/netdata/pull/5113) ([cakrit](https://github.com/cakrit))
- Update info on plugins in performance doc [\#5101](https://github.com/netdata/netdata/pull/5101) ([cakrit](https://github.com/cakrit))
- Cloud Sign-In [\#5095](https://github.com/netdata/netdata/pull/5095) ([gmosx](https://github.com/gmosx))

## [v1.12.0-rc3](https://github.com/netdata/netdata/tree/v1.12.0-rc3) (2019-01-17)

**Fixed bugs:**

- megacli isn't included in python.d.conf [\#5191](https://github.com/netdata/netdata/issues/5191)
- Unix Domain Socket no longer working. Permission denied [\#5181](https://github.com/netdata/netdata/issues/5181)
- netdata-updater.sh doesn't have exec perms [\#5175](https://github.com/netdata/netdata/issues/5175)
- FireQoS name not showing due to recent change [\#5171](https://github.com/netdata/netdata/issues/5171)
- python go\_expvar: reuse same expvar key in different charts [\#5133](https://github.com/netdata/netdata/issues/5133)
- hddtemp.chart.py is hardcoded to only use /dev/sdX [\#5129](https://github.com/netdata/netdata/issues/5129)
- RabbitMQ Plugin wrong metrics for nodes in cluster [\#5118](https://github.com/netdata/netdata/issues/5118)
- cannot install netdata [\#5117](https://github.com/netdata/netdata/issues/5117)
- Anomalous \(big\) values on graphite/carbon  [\#5104](https://github.com/netdata/netdata/issues/5104)
- \[Bug\] Stale metrics being exported to prometheus [\#5064](https://github.com/netdata/netdata/issues/5064)
- Uninstaller script should be self-contained [\#5031](https://github.com/netdata/netdata/issues/5031)
- Netdata doesn't properly lookup docker container name when running in ECS with task level cpu/memory limits enabled [\#4981](https://github.com/netdata/netdata/issues/4981)
- Dashboard TV white page [\#4710](https://github.com/netdata/netdata/issues/4710)
- Review of system.ram plugin: treat Slab memory as Cached \(PR 3288\) [\#3929](https://github.com/netdata/netdata/issues/3929)
- Fix for unix sockets after addition of port ACLs [\#5184](https://github.com/netdata/netdata/pull/5184) ([cakrit](https://github.com/cakrit))

**Closed issues:**

- Remove support for multi-threaded and single-threaded web servers [\#5154](https://github.com/netdata/netdata/issues/5154)
- Use GCS instead of git for updating netdata [\#5110](https://github.com/netdata/netdata/issues/5110)
- error.log: IPv6 not properly show in error messages [\#5067](https://github.com/netdata/netdata/issues/5067)
- Introduce Polymorphic Linux in the Docker Image [\#5034](https://github.com/netdata/netdata/issues/5034)
- Allow netdata to listen to multiple ports [\#5017](https://github.com/netdata/netdata/issues/5017)
- SNMP section not visible [\#4021](https://github.com/netdata/netdata/issues/4021)
- allow different ports for streaming reception and API requests [\#3830](https://github.com/netdata/netdata/issues/3830)
- Consul monitoring service health checks [\#3674](https://github.com/netdata/netdata/issues/3674)
- maintenance time and silence time [\#3187](https://github.com/netdata/netdata/issues/3187)
- Suppressing alerts programatically [\#2673](https://github.com/netdata/netdata/issues/2673)
- include chart values in alarm info text [\#2351](https://github.com/netdata/netdata/issues/2351)
- allow streamed data to be received on dedicated port [\#2149](https://github.com/netdata/netdata/issues/2149)
- alarm notifications should state a count of active alarms per state [\#946](https://github.com/netdata/netdata/issues/946)

**Merged pull requests:**

- update bug\_report.md [\#5205](https://github.com/netdata/netdata/pull/5205) ([ilyam8](https://github.com/ilyam8))
- add missing modules to python.d.conf [\#5194](https://github.com/netdata/netdata/pull/5194) ([ilyam8](https://github.com/ilyam8))
- remove double 'afraid to' in CONTRIBUTING.md [\#5189](https://github.com/netdata/netdata/pull/5189) ([arkamar](https://github.com/arkamar))
- Use tarballs from GCS in kickstart.sh [\#5185](https://github.com/netdata/netdata/pull/5185) ([paulfantom](https://github.com/paulfantom))
- fix for fireqos classname not showing [\#5176](https://github.com/netdata/netdata/pull/5176) ([psychomelet](https://github.com/psychomelet))
- GCS-based updater [\#5174](https://github.com/netdata/netdata/pull/5174) ([paulfantom](https://github.com/paulfantom))
- Updated Polyverse reinstall commands in Dockerfile [\#5173](https://github.com/netdata/netdata/pull/5173) ([archisgore](https://github.com/archisgore))
- Change how the ip address and port are logged in socket.c [\#5166](https://github.com/netdata/netdata/pull/5166) ([krinfels](https://github.com/krinfels))
- Correct SNMP module name in plugin error handling [\#5153](https://github.com/netdata/netdata/pull/5153) ([pablerass](https://github.com/pablerass))
- Fix cached memory calculation [\#5151](https://github.com/netdata/netdata/pull/5151) ([vlvkobal](https://github.com/vlvkobal))
- Fix typo in plugins.d/README.md [\#5150](https://github.com/netdata/netdata/pull/5150) ([arkamar](https://github.com/arkamar))
- "Network Traffic \(system.net\)" is always zero on FreeBSD virtual machines if hypervisor uses VirtIO NIC [\#5149](https://github.com/netdata/netdata/pull/5149) ([vladmovchan](https://github.com/vladmovchan))
- rabbitmq: api/nodes requests fix [\#5142](https://github.com/netdata/netdata/pull/5142) ([ilyam8](https://github.com/ilyam8))
- go\_expavar fix: don't check for duplicate expvars [\#5141](https://github.com/netdata/netdata/pull/5141) ([ilyam8](https://github.com/ilyam8))
- hddtemp fix: don't use disk model as dim name [\#5140](https://github.com/netdata/netdata/pull/5140) ([ilyam8](https://github.com/ilyam8))
- add option to opt-out from telemetry program [\#5138](https://github.com/netdata/netdata/pull/5138) ([paulfantom](https://github.com/paulfantom))
- Scramble packages in docker images with polymorphic linux [\#5137](https://github.com/netdata/netdata/pull/5137) ([paulfantom](https://github.com/paulfantom))
- change ownership of .gitignore [\#5131](https://github.com/netdata/netdata/pull/5131) ([paulfantom](https://github.com/paulfantom))
- Update Charts.md [\#5124](https://github.com/netdata/netdata/pull/5124) ([mfundul](https://github.com/mfundul))
- self-contained uninstaller [\#5121](https://github.com/netdata/netdata/pull/5121) ([paulfantom](https://github.com/paulfantom))
- force git describe to always create a version [\#5119](https://github.com/netdata/netdata/pull/5119) ([paulfantom](https://github.com/paulfantom))
- Clarify backend modes of operation [\#5116](https://github.com/netdata/netdata/pull/5116) ([cakrit](https://github.com/cakrit))
- web-site content; why-netdata content [\#5097](https://github.com/netdata/netdata/pull/5097) ([ktsaou](https://github.com/ktsaou))
- Add variables to alarm-notify.sh  [\#5096](https://github.com/netdata/netdata/pull/5096) ([cakrit](https://github.com/cakrit))
- do not report stale metrics to prometheus [\#5084](https://github.com/netdata/netdata/pull/5084) ([ktsaou](https://github.com/ktsaou))
- Unify versioning [\#5051](https://github.com/netdata/netdata/pull/5051) ([paulfantom](https://github.com/paulfantom))
- Port ACLs, Management API and Health commands [\#4969](https://github.com/netdata/netdata/pull/4969) ([cakrit](https://github.com/cakrit))
- Generate a configure script for RPM build \(\#4570\) [\#4571](https://github.com/netdata/netdata/pull/4571) ([ananace](https://github.com/ananace))

## [v1.12.0-rc2](https://github.com/netdata/netdata/tree/v1.12.0-rc2) (2019-01-03)

**Fixed bugs:**

- smartd\_log: check\(\) unhandled exception: list index out of range [\#5079](https://github.com/netdata/netdata/issues/5079)
- Additional character in Counter64 hex string [\#5028](https://github.com/netdata/netdata/issues/5028)
- Error every second PLUGIN\[proc\] [\#4994](https://github.com/netdata/netdata/issues/4994)
- Inconsistency in netdata.spec.in when comparing logdir permission with git-installation [\#4963](https://github.com/netdata/netdata/issues/4963)
- Docker-compose: a lot of errors; Connection refused, Can't establish connection to MySQL... [\#4956](https://github.com/netdata/netdata/issues/4956)
- Log flooding with new proc plugin [\#4945](https://github.com/netdata/netdata/issues/4945)
- Free memory shows as 'inactive' in FreeBSD [\#4737](https://github.com/netdata/netdata/issues/4737)
- Should use IEC-compliant abbreviations, e.g. KiB, MiB, etc. [\#4711](https://github.com/netdata/netdata/issues/4711)
- FreeBSD: \(apps.cpu\) not show a specific program [\#4037](https://github.com/netdata/netdata/issues/4037)
- Apcupsd: Connection loss further collects data, but it should stop [\#3927](https://github.com/netdata/netdata/issues/3927)
- FreeBSD: apps.plugin reports spikes and apps.cpu less user CPU [\#3245](https://github.com/netdata/netdata/issues/3245)

**Closed issues:**

- disable respect `Retry-After` response header in python UrlService by default [\#5078](https://github.com/netdata/netdata/issues/5078)
- move freeradius module to go.d [\#5063](https://github.com/netdata/netdata/issues/5063)
- move python module dns\_query\_time to go.d [\#5047](https://github.com/netdata/netdata/issues/5047)
- move python module web\_log to go.d [\#5046](https://github.com/netdata/netdata/issues/5046)
- R&D: Collectors landscape page [\#5045](https://github.com/netdata/netdata/issues/5045)
- Copy updater script instead of linking it [\#4924](https://github.com/netdata/netdata/issues/4924)
- Activemq monitoring [\#4818](https://github.com/netdata/netdata/issues/4818)
- Move packaging related code into `packaging/` directory [\#4611](https://github.com/netdata/netdata/issues/4611)
- Simplify makeself [\#4527](https://github.com/netdata/netdata/issues/4527)
- new netdata logo [\#4476](https://github.com/netdata/netdata/issues/4476)
- Add info on disabling alarms for specific target - part 2 [\#4324](https://github.com/netdata/netdata/issues/4324)
- Add info on disabling alarms for specific target - part 1 [\#4323](https://github.com/netdata/netdata/issues/4323)
- Document how to monitor log files [\#4318](https://github.com/netdata/netdata/issues/4318)
- Solr monitoring [\#3218](https://github.com/netdata/netdata/issues/3218)

**Merged pull requests:**

- postgres : fix WAL query [\#5105](https://github.com/netdata/netdata/pull/5105) ([anayrat](https://github.com/anayrat))
- Correct memory usage statement in memory=none [\#5100](https://github.com/netdata/netdata/pull/5100) ([cakrit](https://github.com/cakrit))
- fix permissions for log files when building rpms [\#5099](https://github.com/netdata/netdata/pull/5099) ([paulfantom](https://github.com/paulfantom))
- fix web site install link [\#5092](https://github.com/netdata/netdata/pull/5092) ([ktsaou](https://github.com/ktsaou))
- Removed c3, morris and raphael JS libraries \(\#5086\) [\#5088](https://github.com/netdata/netdata/pull/5088) ([gmosx](https://github.com/gmosx))
- Improve instructions on how to view the slave UI [\#5083](https://github.com/netdata/netdata/pull/5083) ([cakrit](https://github.com/cakrit))
- UrlService dont respect Retry-After header by default [\#5082](https://github.com/netdata/netdata/pull/5082) ([ilyam8](https://github.com/ilyam8))
- smartd\_log: skip non-CSVs early [\#5081](https://github.com/netdata/netdata/pull/5081) ([kevlar1818](https://github.com/kevlar1818))
- Dashboard grammar change [\#5080](https://github.com/netdata/netdata/pull/5080) ([Xalaxis](https://github.com/Xalaxis))
- Add systemd pattern list parameter to the documentation [\#5077](https://github.com/netdata/netdata/pull/5077) ([vlvkobal](https://github.com/vlvkobal))
- Fix update instructions URL in frontend [\#5076](https://github.com/netdata/netdata/pull/5076) ([jorisvervuurt](https://github.com/jorisvervuurt))
- Add how to add new alarm [\#5069](https://github.com/netdata/netdata/pull/5069) ([cakrit](https://github.com/cakrit))
- Fix cpuidle statistics in containers [\#5065](https://github.com/netdata/netdata/pull/5065) ([vlvkobal](https://github.com/vlvkobal))
- Fix coverity issues [\#5061](https://github.com/netdata/netdata/pull/5061) ([vlvkobal](https://github.com/vlvkobal))
- Disable cpuidle module if schedstat file is missing [\#5059](https://github.com/netdata/netdata/pull/5059) ([vlvkobal](https://github.com/vlvkobal))
- Fixed typo [\#5054](https://github.com/netdata/netdata/pull/5054) ([samnela](https://github.com/samnela))
- New option clear\_alarm\_always [\#5050](https://github.com/netdata/netdata/pull/5050) ([dex4er](https://github.com/dex4er))
- fix IEC units in bash modules [\#5049](https://github.com/netdata/netdata/pull/5049) ([paulfantom](https://github.com/paulfantom))
- Gracefully ignore the offset if the value is not a number [\#5040](https://github.com/netdata/netdata/pull/5040) ([cakrit](https://github.com/cakrit))
- Fix process statistics collection for FreeBSD in apps.plugin [\#5038](https://github.com/netdata/netdata/pull/5038) ([vlvkobal](https://github.com/vlvkobal))
- Apcupsd add check for UPS online [\#5037](https://github.com/netdata/netdata/pull/5037) ([cakrit](https://github.com/cakrit))
- Add warning for offset in Counter64 metrics [\#5032](https://github.com/netdata/netdata/pull/5032) ([cakrit](https://github.com/cakrit))
- Add other web servers to proxy instructions [\#5027](https://github.com/netdata/netdata/pull/5027) ([cakrit](https://github.com/cakrit))
- copy updater script instead of linking it [\#5010](https://github.com/netdata/netdata/pull/5010) ([paulfantom](https://github.com/paulfantom))

## [v1.12.0-rc1](https://github.com/netdata/netdata/tree/v1.12.0-rc1) (2018-12-19)

**Fixed bugs:**

- mdstat module causing netdata segv and crash [\#4990](https://github.com/netdata/netdata/issues/4990)
- Cannot read /proc/mdstat line. Expected 7 params, read 6. [\#4975](https://github.com/netdata/netdata/issues/4975)
- custom notification method does not work [\#4968](https://github.com/netdata/netdata/issues/4968)
- Info logging command in netdata-updater.sh contains command substitution. [\#4950](https://github.com/netdata/netdata/issues/4950)
- No data in charts [\#4920](https://github.com/netdata/netdata/issues/4920)
- Postgres module: detect servers version and use the right query [\#4910](https://github.com/netdata/netdata/issues/4910)
- Uninstaller script is always interactive [\#4791](https://github.com/netdata/netdata/issues/4791)
- Cannot update & cannot disable mail logging of events [\#4557](https://github.com/netdata/netdata/issues/4557)
- web\_log plugin cannot handle high load traffic [\#4354](https://github.com/netdata/netdata/issues/4354)
- \[bug\]some metrics don't report to /allmetrics endpoint with prometheus format [\#3866](https://github.com/netdata/netdata/issues/3866)

**Closed issues:**

- move python module portcheck to go.d [\#5005](https://github.com/netdata/netdata/issues/5005)
- move python module httpcheck to go.d [\#5004](https://github.com/netdata/netdata/issues/5004)
- move python module lighttpd to go.d [\#5003](https://github.com/netdata/netdata/issues/5003)
- move python module rabbitmq to go.d  [\#5002](https://github.com/netdata/netdata/issues/5002)
- move python module nginx to go.d [\#5001](https://github.com/netdata/netdata/issues/5001)
- move python module apache to go.d [\#5000](https://github.com/netdata/netdata/issues/5000)
- Pass cloud\_base\_url from netdata.conf to web/gui [\#4980](https://github.com/netdata/netdata/issues/4980)
- Improve configuration documentation [\#4781](https://github.com/netdata/netdata/issues/4781)
- Python.d.plugin infinite retries, ignore penalty, and plotting 'None' [\#4756](https://github.com/netdata/netdata/issues/4756)
- move `/proc` and `/sys` python modules to `proc` plugin [\#4541](https://github.com/netdata/netdata/issues/4541)
- mdstat RAID0 support [\#4010](https://github.com/netdata/netdata/issues/4010)
- FreeIPMI Plugin cant graph the wattage [\#3977](https://github.com/netdata/netdata/issues/3977)
- web\_log: charts per URL [\#3111](https://github.com/netdata/netdata/issues/3111)
- FQDN in alert sending [\#2477](https://github.com/netdata/netdata/issues/2477)
- on frontend, if JavaScript is disabled, there's no graceful degradation [\#2422](https://github.com/netdata/netdata/issues/2422)
- netdata dead but pid file exists [\#2266](https://github.com/netdata/netdata/issues/2266)

**Merged pull requests:**

- Non-interactive uninstaller [\#5021](https://github.com/netdata/netdata/pull/5021) ([paulfantom](https://github.com/paulfantom))
- Kavenegar returns 200 [\#5020](https://github.com/netdata/netdata/pull/5020) ([salehi](https://github.com/salehi))
- Fix missing method\_name: kavenegar [\#5019](https://github.com/netdata/netdata/pull/5019) ([salehi](https://github.com/salehi))
- remove cross-directory dependency in build system [\#5012](https://github.com/netdata/netdata/pull/5012) ([paulfantom](https://github.com/paulfantom))
- Move installer dir under packaging [\#5009](https://github.com/netdata/netdata/pull/5009) ([paulfantom](https://github.com/paulfantom))
- Show a warning if JavaScript is disabled \#2422 [\#4999](https://github.com/netdata/netdata/pull/4999) ([gmosx](https://github.com/gmosx))
- \[python\] make units compliant with IEC standard  [\#4995](https://github.com/netdata/netdata/pull/4995) ([ilyam8](https://github.com/ilyam8))
- Integrate patches from freeipmi and set paramters [\#4993](https://github.com/netdata/netdata/pull/4993) ([Preisschild](https://github.com/Preisschild))
- Fix crash in mdstat module [\#4992](https://github.com/netdata/netdata/pull/4992) ([vlvkobal](https://github.com/vlvkobal))
- Update cgroup-name.sh.in [\#4991](https://github.com/netdata/netdata/pull/4991) ([n0coast](https://github.com/n0coast))
- postgres timeouts [\#4988](https://github.com/netdata/netdata/pull/4988) ([ilyam8](https://github.com/ilyam8))
- Make units compliant with IEC standard [\#4985](https://github.com/netdata/netdata/pull/4985) ([vlvkobal](https://github.com/vlvkobal))
- Typo: `stab\_status` -\> `stub\_status` [\#4984](https://github.com/netdata/netdata/pull/4984) ([petecooper](https://github.com/petecooper))
- Pass cloud\_base\_url from daemon to web/gui through hello endpoint \#4980 [\#4982](https://github.com/netdata/netdata/pull/4982) ([gmosx](https://github.com/gmosx))
- Fix to \#4968, custom recipients were not working properly [\#4978](https://github.com/netdata/netdata/pull/4978) ([cakrit](https://github.com/cakrit))
- Fix mdstat parsing [\#4977](https://github.com/netdata/netdata/pull/4977) ([vlvkobal](https://github.com/vlvkobal))
- GCS access key shouldn't be encrypted [\#4976](https://github.com/netdata/netdata/pull/4976) ([paulfantom](https://github.com/paulfantom))
- Fix accidentally changed file permissions [\#4974](https://github.com/netdata/netdata/pull/4974) ([vlvkobal](https://github.com/vlvkobal))
- fix month 'Dec' being detected as IPv6 address in ovpn python.d plugin [\#4970](https://github.com/netdata/netdata/pull/4970) ([vpnable](https://github.com/vpnable))
- Add support for Factorio server monitoring [\#4966](https://github.com/netdata/netdata/pull/4966) ([jonfairbanks](https://github.com/jonfairbanks))
- Add mdstat to CMake configuration [\#4965](https://github.com/netdata/netdata/pull/4965) ([vlvkobal](https://github.com/vlvkobal))
- Move power supply python module to proc plugin [\#4960](https://github.com/netdata/netdata/pull/4960) ([vlvkobal](https://github.com/vlvkobal))
- dovecot readme update [\#4959](https://github.com/netdata/netdata/pull/4959) ([ilyam8](https://github.com/ilyam8))
- Add cakrit to health codeowners [\#4953](https://github.com/netdata/netdata/pull/4953) ([cakrit](https://github.com/cakrit))
- Prevent netdata-updater.sh from sending cron report for git stash entries [\#4952](https://github.com/netdata/netdata/pull/4952) ([cakrit](https://github.com/cakrit))
- Temporary workaround for \#4945 [\#4951](https://github.com/netdata/netdata/pull/4951) ([cakrit](https://github.com/cakrit))
- allow label modification [\#4949](https://github.com/netdata/netdata/pull/4949) ([paulfantom](https://github.com/paulfantom))
- Fix link in streaming hosts list [\#4948](https://github.com/netdata/netdata/pull/4948) ([adherzog](https://github.com/adherzog))
- Show demosite/host in GA for demo sites [\#4947](https://github.com/netdata/netdata/pull/4947) ([cakrit](https://github.com/cakrit))
- Update GA in demosites.html [\#4946](https://github.com/netdata/netdata/pull/4946) ([cakrit](https://github.com/cakrit))
- postgres fix: detect servers version and use the right query [\#4944](https://github.com/netdata/netdata/pull/4944) ([ilyam8](https://github.com/ilyam8))
- Add support for providing FQDN in alarm notifications. [\#4943](https://github.com/netdata/netdata/pull/4943) ([Ferroin](https://github.com/Ferroin))
- Add header to SMA webbox readme [\#4942](https://github.com/netdata/netdata/pull/4942) ([cakrit](https://github.com/cakrit))
- Add doc before path to GA in static site [\#4940](https://github.com/netdata/netdata/pull/4940) ([cakrit](https://github.com/cakrit))
- Add a Google Analytics tag to every markdown [\#4938](https://github.com/netdata/netdata/pull/4938) ([cakrit](https://github.com/cakrit))
- Update README.md [\#4937](https://github.com/netdata/netdata/pull/4937) ([cakrit](https://github.com/cakrit))
- python.d.plugin update [\#4936](https://github.com/netdata/netdata/pull/4936) ([ilyam8](https://github.com/ilyam8))
- Update Performance.md [\#4935](https://github.com/netdata/netdata/pull/4935) ([cakrit](https://github.com/cakrit))
- cleaner labeler code [\#4933](https://github.com/netdata/netdata/pull/4933) ([paulfantom](https://github.com/paulfantom))
- use proper request types and urls to update labels [\#4931](https://github.com/netdata/netdata/pull/4931) ([paulfantom](https://github.com/paulfantom))
- update code owners [\#4930](https://github.com/netdata/netdata/pull/4930) ([paulfantom](https://github.com/paulfantom))
- Removed vlvkobal as a codeowner of web/gui [\#4929](https://github.com/netdata/netdata/pull/4929) ([gmosx](https://github.com/gmosx))
- Add support for nonredundant arrays [\#4923](https://github.com/netdata/netdata/pull/4923) ([vlvkobal](https://github.com/vlvkobal))
- Config docs improvements [\#4918](https://github.com/netdata/netdata/pull/4918) ([cakrit](https://github.com/cakrit))
- Introduced IEC-compliant unit abbreviations \#4711 [\#4912](https://github.com/netdata/netdata/pull/4912) ([gmosx](https://github.com/gmosx))

## [v1.12.0-rc0](https://github.com/netdata/netdata/tree/v1.12.0-rc0) (2018-12-06)

**Fixed bugs:**

- nvidia\_smi module bug [\#4892](https://github.com/netdata/netdata/issues/4892)
- No alarms are running in some systems [\#4809](https://github.com/netdata/netdata/issues/4809)
- netdata-updater.sh cron report [\#4808](https://github.com/netdata/netdata/issues/4808)
- Netdata is not generating any alarms [\#4793](https://github.com/netdata/netdata/issues/4793)
- Fail2ban: Read "Restore Ban" for persistent bans [\#4769](https://github.com/netdata/netdata/issues/4769)
- Change in Incomming Webhooks Slack API breaks alerts [\#4755](https://github.com/netdata/netdata/issues/4755)
- registry items are clickable, but no action is taken [\#4721](https://github.com/netdata/netdata/issues/4721)
- Enable default alarms disabled after restart service netdata [\#4636](https://github.com/netdata/netdata/issues/4636)
- Spec file doesn't generate configure script before build [\#4570](https://github.com/netdata/netdata/issues/4570)
- sensors.chart.py ignores fans running at 0 RPM when netdata was started [\#4158](https://github.com/netdata/netdata/issues/4158)
- Postgres plugin lock output incorrect [\#4090](https://github.com/netdata/netdata/issues/4090)
- python plugins got behind by 5 seconds [\#3752](https://github.com/netdata/netdata/issues/3752)
- Constant stream of "chart took too long to be updated" INFO messages in error.log [\#3505](https://github.com/netdata/netdata/issues/3505)
- SNMP 64bit Counter Issue - Far from correct bandwidth values [\#3488](https://github.com/netdata/netdata/issues/3488)
- Update health reference documentation [\#3468](https://github.com/netdata/netdata/issues/3468)
- Alarm badge link escaping for disk paths in default dashboard [\#3253](https://github.com/netdata/netdata/issues/3253)

**Closed issues:**

- Docker netdata documentation [\#4899](https://github.com/netdata/netdata/issues/4899)
- Tiny Proxy monitoring [\#4834](https://github.com/netdata/netdata/issues/4834)
- Phusion Passenger monitoring [\#4833](https://github.com/netdata/netdata/issues/4833)
- Iis monitoring [\#4832](https://github.com/netdata/netdata/issues/4832)
- Scaleio monitoring [\#4828](https://github.com/netdata/netdata/issues/4828)
- Gluster monitoring [\#4827](https://github.com/netdata/netdata/issues/4827)
- Leofs monitoring [\#4826](https://github.com/netdata/netdata/issues/4826)
- Jumpy data when running on kubernetes [\#4778](https://github.com/netdata/netdata/issues/4778)
- Create documentation on how to opt-out of anonymous data collection [\#4746](https://github.com/netdata/netdata/issues/4746)
- Use `--future-release` in changelog generation [\#4718](https://github.com/netdata/netdata/issues/4718)
- requirements.txt in TLD are not related to netdata [\#4693](https://github.com/netdata/netdata/issues/4693)
- What is The Right Role for Netdata MongoDB Python Plugins? [\#4666](https://github.com/netdata/netdata/issues/4666)
- Store nightly build artifacts somewhere [\#4628](https://github.com/netdata/netdata/issues/4628)
- Remove old packaging scripts [\#4608](https://github.com/netdata/netdata/issues/4608)
- Use the new logo in web/gui [\#4598](https://github.com/netdata/netdata/issues/4598)
- Labelling bot [\#4528](https://github.com/netdata/netdata/issues/4528)
- Extract registry functionality from dashboard.js [\#4474](https://github.com/netdata/netdata/issues/4474)
- HTML Documentation  [\#4439](https://github.com/netdata/netdata/issues/4439)
- New documentation structure [\#4321](https://github.com/netdata/netdata/issues/4321)
- Add instructions to debug alarm notifications [\#4319](https://github.com/netdata/netdata/issues/4319)
- Fix file classification in LGTM [\#4259](https://github.com/netdata/netdata/issues/4259)
- Add CONTRIBUTING.md [\#4146](https://github.com/netdata/netdata/issues/4146)
- Send alerts via Slack to a single user \(direct message\)? [\#3722](https://github.com/netdata/netdata/issues/3722)
- golang orchestrator [\#3589](https://github.com/netdata/netdata/issues/3589)
- \[web api\] Add /api/v1/version [\#3540](https://github.com/netdata/netdata/issues/3540)
- Feature: UKSM support [\#2994](https://github.com/netdata/netdata/issues/2994)
- web\_log reports unmatched lines [\#2295](https://github.com/netdata/netdata/issues/2295)
- Ceph support [\#1673](https://github.com/netdata/netdata/issues/1673)
- Misaligned option points of REST API v1 endpoint data [\#1628](https://github.com/netdata/netdata/issues/1628)
- Adding support for time markers [\#1195](https://github.com/netdata/netdata/issues/1195)
- Scheduled “downtime” for a type of check? [\#1133](https://github.com/netdata/netdata/issues/1133)
- split snmp.conf into several conf files possible? [\#1126](https://github.com/netdata/netdata/issues/1126)
- sensu/collectd integration [\#174](https://github.com/netdata/netdata/issues/174)

**Merged pull requests:**

- run shfmt on CI scripts [\#4928](https://github.com/netdata/netdata/pull/4928) ([paulfantom](https://github.com/paulfantom))
- use relative path for logo [\#4927](https://github.com/netdata/netdata/pull/4927) ([ktsaou](https://github.com/ktsaou))
- fix symbolic link file detection in etc [\#4926](https://github.com/netdata/netdata/pull/4926) ([ktsaou](https://github.com/ktsaou))
- send all git log msg to fd3 [\#4922](https://github.com/netdata/netdata/pull/4922) ([paulfantom](https://github.com/paulfantom))
- RabbitMQ chart for message rates should be "line" [\#4916](https://github.com/netdata/netdata/pull/4916) ([dex4er](https://github.com/dex4er))
- better labeling [\#4915](https://github.com/netdata/netdata/pull/4915) ([paulfantom](https://github.com/paulfantom))
- Improve docker installation readme, docs navbar fix [\#4914](https://github.com/netdata/netdata/pull/4914) ([cakrit](https://github.com/cakrit))
- Use the new logo in the UI [\#4913](https://github.com/netdata/netdata/pull/4913) ([gmosx](https://github.com/gmosx))
- fix info api method compilation warnings [\#4911](https://github.com/netdata/netdata/pull/4911) ([ktsaou](https://github.com/ktsaou))
- smartd\_log: ata 194 attr fix [\#4908](https://github.com/netdata/netdata/pull/4908) ([ilyam8](https://github.com/ilyam8))
- Do not update repositories in CI operating system  [\#4907](https://github.com/netdata/netdata/pull/4907) ([paulfantom](https://github.com/paulfantom))
- Don't use IE11 incompatible for-const \#4710 [\#4906](https://github.com/netdata/netdata/pull/4906) ([gmosx](https://github.com/gmosx))
- Update python.d readme [\#4905](https://github.com/netdata/netdata/pull/4905) ([cakrit](https://github.com/cakrit))
- do not use protected variable name in updater script [\#4902](https://github.com/netdata/netdata/pull/4902) ([paulfantom](https://github.com/paulfantom))
- postgres module: locks count fix [\#4901](https://github.com/netdata/netdata/pull/4901) ([ilyam8](https://github.com/ilyam8))
- treat DT\_UNKNOWN files as regular files [\#4898](https://github.com/netdata/netdata/pull/4898) ([ktsaou](https://github.com/ktsaou))
- more health debugging to trace config files [\#4897](https://github.com/netdata/netdata/pull/4897) ([ktsaou](https://github.com/ktsaou))
- added debug statements when loading health config files [\#4896](https://github.com/netdata/netdata/pull/4896) ([ktsaou](https://github.com/ktsaou))
- Added info on health configuration and page for Charts [\#4895](https://github.com/netdata/netdata/pull/4895) ([cakrit](https://github.com/cakrit))
- added more debug outpput to freeipmi [\#4894](https://github.com/netdata/netdata/pull/4894) ([ktsaou](https://github.com/ktsaou))
- nvidia\_smi: handle `N/A` values [\#4893](https://github.com/netdata/netdata/pull/4893) ([ilyam8](https://github.com/ilyam8))
- add api/v1/info endpoint to swagger [\#4807](https://github.com/netdata/netdata/pull/4807) ([Wing924](https://github.com/Wing924))
- Update CONTRIBUTING.md [\#4805](https://github.com/netdata/netdata/pull/4805) ([cakrit](https://github.com/cakrit))
- Add info from PR 208 [\#4804](https://github.com/netdata/netdata/pull/4804) ([cakrit](https://github.com/cakrit))
- Anonymize IPs in README.md Google Analytics [\#4803](https://github.com/netdata/netdata/pull/4803) ([cakrit](https://github.com/cakrit))
- Minor updates in htmldoc [\#4802](https://github.com/netdata/netdata/pull/4802) ([cakrit](https://github.com/cakrit))
- Add cookie consent javascript to docs [\#4801](https://github.com/netdata/netdata/pull/4801) ([cakrit](https://github.com/cakrit))
- Improve SYNPROXY documentation [\#4800](https://github.com/netdata/netdata/pull/4800) ([cakrit](https://github.com/cakrit))
- Add debug instructions for python modules [\#4799](https://github.com/netdata/netdata/pull/4799) ([cakrit](https://github.com/cakrit))
- Added Legal section to documentation, added missing link for apps.plugin [\#4797](https://github.com/netdata/netdata/pull/4797) ([cakrit](https://github.com/cakrit))
- auto-label PRs and minor cleanup [\#4795](https://github.com/netdata/netdata/pull/4795) ([paulfantom](https://github.com/paulfantom))
- automatic labeling of new features [\#4792](https://github.com/netdata/netdata/pull/4792) ([paulfantom](https://github.com/paulfantom))
- Small content change to the netdata-installer.sh [\#4790](https://github.com/netdata/netdata/pull/4790) ([ei8fdb](https://github.com/ei8fdb))
- lifecycle test [\#4789](https://github.com/netdata/netdata/pull/4789) ([paulfantom](https://github.com/paulfantom))
- Documentation TOC bug fix [\#4787](https://github.com/netdata/netdata/pull/4787) ([cakrit](https://github.com/cakrit))
- netdata-security doc corrections [\#4786](https://github.com/netdata/netdata/pull/4786) ([cakrit](https://github.com/cakrit))
- Update README.md for release 1.11.1 [\#4777](https://github.com/netdata/netdata/pull/4777) ([taniaab](https://github.com/taniaab))
- Fix typo in "Github Star" documentation [\#4776](https://github.com/netdata/netdata/pull/4776) ([josemaia](https://github.com/josemaia))
- Added a few more debugging instructions for notifications [\#4774](https://github.com/netdata/netdata/pull/4774) ([cakrit](https://github.com/cakrit))
- buildhtml.sh should exit with 1 if anything fails [\#4773](https://github.com/netdata/netdata/pull/4773) ([cakrit](https://github.com/cakrit))
- fail2ban fix: add 'Restore Ban' action [\#4772](https://github.com/netdata/netdata/pull/4772) ([ilyam8](https://github.com/ilyam8))
- add api/v1/info endpoint [\#4770](https://github.com/netdata/netdata/pull/4770) ([Wing924](https://github.com/Wing924))
- Move mdstat python module to proc plugin [\#4768](https://github.com/netdata/netdata/pull/4768) ([vlvkobal](https://github.com/vlvkobal))
- bugfix: query engine resampling duration [\#4759](https://github.com/netdata/netdata/pull/4759) ([ktsaou](https://github.com/ktsaou))
- web\_log: add alarm on unmatched lines [\#4757](https://github.com/netdata/netdata/pull/4757) ([ilyam8](https://github.com/ilyam8))
- sensors: don't ignore 0 RPM funs on start [\#4753](https://github.com/netdata/netdata/pull/4753) ([ilyam8](https://github.com/ilyam8))
- Use var to make NETDATA variable global [\#4752](https://github.com/netdata/netdata/pull/4752) ([gmosx](https://github.com/gmosx))
- move build Dockerfiles to external repo [\#4749](https://github.com/netdata/netdata/pull/4749) ([paulfantom](https://github.com/paulfantom))
- remove rolling version suffix [\#4748](https://github.com/netdata/netdata/pull/4748) ([paulfantom](https://github.com/paulfantom))
- Docs point to docs.netdata.cloud instead of wiki. Correct padding-bot… [\#4747](https://github.com/netdata/netdata/pull/4747) ([cakrit](https://github.com/cakrit))
- Make Getting Started just a top level link [\#4740](https://github.com/netdata/netdata/pull/4740) ([cakrit](https://github.com/cakrit))
- docker: correct invalid syntax [\#4738](https://github.com/netdata/netdata/pull/4738) ([paulfantom](https://github.com/paulfantom))
- Make the whole title area clickable,  closes \#4721 [\#4733](https://github.com/netdata/netdata/pull/4733) ([gmosx](https://github.com/gmosx))
- Correctly apply B unit conversion [\#4724](https://github.com/netdata/netdata/pull/4724) ([gmosx](https://github.com/gmosx))
- add more layers to container image [\#4722](https://github.com/netdata/netdata/pull/4722) ([paulfantom](https://github.com/paulfantom))
- python.d: use real time for calc sinceLast [\#4720](https://github.com/netdata/netdata/pull/4720) ([ilyam8](https://github.com/ilyam8))
- strictier use of URL separators [\#4716](https://github.com/netdata/netdata/pull/4716) ([ktsaou](https://github.com/ktsaou))
- Test integrity of dashboard.js [\#4715](https://github.com/netdata/netdata/pull/4715) ([paulfantom](https://github.com/paulfantom))
- fix\(pagerduty\): Use cURL instead of PagerDuty agent to send alarms. [\#4694](https://github.com/netdata/netdata/pull/4694) ([elisiariocouto](https://github.com/elisiariocouto))
- lint all shell collectors code [\#4690](https://github.com/netdata/netdata/pull/4690) ([paulfantom](https://github.com/paulfantom))
- Move cpuidle python module to proc plugin [\#4635](https://github.com/netdata/netdata/pull/4635) ([vlvkobal](https://github.com/vlvkobal))
- Cleanup docker packaging and contrib [\#4627](https://github.com/netdata/netdata/pull/4627) ([paulfantom](https://github.com/paulfantom))
- Better updater [\#4558](https://github.com/netdata/netdata/pull/4558) ([paulfantom](https://github.com/paulfantom))
- Generalize the recipient finding logic and reduce the boilerplate code. [\#3960](https://github.com/netdata/netdata/pull/3960) ([Ferroin](https://github.com/Ferroin))
- RPM spec and patches for sles 11 [\#3708](https://github.com/netdata/netdata/pull/3708) ([veksh](https://github.com/veksh))

## [v1.11.1](https://github.com/netdata/netdata/tree/v1.11.1) (2018-11-22)

**Fixed bugs:**

- Sensors module of python plugin not working \(again?\) [\#4692](https://github.com/netdata/netdata/issues/4692)
- Ubuntu 18.04 apt package is still on v1.9.0, though apt is the recommended installation method [\#4675](https://github.com/netdata/netdata/issues/4675)
- pre-built static binary install script does not detect SLES as systemd OS [\#4641](https://github.com/netdata/netdata/issues/4641)
- Sensors don`t work [\#4602](https://github.com/netdata/netdata/issues/4602)
- smartd\_log check\(\) unhandled exception: 'list' object has no attribute 'clear' [\#4583](https://github.com/netdata/netdata/issues/4583)
- 1m\_received\_traffic\_overflow alarm is faulty on 10G or 40G network interfaces [\#4577](https://github.com/netdata/netdata/issues/4577)
- 1.11 release reports as 1.10.0\_rolling [\#4572](https://github.com/netdata/netdata/issues/4572)
- update  netdata error  [\#4560](https://github.com/netdata/netdata/issues/4560)
- edit-config uses vi, even if it isn't the system editor [\#4549](https://github.com/netdata/netdata/issues/4549)
- inbound packets dropped inbound  [\#4536](https://github.com/netdata/netdata/issues/4536)
- incremental chart algorithm doesn't handle counter wrap properly [\#4533](https://github.com/netdata/netdata/issues/4533)
- Disk full \(inodes\) due to netdata [\#4518](https://github.com/netdata/netdata/issues/4518)
- Systemd not working on Ubuntu 14.04 [\#4465](https://github.com/netdata/netdata/issues/4465)
- Links on the wiki are returning 404s [\#4408](https://github.com/netdata/netdata/issues/4408)
- It figures [\#4184](https://github.com/netdata/netdata/issues/4184)
- netdata stream clients disconnecting from netdata server [\#4049](https://github.com/netdata/netdata/issues/4049)
- False positive alarm for RAM [\#4013](https://github.com/netdata/netdata/issues/4013)
- Occasional rm "cannot remove" on netdata-updater [\#3457](https://github.com/netdata/netdata/issues/3457)
- opensuse - installation by hand issues due to hardcoded libexec in netdata-installer.sh [\#3346](https://github.com/netdata/netdata/issues/3346)
- Netdata Installation failed in Manjaro（Arch）Latest [\#2812](https://github.com/netdata/netdata/issues/2812)
- undefined applications show up in system category? [\#2385](https://github.com/netdata/netdata/issues/2385)
- memory mode map initialization slow when database is too big [\#2382](https://github.com/netdata/netdata/issues/2382)
- Long hostnames cause alignment issues in my-netdata [\#2335](https://github.com/netdata/netdata/issues/2335)
- dont get snmp running properly [\#1734](https://github.com/netdata/netdata/issues/1734)
- Plugins continue to log to old error.log after a SIGHUP [\#805](https://github.com/netdata/netdata/issues/805)

**Closed issues:**

- Improve footer of web/gui [\#4708](https://github.com/netdata/netdata/issues/4708)
- Ignores EMAIL\_SENDER [\#4695](https://github.com/netdata/netdata/issues/4695)
- Add option to do pre-releases in GitHub [\#4684](https://github.com/netdata/netdata/issues/4684)
- Invalid links in \*.md files [\#4672](https://github.com/netdata/netdata/issues/4672)
- Replace all wiki links with repo links in netdata files [\#4650](https://github.com/netdata/netdata/issues/4650)
- Replace http URLs with https in markdown fils [\#4626](https://github.com/netdata/netdata/issues/4626)
- Extract JS and CSS from index.html [\#4586](https://github.com/netdata/netdata/issues/4586)
- Improved management of netdata urls in the `my-netdata` menu [\#4582](https://github.com/netdata/netdata/issues/4582)
- Ignore web/gui/src in LGTM and Codacy checks. [\#4516](https://github.com/netdata/netdata/issues/4516)
- Remove excessive requestAnimationFrame\(\) compatibility checks [\#4501](https://github.com/netdata/netdata/issues/4501)
- Remove obsolete chart renderers [\#4492](https://github.com/netdata/netdata/issues/4492)
- Split dashboard.js into multiple files [\#4479](https://github.com/netdata/netdata/issues/4479)
- Hdd temperature monitoring on FreeBSD [\#4463](https://github.com/netdata/netdata/issues/4463)
- Modernize dashboard.js [\#4461](https://github.com/netdata/netdata/issues/4461)
- Documentation links sanity checker [\#4416](https://github.com/netdata/netdata/issues/4416)
- Write a blog entry about monitoring and performance tuning mysql with netdata [\#4326](https://github.com/netdata/netdata/issues/4326)
- Document supported python versions [\#4322](https://github.com/netdata/netdata/issues/4322)
- Add coverity scans to Travis [\#4248](https://github.com/netdata/netdata/issues/4248)
- Lint all shell scripts [\#4166](https://github.com/netdata/netdata/issues/4166)
- Include tests in CI pipeline [\#4133](https://github.com/netdata/netdata/issues/4133)
- Runfile installation doesn't fix earlier incorrect netdata init script [\#4009](https://github.com/netdata/netdata/issues/4009)
- http://IP:19999/lib/bootstrap-3.3.7.min.js [\#3908](https://github.com/netdata/netdata/issues/3908)
- Netdata - Spring boot plugin [\#2074](https://github.com/netdata/netdata/issues/2074)
- support standard deviation in reduce functions [\#808](https://github.com/netdata/netdata/issues/808)
- web server optimization [\#532](https://github.com/netdata/netdata/issues/532)
- Containers: running plugins in different namespaces to allow netdata collect application metrics from containers [\#474](https://github.com/netdata/netdata/issues/474)

**Merged pull requests:**

- Cleanup of web/gui footer [\#4709](https://github.com/netdata/netdata/pull/4709) ([gmosx](https://github.com/gmosx))
- added byte unit scaling [\#4707](https://github.com/netdata/netdata/pull/4707) ([AndCycle](https://github.com/AndCycle))
- Add missing quote to tc-qos-helper.sh.in [\#4703](https://github.com/netdata/netdata/pull/4703) ([drwtsn32x](https://github.com/drwtsn32x))
- Fix typo and py2 compatibility issue. [\#4697](https://github.com/netdata/netdata/pull/4697) ([Ferroin](https://github.com/Ferroin))
- Update Doc links for adding charts and alarms in sidebar. Isuue \#4650 [\#4669](https://github.com/netdata/netdata/pull/4669) ([nekkabcire](https://github.com/nekkabcire))
- Update lm\_sensors and catch specific errors. [\#4667](https://github.com/netdata/netdata/pull/4667) ([Ferroin](https://github.com/Ferroin))
- Remove left over code [\#4662](https://github.com/netdata/netdata/pull/4662) ([xPaw](https://github.com/xPaw))
- Fix changelog path, add all README.md files to Debian package doc [\#4657](https://github.com/netdata/netdata/pull/4657) ([runejuhl](https://github.com/runejuhl))
- properly parse network interface names with colon on them [\#4653](https://github.com/netdata/netdata/pull/4653) ([ktsaou](https://github.com/ktsaou))
- sensors module fix [\#4651](https://github.com/netdata/netdata/pull/4651) ([ilyam8](https://github.com/ilyam8))
- Update installer/functions.sh [\#4643](https://github.com/netdata/netdata/pull/4643) ([tsingletonacic](https://github.com/tsingletonacic))
- Fix documentation in beanstalk.conf. [\#4639](https://github.com/netdata/netdata/pull/4639) ([Ferroin](https://github.com/Ferroin))
- Minor cleanup of main.js [\#4634](https://github.com/netdata/netdata/pull/4634) ([gmosx](https://github.com/gmosx))
- Fixed tc-helper plugin broken link [\#4617](https://github.com/netdata/netdata/pull/4617) ([ofirule](https://github.com/ofirule))
- Another Readme Update [\#4612](https://github.com/netdata/netdata/pull/4612) ([ktsaou](https://github.com/ktsaou))
- Fix spelling mistake in dashboard\_info.js [\#4601](https://github.com/netdata/netdata/pull/4601) ([hotio](https://github.com/hotio))
- bug fix: conntrack\_max alarm was accessing invalid variable [\#4595](https://github.com/netdata/netdata/pull/4595) ([ktsaou](https://github.com/ktsaou))
- fixed max interface speed calculation [\#4594](https://github.com/netdata/netdata/pull/4594) ([ktsaou](https://github.com/ktsaou))
- Issue 4582 \(Show alternate urls in my-netdata menu\) [\#4590](https://github.com/netdata/netdata/pull/4590) ([gmosx](https://github.com/gmosx))
- nvidia\_smi: init version added [\#4589](https://github.com/netdata/netdata/pull/4589) ([ilyam8](https://github.com/ilyam8))
- smartd\_log: py2 compatibility fix [\#4584](https://github.com/netdata/netdata/pull/4584) ([ilyam8](https://github.com/ilyam8))
- Split js 2 [\#4581](https://github.com/netdata/netdata/pull/4581) ([gmosx](https://github.com/gmosx))
- Alerta.io notification improvements [\#4576](https://github.com/netdata/netdata/pull/4576) ([satterly](https://github.com/satterly))
- netdata-openrc: Move check from depends\(\) to start\_pre\(\) [\#4575](https://github.com/netdata/netdata/pull/4575) ([aadityabagga](https://github.com/aadityabagga))
- Fix badges link that leads to 404. [\#4569](https://github.com/netdata/netdata/pull/4569) ([nekkabcire](https://github.com/nekkabcire))
- Move cpufreq python module to proc plugin [\#4562](https://github.com/netdata/netdata/pull/4562) ([vlvkobal](https://github.com/vlvkobal))
- decouple nightly cron jobs from packaging stage [\#4559](https://github.com/netdata/netdata/pull/4559) ([paulfantom](https://github.com/paulfantom))
- Clarify application configuration and fix broken link [\#4554](https://github.com/netdata/netdata/pull/4554) ([JBaczuk](https://github.com/JBaczuk))
- edit-config: Better support for custom editors. [\#4551](https://github.com/netdata/netdata/pull/4551) ([Ferroin](https://github.com/Ferroin))
- add tor python module [\#4546](https://github.com/netdata/netdata/pull/4546) ([ilyam8](https://github.com/ilyam8))
- incremental overflows should not show zeros values [\#4538](https://github.com/netdata/netdata/pull/4538) ([ktsaou](https://github.com/ktsaou))
- smartd\_log refactor plus SCSI support [\#4523](https://github.com/netdata/netdata/pull/4523) ([ilyam8](https://github.com/ilyam8))
- openldap monitoring plugin added [\#4513](https://github.com/netdata/netdata/pull/4513) ([ekartsonakis](https://github.com/ekartsonakis))
- Refactoring dashboard.js, splitting monolithic file into multiple source files. [\#4496](https://github.com/netdata/netdata/pull/4496) ([gmosx](https://github.com/gmosx))
- Switch e-mail threading to be enabled by default. [\#3780](https://github.com/netdata/netdata/pull/3780) ([Ferroin](https://github.com/Ferroin))

## [v1.11.0](https://github.com/netdata/netdata/tree/v1.11.0) (2018-11-02)

**Fixed bugs:**

- Cannot use oidname in snmp config [\#4512](https://github.com/netdata/netdata/issues/4512)
- config.status: error: cannot find input file: `web/api/badges/Makefile.in' [\#4502](https://github.com/netdata/netdata/issues/4502)
- Diskspace plugin accesses excluded filesystem and stalls netdata process [\#4491](https://github.com/netdata/netdata/issues/4491)
- netdata allocates 170MB memory after startup \(without the database\) [\#4487](https://github.com/netdata/netdata/issues/4487)
- Logcheck security alert: netdata : command not allowed ; TTY=unknown ; PWD=/etc/netdata ; USER=root ; COMMAND=validate [\#4473](https://github.com/netdata/netdata/issues/4473)
- duplicate name in cgroup if dash present in container name [\#4468](https://github.com/netdata/netdata/issues/4468)
- Wrong logos in infographic [\#4455](https://github.com/netdata/netdata/issues/4455)
- Netdata in Docker cannot load stock config \(permission denied\) [\#4453](https://github.com/netdata/netdata/issues/4453)
- Icecast module not working [\#4432](https://github.com/netdata/netdata/issues/4432)
- Installer does not detect systemd on Ubuntu 14.04 [\#4421](https://github.com/netdata/netdata/issues/4421)
- netdata.spec seems to reference missing files [\#4409](https://github.com/netdata/netdata/issues/4409)
- mongodb.chart.py does not check pymongo version [\#4407](https://github.com/netdata/netdata/issues/4407)
- node.d.plugin issue after modularizing plugins commit [\#4406](https://github.com/netdata/netdata/issues/4406)
- netdata: CONFIG: cannot load user config ‘/etc/netdata/stream.conf’. Will try stock config. [\#4403](https://github.com/netdata/netdata/issues/4403)
- netdata \(20181015\) compiles fine but 'make dist' aborts [\#4400](https://github.com/netdata/netdata/issues/4400)
- netdata does not compile on FreeBSD 11.2-RELEASE-p4 [\#4393](https://github.com/netdata/netdata/issues/4393)
- API documentation cannot be read [\#4371](https://github.com/netdata/netdata/issues/4371)
- Error message: Cannot open file stream.conf [\#4341](https://github.com/netdata/netdata/issues/4341)
- MegaCli Plugin fails to parse [\#4278](https://github.com/netdata/netdata/issues/4278)
- Apps plugin: wrong open\_sockets counter when fd type changes [\#4233](https://github.com/netdata/netdata/issues/4233)
- Logind bug [\#4230](https://github.com/netdata/netdata/issues/4230)
- Should netdata identify the js binary as NodeJS by default? [\#4217](https://github.com/netdata/netdata/issues/4217)
- Cannot load jQuery: ERROR 101 [\#4212](https://github.com/netdata/netdata/issues/4212)
- redis.chart.py stops with error "check\(\) unhandled exception: 'rdb\_bgsave\_in\_progress'" [\#4204](https://github.com/netdata/netdata/issues/4204)
- Failed to start netdata.service: Exec format error [\#4169](https://github.com/netdata/netdata/issues/4169)
- python clocks don't work under FreeBSD [\#4152](https://github.com/netdata/netdata/issues/4152)
- error: cannot take the address of an rvalue of type 'FILE \*' when building on OpenBSD [\#4145](https://github.com/netdata/netdata/issues/4145)
- packages installer failed [\#4119](https://github.com/netdata/netdata/issues/4119)
- update\_every in postgres plugin [\#4089](https://github.com/netdata/netdata/issues/4089)
- /proc/interrupts plugin memory leak [\#4051](https://github.com/netdata/netdata/issues/4051)
- Problem with logrotate config \(PID discovery\) [\#4020](https://github.com/netdata/netdata/issues/4020)
- \[SECURITY\] Mitigate CVE-2017-18342 [\#4012](https://github.com/netdata/netdata/issues/4012)
- Netdata looks in ../../../../ to get it's config [\#3988](https://github.com/netdata/netdata/issues/3988)
- Statsd counters/gauges stuck on -167,772,150,000,000 [\#3978](https://github.com/netdata/netdata/issues/3978)
- After netdata slave is rebooted, timestamp doesn't match [\#3966](https://github.com/netdata/netdata/issues/3966)
- netdata-updater.sh fails due to missing './' on 'netdata-installer.sh' line [\#3940](https://github.com/netdata/netdata/issues/3940)
- Problem with running any python.d plugin? [\#3854](https://github.com/netdata/netdata/issues/3854)
- Alert email syntax problem [\#3843](https://github.com/netdata/netdata/issues/3843)
- kickstart-static64.sh fails with sh as root [\#3840](https://github.com/netdata/netdata/issues/3840)
- Illegal characters in URLs [\#3819](https://github.com/netdata/netdata/issues/3819)
- Use bash loadable sleep in tc-qos-helper.sh [\#3754](https://github.com/netdata/netdata/issues/3754)
- btrfs shows wrong disk space when the filesystem has sector size 4k but the logical disk sector size is 512B [\#3746](https://github.com/netdata/netdata/issues/3746)
- ERROR 405 with squid and web\_logs plugin [\#3738](https://github.com/netdata/netdata/issues/3738)
- tcp listen alarm integer expression expected [\#3733](https://github.com/netdata/netdata/issues/3733)
- Cannot load required JS library: http://ipaddress:19999/dashboard\_info.js?v20180510-2 after update or fresh install [\#3707](https://github.com/netdata/netdata/issues/3707)
- IPv4 UDPLite stats are always visible, even if UDPLite is not used on a system [\#3706](https://github.com/netdata/netdata/issues/3706)
- When listening on a unix socket, web server still attempts to set TCP\_NODELAY. [\#3682](https://github.com/netdata/netdata/issues/3682)
- httpcheck do not accept URLs that do not end with com [\#3656](https://github.com/netdata/netdata/issues/3656)
- httpcheck python.d plugin fails [\#3641](https://github.com/netdata/netdata/issues/3641)
- Issue with statsd sample rate [\#3630](https://github.com/netdata/netdata/issues/3630)
- NetData and Kubernetes - Docker Name [\#3369](https://github.com/netdata/netdata/issues/3369)
- netdata-uninstaller.sh not working \(with macOS 10.13\) [\#2941](https://github.com/netdata/netdata/issues/2941)
- Problem with plugins in debug mode \(wrong path to cfgs\) [\#2593](https://github.com/netdata/netdata/issues/2593)
- dashboard with thousands of charts [\#2275](https://github.com/netdata/netdata/issues/2275)
- fix docker image tagging problem [\#4250](https://github.com/netdata/netdata/pull/4250) ([paulfantom](https://github.com/paulfantom))

**Closed issues:**

- Feature request: Support for Adaptec RAID [\#4396](https://github.com/netdata/netdata/issues/4396)
- Is there any way to diable the example chart? [\#4384](https://github.com/netdata/netdata/issues/4384)
- modularize c source [\#4339](https://github.com/netdata/netdata/issues/4339)
- Diff migration of Wiki updates to new documentation [\#4320](https://github.com/netdata/netdata/issues/4320)
- Change GPL-3.0+ to GPL-3.0-or-later in all SPDX headers [\#4274](https://github.com/netdata/netdata/issues/4274)
- How to stop some metrics to save bandwidth [\#4223](https://github.com/netdata/netdata/issues/4223)
- UTC Timezone [\#4202](https://github.com/netdata/netdata/issues/4202)
- stock config files should be in `/usr/lib/netdata/` [\#4182](https://github.com/netdata/netdata/issues/4182)
- Lint python code \(PEP8 standard\) [\#4167](https://github.com/netdata/netdata/issues/4167)
- Fail2ban'd IPv6 addresses are not processed [\#4144](https://github.com/netdata/netdata/issues/4144)
- httpcheck support for HTTP methods  \(e.g. GET, OPTIONS, HEAD, etc...\) [\#4127](https://github.com/netdata/netdata/issues/4127)
- Naming for Diskstats for Veritas Volume Manger disks [\#4116](https://github.com/netdata/netdata/issues/4116)
- Raise an alarm when a docker container is unhealthy [\#4111](https://github.com/netdata/netdata/issues/4111)
- elasticsearch plugin python json exception if another service running on port 9200 [\#4092](https://github.com/netdata/netdata/issues/4092)
- varnish 5 support [\#4073](https://github.com/netdata/netdata/issues/4073)
- 'Other' is the Largest Category Under Applications \> Mem due to Node processes [\#4063](https://github.com/netdata/netdata/issues/4063)
- send netdata health monitoring variables to backends [\#4035](https://github.com/netdata/netdata/issues/4035)
- Badges - seconds units [\#4029](https://github.com/netdata/netdata/issues/4029)
- Web\_log doesn't support response times in nanoseconds [\#4003](https://github.com/netdata/netdata/issues/4003)
- 400 error when netdata tries to send slack notification [\#3989](https://github.com/netdata/netdata/issues/3989)
- Disable probing device mapper [\#3974](https://github.com/netdata/netdata/issues/3974)
- MySQL Python Plugin not work  [\#3968](https://github.com/netdata/netdata/issues/3968)
- How to enable sensor plugin? [\#3953](https://github.com/netdata/netdata/issues/3953)
- netdata does not appear to send host tags via graphite backend [\#3936](https://github.com/netdata/netdata/issues/3936)
- Netdata breaks suspend in debian stretch [\#3842](https://github.com/netdata/netdata/issues/3842)
- NUT ups names [\#3829](https://github.com/netdata/netdata/issues/3829)
- New at netdata and a lot of alarms [\#3826](https://github.com/netdata/netdata/issues/3826)
- \[REQUEST\] Add Fleep/webhook notifications [\#3792](https://github.com/netdata/netdata/issues/3792)
- Enhancement  Redis protocol\(Pika\) ? [\#3783](https://github.com/netdata/netdata/issues/3783)
- Plugin for Litespeed stats [\#3781](https://github.com/netdata/netdata/issues/3781)
- Do you have in plan to implement Megacli \(hardware RAID\) support metrics ? [\#3757](https://github.com/netdata/netdata/issues/3757)
- Add a Safari pinned tab icon [\#3743](https://github.com/netdata/netdata/issues/3743)
- Colors for BTRFS graphs are inconsistent [\#3719](https://github.com/netdata/netdata/issues/3719)
- \[Information\] Adding tutorial for Netdata in HTTPS for Plesk systems [\#3717](https://github.com/netdata/netdata/issues/3717)
- hddtemp module fails: received data doesn't have needed records [\#3683](https://github.com/netdata/netdata/issues/3683)
- "alarm-notify.sh test" produces error exit code on success [\#3667](https://github.com/netdata/netdata/issues/3667)
- init file is not installed on Amazon Linux 2018.03 [\#3650](https://github.com/netdata/netdata/issues/3650)
- Option to prevent netdata dashboard.js from downloading FontAwesome [\#3644](https://github.com/netdata/netdata/issues/3644)
- FYI: Homebrew formula \(package\) of netdata for macOS  [\#3642](https://github.com/netdata/netdata/issues/3642)
- python.d nginx module -- stub status from https server block on localhost? [\#3628](https://github.com/netdata/netdata/issues/3628)
- mdadm mismatch\_cnt statistic/alarm [\#3622](https://github.com/netdata/netdata/issues/3622)
- Python.d postgres unhandled exception [\#3614](https://github.com/netdata/netdata/issues/3614)
- Support for RethinkDB stats [\#3422](https://github.com/netdata/netdata/issues/3422)
- Notifications to Microsoft Teams [\#3330](https://github.com/netdata/netdata/issues/3330)
- enable system alarms on freebsd [\#3267](https://github.com/netdata/netdata/issues/3267)
- web\_log: response time should support summary or histgram [\#3102](https://github.com/netdata/netdata/issues/3102)
- Alarm for big system load [\#3003](https://github.com/netdata/netdata/issues/3003)
- Illegal instruction - Debian Stretch i586 [\#2909](https://github.com/netdata/netdata/issues/2909)
- New documentation \[bounty\] [\#2638](https://github.com/netdata/netdata/issues/2638)
- web\_log: support squid logs [\#2235](https://github.com/netdata/netdata/issues/2235)
- Monitoring PHP APCu [\#2199](https://github.com/netdata/netdata/issues/2199)
- MySQLService \(or DatabaseService\) for python.d [\#1906](https://github.com/netdata/netdata/issues/1906)
- RocketChat notifications [\#1811](https://github.com/netdata/netdata/issues/1811)
- SCTP Information [\#1218](https://github.com/netdata/netdata/issues/1218)
- python.d enhancements [\#692](https://github.com/netdata/netdata/issues/692)
- feature request: pause all data processing if noone is watching the graphs [\#656](https://github.com/netdata/netdata/issues/656)
- netdata package maintainers [\#651](https://github.com/netdata/netdata/issues/651)

**Merged pull requests:**

- Changed swagger editor url to the correct one [\#4539](https://github.com/netdata/netdata/pull/4539) ([infeeeee](https://github.com/infeeeee))
- fixed wrong annotations given to google charts [\#4535](https://github.com/netdata/netdata/pull/4535) ([ktsaou](https://github.com/ktsaou))
- allow debugging memory per module [\#4524](https://github.com/netdata/netdata/pull/4524) ([ktsaou](https://github.com/ktsaou))
- fixed vulnerabilities identified by red4sec.com [\#4521](https://github.com/netdata/netdata/pull/4521) ([ktsaou](https://github.com/ktsaou))
- Do not enable unused per core interrupts by default [\#4519](https://github.com/netdata/netdata/pull/4519) ([ktsaou](https://github.com/ktsaou))
- exclude web/gui/src from codacy checks [\#4515](https://github.com/netdata/netdata/pull/4515) ([paulfantom](https://github.com/paulfantom))
- do not send duplicate chart names while streaming metrics [\#4508](https://github.com/netdata/netdata/pull/4508) ([ktsaou](https://github.com/ktsaou))
- fix RPM build [\#4507](https://github.com/netdata/netdata/pull/4507) ([ktsaou](https://github.com/ktsaou))
- Split the API formatters in modules [\#4504](https://github.com/netdata/netdata/pull/4504) ([ktsaou](https://github.com/ktsaou))
- fixed rpm build;  [\#4503](https://github.com/netdata/netdata/pull/4503) ([ktsaou](https://github.com/ktsaou))
- Fix\(snmp\): fix parse oidname and santilize dimension name [\#4498](https://github.com/netdata/netdata/pull/4498) ([Ehekatl](https://github.com/Ehekatl))
- fix query min-max, again... [\#4495](https://github.com/netdata/netdata/pull/4495) ([ktsaou](https://github.com/ktsaou))
- diskspace plugin should not stat\(\) excluded mountpoints [\#4494](https://github.com/netdata/netdata/pull/4494) ([ktsaou](https://github.com/ktsaou))
- restored min-max calculation of RRDR [\#4489](https://github.com/netdata/netdata/pull/4489) ([ktsaou](https://github.com/ktsaou))
- query engine documentation and stats [\#4483](https://github.com/netdata/netdata/pull/4483) ([ktsaou](https://github.com/ktsaou))
- fix query sum [\#4482](https://github.com/netdata/netdata/pull/4482) ([ktsaou](https://github.com/ktsaou))
- query code cleanup [\#4480](https://github.com/netdata/netdata/pull/4480) ([ktsaou](https://github.com/ktsaou))
- Fix checking of grouping time [\#4478](https://github.com/netdata/netdata/pull/4478) ([vlvkobal](https://github.com/vlvkobal))
- Disable python sudo modules by default [\#4477](https://github.com/netdata/netdata/pull/4477) ([ilyam8](https://github.com/ilyam8))
- bug-fix: fixed aligned queries that returned no data [\#4472](https://github.com/netdata/netdata/pull/4472) ([ktsaou](https://github.com/ktsaou))
- Add proxysql to python.d.plugin Makefile.am [\#4466](https://github.com/netdata/netdata/pull/4466) ([alibo](https://github.com/alibo))
- updated tests for the new hierarchy [\#4464](https://github.com/netdata/netdata/pull/4464) ([ktsaou](https://github.com/ktsaou))
- Remove duplicated entry and put modules in order in python.d.conf [\#4460](https://github.com/netdata/netdata/pull/4460) ([vladmovchan](https://github.com/vladmovchan))
- fix permissions for config files in a container [\#4454](https://github.com/netdata/netdata/pull/4454) ([paulfantom](https://github.com/paulfantom))
- mongodb fix  [\#4449](https://github.com/netdata/netdata/pull/4449) ([ilyam8](https://github.com/ilyam8))
- icecast bugfix [\#4448](https://github.com/netdata/netdata/pull/4448) ([ilyam8](https://github.com/ilyam8))
- invalidate incorrect rpm spec changelog [\#4445](https://github.com/netdata/netdata/pull/4445) ([paulfantom](https://github.com/paulfantom))
- modularize the query api [\#4443](https://github.com/netdata/netdata/pull/4443) ([ktsaou](https://github.com/ktsaou))
- Indicate FreeIPMI support for FreeBSD [\#4440](https://github.com/netdata/netdata/pull/4440) ([openspork](https://github.com/openspork))
- remove unused variables [\#4437](https://github.com/netdata/netdata/pull/4437) ([paulfantom](https://github.com/paulfantom))
- Feat: detect NIC speed and alarm on each device for net traffic overflow [\#4430](https://github.com/netdata/netdata/pull/4430) ([Ehekatl](https://github.com/Ehekatl))
- fix streaming bug [\#4425](https://github.com/netdata/netdata/pull/4425) ([ktsaou](https://github.com/ktsaou))
- fix systemd detection;  [\#4423](https://github.com/netdata/netdata/pull/4423) ([ktsaou](https://github.com/ktsaou))
- moved stream.conf initialization after log files have been open [\#4422](https://github.com/netdata/netdata/pull/4422) ([ktsaou](https://github.com/ktsaou))
- Fix cmake build on macos [\#4420](https://github.com/netdata/netdata/pull/4420) ([Ehekatl](https://github.com/Ehekatl))
- Evaluate $used\_ram\_to\_ignore on FreeBSD [\#4419](https://github.com/netdata/netdata/pull/4419) ([openspork](https://github.com/openspork))
- fix node.d.plugin;  [\#4413](https://github.com/netdata/netdata/pull/4413) ([ktsaou](https://github.com/ktsaou))
- fix netdata.spec for new directory structure [\#4410](https://github.com/netdata/netdata/pull/4410) ([ktsaou](https://github.com/ktsaou))
- Added uwsgi plugin [\#4404](https://github.com/netdata/netdata/pull/4404) ([robbert-ef](https://github.com/robbert-ef))
- Add sendmail into the list of mail servers [\#4402](https://github.com/netdata/netdata/pull/4402) ([vladmovchan](https://github.com/vladmovchan))
- Fix make dist [\#4401](https://github.com/netdata/netdata/pull/4401) ([ktsaou](https://github.com/ktsaou))
- fix compilation on FreeBSD;  [\#4398](https://github.com/netdata/netdata/pull/4398) ([ktsaou](https://github.com/ktsaou))
- modularized all source code [\#4391](https://github.com/netdata/netdata/pull/4391) ([ktsaou](https://github.com/ktsaou))
- Account "Laundry" pages on FreeBSD [\#4390](https://github.com/netdata/netdata/pull/4390) ([vladmovchan](https://github.com/vladmovchan))
- normalized plugin names on all plugins;  [\#4387](https://github.com/netdata/netdata/pull/4387) ([ktsaou](https://github.com/ktsaou))
- updated swagger info for HTTPS [\#4386](https://github.com/netdata/netdata/pull/4386) ([ktsaou](https://github.com/ktsaou))
- make future code PEP8 compliant [\#4382](https://github.com/netdata/netdata/pull/4382) ([paulfantom](https://github.com/paulfantom))
- modularize C source code [\#4372](https://github.com/netdata/netdata/pull/4372) ([ktsaou](https://github.com/ktsaou))
- fix docker builds [\#4367](https://github.com/netdata/netdata/pull/4367) ([paulfantom](https://github.com/paulfantom))
- add option to run netdata in the background [\#4364](https://github.com/netdata/netdata/pull/4364) ([pohzipohzi](https://github.com/pohzipohzi))
- support filtering of charts during streaming; [\#4361](https://github.com/netdata/netdata/pull/4361) ([ktsaou](https://github.com/ktsaou))
- edit-config should use . instead of source with /bin/sh [\#4360](https://github.com/netdata/netdata/pull/4360) ([ktsaou](https://github.com/ktsaou))
- send pipes URL encoded [\#4358](https://github.com/netdata/netdata/pull/4358) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4356](https://github.com/netdata/netdata/pull/4356) ([ktsaou](https://github.com/ktsaou))
- Fix firehol image tagging [\#4355](https://github.com/netdata/netdata/pull/4355) ([paulfantom](https://github.com/paulfantom))
- Fix apache ipv6 configuration [\#4349](https://github.com/netdata/netdata/pull/4349) ([candrews](https://github.com/candrews))
- Fix phpfpm ipv6 configuration [\#4348](https://github.com/netdata/netdata/pull/4348) ([candrews](https://github.com/candrews))
- Add query types to mysql plugin [\#4347](https://github.com/netdata/netdata/pull/4347) ([roedie](https://github.com/roedie))
- ExecutableService: return \[\] instead of None if no data. [\#4346](https://github.com/netdata/netdata/pull/4346) ([Ferroin](https://github.com/Ferroin))
- Fix the last few PEP 8 compliance issues. [\#4345](https://github.com/netdata/netdata/pull/4345) ([Ferroin](https://github.com/Ferroin))
- log flood should not be disabled;  [\#4344](https://github.com/netdata/netdata/pull/4344) ([ktsaou](https://github.com/ktsaou))
- better daemon errors about files;  [\#4342](https://github.com/netdata/netdata/pull/4342) ([ktsaou](https://github.com/ktsaou))
- added edit-config [\#4338](https://github.com/netdata/netdata/pull/4338) ([ktsaou](https://github.com/ktsaou))
- Fix BIND outgoing stats in a multiview environment [\#4337](https://github.com/netdata/netdata/pull/4337) ([vobruba-martin](https://github.com/vobruba-martin))
- fixes coverity identified issues [\#4333](https://github.com/netdata/netdata/pull/4333) ([ktsaou](https://github.com/ktsaou))
- Use newer docker in CI build [\#4332](https://github.com/netdata/netdata/pull/4332) ([paulfantom](https://github.com/paulfantom))
- fix docker image [\#4330](https://github.com/netdata/netdata/pull/4330) ([paulfantom](https://github.com/paulfantom))
- Auto-releaser [\#4328](https://github.com/netdata/netdata/pull/4328) ([paulfantom](https://github.com/paulfantom))
- fix spdx headers [\#4327](https://github.com/netdata/netdata/pull/4327) ([paulfantom](https://github.com/paulfantom))
- updated LGTM URLs [\#4317](https://github.com/netdata/netdata/pull/4317) ([ktsaou](https://github.com/ktsaou))
- more code owners [\#4316](https://github.com/netdata/netdata/pull/4316) ([paulfantom](https://github.com/paulfantom))
- Use docker manifests [\#4315](https://github.com/netdata/netdata/pull/4315) ([paulfantom](https://github.com/paulfantom))
- install some libs for coverity [\#4314](https://github.com/netdata/netdata/pull/4314) ([paulfantom](https://github.com/paulfantom))
- cleanup FIXME tags [\#4309](https://github.com/netdata/netdata/pull/4309) ([ktsaou](https://github.com/ktsaou))
- force symlink of netdata-updater.sh [\#4307](https://github.com/netdata/netdata/pull/4307) ([mrdrogdrog](https://github.com/mrdrogdrog))
- Build OSX earlier than linux [\#4305](https://github.com/netdata/netdata/pull/4305) ([paulfantom](https://github.com/paulfantom))
- Fix coverity-scan.sh [\#4304](https://github.com/netdata/netdata/pull/4304) ([paulfantom](https://github.com/paulfantom))
- Python.d PEP 8 cleanup, modules S-Z [\#4302](https://github.com/netdata/netdata/pull/4302) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules P-R [\#4299](https://github.com/netdata/netdata/pull/4299) ([Ferroin](https://github.com/Ferroin))
- Python.d/postgres.chart.py PEP 8 code cleanup [\#4298](https://github.com/netdata/netdata/pull/4298) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules N-O [\#4297](https://github.com/netdata/netdata/pull/4297) ([Ferroin](https://github.com/Ferroin))
- reproducible build system [\#4294](https://github.com/netdata/netdata/pull/4294) ([paulfantom](https://github.com/paulfantom))
- update variable after install [\#4292](https://github.com/netdata/netdata/pull/4292) ([paulfantom](https://github.com/paulfantom))
- give credit where credit is due [\#4291](https://github.com/netdata/netdata/pull/4291) ([paulfantom](https://github.com/paulfantom))
- fix typo in coverity scan script [\#4290](https://github.com/netdata/netdata/pull/4290) ([paulfantom](https://github.com/paulfantom))
- Python.d PEP 8 cleanup, modules M [\#4289](https://github.com/netdata/netdata/pull/4289) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules I-L [\#4288](https://github.com/netdata/netdata/pull/4288) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules D-H [\#4287](https://github.com/netdata/netdata/pull/4287) ([Ferroin](https://github.com/Ferroin))
- Python.d PEP 8 cleanup, modules A-C [\#4286](https://github.com/netdata/netdata/pull/4286) ([Ferroin](https://github.com/Ferroin))
- Fix typo in documentation [\#4284](https://github.com/netdata/netdata/pull/4284) ([eduherminio](https://github.com/eduherminio))
- stock configs in /usr/lib/netdata [\#4283](https://github.com/netdata/netdata/pull/4283) ([ktsaou](https://github.com/ktsaou))
- use flake8 instead of pylint [\#4282](https://github.com/netdata/netdata/pull/4282) ([paulfantom](https://github.com/paulfantom))
- tcp syn and accept queue charts and alarms [\#4281](https://github.com/netdata/netdata/pull/4281) ([ktsaou](https://github.com/ktsaou))
- add code of conduct [\#4280](https://github.com/netdata/netdata/pull/4280) ([paulfantom](https://github.com/paulfantom))
- megacli plugin: adapter regex update [\#4279](https://github.com/netdata/netdata/pull/4279) ([ilyam8](https://github.com/ilyam8))
- Allow DOCKER\_HOST env variable to override default docker socket path [\#4277](https://github.com/netdata/netdata/pull/4277) ([xginn8](https://github.com/xginn8))
- Add other common IoT services to apps\_groups.conf [\#4276](https://github.com/netdata/netdata/pull/4276) ([xginn8](https://github.com/xginn8))
- fix python warnings identified by LGTM [\#4275](https://github.com/netdata/netdata/pull/4275) ([ilyam8](https://github.com/ilyam8))
- nightly builds + coverity scan [\#4273](https://github.com/netdata/netdata/pull/4273) ([paulfantom](https://github.com/paulfantom))
- better lgtm config [\#4272](https://github.com/netdata/netdata/pull/4272) ([paulfantom](https://github.com/paulfantom))
- Fixup small python-logind typos [\#4271](https://github.com/netdata/netdata/pull/4271) ([xginn8](https://github.com/xginn8))
- Fix several typos in documentation [\#4270](https://github.com/netdata/netdata/pull/4270) ([Calinou](https://github.com/Calinou))
- \[WIP\] LGTM tag classification [\#4269](https://github.com/netdata/netdata/pull/4269) ([paulfantom](https://github.com/paulfantom))
- create stale bot integration [\#4268](https://github.com/netdata/netdata/pull/4268) ([paulfantom](https://github.com/paulfantom))
- apps.plugin fixes [\#4267](https://github.com/netdata/netdata/pull/4267) ([ktsaou](https://github.com/ktsaou))
- finetune Code Owners entries [\#4264](https://github.com/netdata/netdata/pull/4264) ([paulfantom](https://github.com/paulfantom))
- updated readme for netdata org [\#4262](https://github.com/netdata/netdata/pull/4262) ([ktsaou](https://github.com/ktsaou))
- \[cleanup crusade\] Shellcheck [\#4261](https://github.com/netdata/netdata/pull/4261) ([paulfantom](https://github.com/paulfantom))
- \[WIP\] release less artifacts [\#4260](https://github.com/netdata/netdata/pull/4260) ([paulfantom](https://github.com/paulfantom))
- Make method in url service configurable [\#4257](https://github.com/netdata/netdata/pull/4257) ([ccremer](https://github.com/ccremer))
- Fix typo in documentation [\#4255](https://github.com/netdata/netdata/pull/4255) ([olivierlambert](https://github.com/olivierlambert))
- coverity should still use firehol/netdata until we find a solution [\#4253](https://github.com/netdata/netdata/pull/4253) ([ktsaou](https://github.com/ktsaou))
- fix badges in README.md [\#4251](https://github.com/netdata/netdata/pull/4251) ([paulfantom](https://github.com/paulfantom))
- replaced referenced to firehol github org with netdata github org [\#4249](https://github.com/netdata/netdata/pull/4249) ([ktsaou](https://github.com/ktsaou))
- Travis and docker setup after migration [\#4247](https://github.com/netdata/netdata/pull/4247) ([paulfantom](https://github.com/paulfantom))
- collect TcpExtTCPReqQFullDrop;  [\#4246](https://github.com/netdata/netdata/pull/4246) ([ktsaou](https://github.com/ktsaou))
- fixed typo in prometheus\_all\_hosts output [\#4245](https://github.com/netdata/netdata/pull/4245) ([ktsaou](https://github.com/ktsaou))
- apps.plugin now checks fds for changes, with adaptive caching [\#4243](https://github.com/netdata/netdata/pull/4243) ([ktsaou](https://github.com/ktsaou))
- Added -NoLog parameter for megacli calls [\#4242](https://github.com/netdata/netdata/pull/4242) ([vobruba-martin](https://github.com/vobruba-martin))
- updated configs.signatures [\#4240](https://github.com/netdata/netdata/pull/4240) ([ktsaou](https://github.com/ktsaou))
- command js is not node.js [\#4239](https://github.com/netdata/netdata/pull/4239) ([ktsaou](https://github.com/ktsaou))
- Fix missing comma in couchdb module. [\#4238](https://github.com/netdata/netdata/pull/4238) ([Ferroin](https://github.com/Ferroin))
- Fix LGTM complaints in monit module. [\#4237](https://github.com/netdata/netdata/pull/4237) ([Ferroin](https://github.com/Ferroin))
- daemon cleanup [\#4231](https://github.com/netdata/netdata/pull/4231) ([ktsaou](https://github.com/ktsaou))
- varnish plugin bugfix [\#4228](https://github.com/netdata/netdata/pull/4228) ([ilyam8](https://github.com/ilyam8))
- CLA signing using cla-assistant.io [\#4226](https://github.com/netdata/netdata/pull/4226) ([ktsaou](https://github.com/ktsaou))
- Disable IPFS Pin API [\#4224](https://github.com/netdata/netdata/pull/4224) ([jkpit](https://github.com/jkpit))
- fixes identified by LGTM [\#4220](https://github.com/netdata/netdata/pull/4220) ([ktsaou](https://github.com/ktsaou))
- workaround for LGTM false-positives [\#4218](https://github.com/netdata/netdata/pull/4218) ([ktsaou](https://github.com/ktsaou))
- fixed issues identified by lgtm [\#4216](https://github.com/netdata/netdata/pull/4216) ([ktsaou](https://github.com/ktsaou))
- fix netdata server URL detection in dashboard.js; [\#4215](https://github.com/netdata/netdata/pull/4215) ([ktsaou](https://github.com/ktsaou))
- Create lgtm config [\#4213](https://github.com/netdata/netdata/pull/4213) ([paulfantom](https://github.com/paulfantom))
- more LGTM minor fixes [\#4211](https://github.com/netdata/netdata/pull/4211) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4210](https://github.com/netdata/netdata/pull/4210) ([ktsaou](https://github.com/ktsaou))
- fixes identified by LGTM [\#4209](https://github.com/netdata/netdata/pull/4209) ([ktsaou](https://github.com/ktsaou))
- allow empty values in config settings;  [\#4208](https://github.com/netdata/netdata/pull/4208) ([ktsaou](https://github.com/ktsaou))
- added UTC to server timezones list; [\#4207](https://github.com/netdata/netdata/pull/4207) ([ktsaou](https://github.com/ktsaou))
- redis plugin bugfix [\#4205](https://github.com/netdata/netdata/pull/4205) ([ilyam8](https://github.com/ilyam8))
- send host variables to prometheus [\#4200](https://github.com/netdata/netdata/pull/4200) ([ktsaou](https://github.com/ktsaou))
- Update CONTRIBUTORS.md [\#4197](https://github.com/netdata/netdata/pull/4197) ([paulfantom](https://github.com/paulfantom))
- nginx\_plus: use upstream server IP:port in dimension IDs, not the transient ID [\#4194](https://github.com/netdata/netdata/pull/4194) ([illes](https://github.com/illes))
- time-duration badges should show "undefined" instead of "never"  [\#4193](https://github.com/netdata/netdata/pull/4193) ([ktsaou](https://github.com/ktsaou))
- Add docker plugin [\#4191](https://github.com/netdata/netdata/pull/4191) ([tuxity](https://github.com/tuxity))
- Improve packaging checks [\#4188](https://github.com/netdata/netdata/pull/4188) ([philwhineray](https://github.com/philwhineray))
- elasticsearch: handle json parse error in threads [\#4186](https://github.com/netdata/netdata/pull/4186) ([ilyam8](https://github.com/ilyam8))
- pythond\_small\_fixes [\#4185](https://github.com/netdata/netdata/pull/4185) ([ilyam8](https://github.com/ilyam8))
- \[cleanup crusade\] more linting of bash modules [\#4183](https://github.com/netdata/netdata/pull/4183) ([paulfantom](https://github.com/paulfantom))
-  create pid directory, if not present [\#4181](https://github.com/netdata/netdata/pull/4181) ([ktsaou](https://github.com/ktsaou))
- fix for load alarms [\#4180](https://github.com/netdata/netdata/pull/4180) ([ktsaou](https://github.com/ktsaou))
- updated configs.signatures [\#4179](https://github.com/netdata/netdata/pull/4179) ([ktsaou](https://github.com/ktsaou))
- Add permission file check in ceph module [\#4177](https://github.com/netdata/netdata/pull/4177) ([lets00](https://github.com/lets00))
- \[cleanup crusade\] disable linters on installer scripts [\#4176](https://github.com/netdata/netdata/pull/4176) ([paulfantom](https://github.com/paulfantom))
- Add alarms for abnormally high load averages. [\#4175](https://github.com/netdata/netdata/pull/4175) ([Ferroin](https://github.com/Ferroin))
- CI builds in containers [\#4174](https://github.com/netdata/netdata/pull/4174) ([paulfantom](https://github.com/paulfantom))
- Fix lack of dot [\#4172](https://github.com/netdata/netdata/pull/4172) ([paulfantom](https://github.com/paulfantom))
- remove condition from netdata.service [\#4170](https://github.com/netdata/netdata/pull/4170) ([ktsaou](https://github.com/ktsaou))
- \[WIP\] fail2ban: ipv6 support added + module simplification [\#4168](https://github.com/netdata/netdata/pull/4168) ([ilyam8](https://github.com/ilyam8))
- \[cleanup crusade\] linting shell scripts for docker, tests and python [\#4162](https://github.com/netdata/netdata/pull/4162) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] shellcheck in contrib [\#4160](https://github.com/netdata/netdata/pull/4160) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] Lint bash scripts on letter A [\#4159](https://github.com/netdata/netdata/pull/4159) ([paulfantom](https://github.com/paulfantom))
- use pidfile to send HUP to netdata via logrotate; [\#4157](https://github.com/netdata/netdata/pull/4157) ([ktsaou](https://github.com/ktsaou))
- python plugin monotonic fix [\#4156](https://github.com/netdata/netdata/pull/4156) ([ilyam8](https://github.com/ilyam8))
- add variable system.cpu.processors for alarms;  [\#4155](https://github.com/netdata/netdata/pull/4155) ([ktsaou](https://github.com/ktsaou))
- netdata.service is now installed in /lib/systemd/system;  [\#4151](https://github.com/netdata/netdata/pull/4151) ([ktsaou](https://github.com/ktsaou))
- name veritas volume disk groups [\#4150](https://github.com/netdata/netdata/pull/4150) ([ktsaou](https://github.com/ktsaou))
- do not get the address of FILE pointer;  [\#4149](https://github.com/netdata/netdata/pull/4149) ([ktsaou](https://github.com/ktsaou))
- Add some extra error logging to the spigotmc module. [\#4148](https://github.com/netdata/netdata/pull/4148) ([Ferroin](https://github.com/Ferroin))
- /proc/net/snmp minimum line length for IcmpMsg is 2 words, not 3 [\#4147](https://github.com/netdata/netdata/pull/4147) ([ktsaou](https://github.com/ktsaou))
- when running under systemd, keep the process scheduling parameters set [\#4143](https://github.com/netdata/netdata/pull/4143) ([ktsaou](https://github.com/ktsaou))
- \[cleanup crusade\] travis build stages [\#4142](https://github.com/netdata/netdata/pull/4142) ([paulfantom](https://github.com/paulfantom))
- Add ignore-status option to freeipmi\_plugin [\#4141](https://github.com/netdata/netdata/pull/4141) ([plasticrake](https://github.com/plasticrake))
- \[cleanup crusade\] move profiling to tests directory [\#4140](https://github.com/netdata/netdata/pull/4140) ([paulfantom](https://github.com/paulfantom))
- Less verbose bash and curl unpacking [\#4139](https://github.com/netdata/netdata/pull/4139) ([paulfantom](https://github.com/paulfantom))
- \[project management\] add github CODEOWNERS [\#4137](https://github.com/netdata/netdata/pull/4137) ([paulfantom](https://github.com/paulfantom))
- \[cleanup crusade\] cleanup licenses [\#4136](https://github.com/netdata/netdata/pull/4136) ([paulfantom](https://github.com/paulfantom))
- Add ProxySQL python plugin [\#4112](https://github.com/netdata/netdata/pull/4112) ([alibo](https://github.com/alibo))
- Optimize counting of recusive pins [\#4095](https://github.com/netdata/netdata/pull/4095) ([pjz](https://github.com/pjz))
- \[nginx\_plus\] fix handling of non-contiguous peer IDs [\#4093](https://github.com/netdata/netdata/pull/4093) ([illes](https://github.com/illes))
- web\_log Virtual host enhancement and http/https [\#4076](https://github.com/netdata/netdata/pull/4076) ([jgrossiord](https://github.com/jgrossiord))
- push host tags for graphite;  [\#3992](https://github.com/netdata/netdata/pull/3992) ([ktsaou](https://github.com/ktsaou))
- rethinkdb python plugin [\#3955](https://github.com/netdata/netdata/pull/3955) ([ilyam8](https://github.com/ilyam8))
- Add a python plugin for monitoring power supplies on Linux. [\#3799](https://github.com/netdata/netdata/pull/3799) ([Ferroin](https://github.com/Ferroin))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
