/*
   Copyright 2013-2014 EditShare, 2013-2015 Skytechnology sp. z o.o.

   This file is part of LizardFS.

   LizardFS is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, version 3.

   LizardFS is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with LizardFS. If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "common/platform.h"

#include "protocol/packet.h"
#include "common/serialization_macros.h"
#include "common/tape_key.h"

LIZARDFS_DEFINE_PACKET_SERIALIZATION(
		tstoma, registerTapeserver, LIZ_TSTOMA_REGISTER_TAPESERVER, 0,
		uint32_t, version,
		std::string, name)

LIZARDFS_DEFINE_PACKET_SERIALIZATION(
		tstoma, hasFiles, LIZ_TSTOMA_HAS_FILES, 0,
		std::vector<TapeKey>, tapeContents)

LIZARDFS_DEFINE_PACKET_SERIALIZATION(
		tstoma, endOfFiles, LIZ_TSTOMA_END_OF_FILES, 0)
