#!/bin/sh

INFILE=debian/alternatives
BASEDIR=/usr/lib/pd/extra/Gem
DOLLAR1='$1'

make_postinst() {
cat <<EOL
#! /bin/sh

set -e

#DEBHELPER#

EOL

 egrep "^$1[ 	]" "${INFILE}" | while read pkg priority dst src
 do
   echo "        update-alternatives --install ${BASEDIR}/${dst} ${dst} ${BASEDIR}/${src} ${priority}"
 done

cat <<EOL

exit 0
EOL
}

make_prerm() {
cat <<EOL
#!/bin/sh -e

set -e

#DEBHELPER#

case "$DOLLAR1" in
    (remove|deconfigure)
EOL

 egrep "^$1[ 	]" "${INFILE}" | while read pkg priority dst src
 do
   echo "        update-alternatives --remove ${dst} ${BASEDIR}/${src}"
 done

cat <<EOL
    ;;
    (upgrade)
    ;;

    (failed-upgrade)
    ;;

    (*)
        echo "prerm called with unknown argument \\\`$DOLLAR1'" >&2
        exit 0
    ;;
esac

exit 0
EOL
}


make_alternative() {
   make_postinst $1 > debian/$1.postinst
   make_prerm $1 > debian/$1.prerm
}


cat ${INFILE} | sed -e 's|#.*||' | grep . | awk '{print $1}' | sort -u | while read pkg
do
 make_alternative $pkg
done
