/*
 * Copyright (C) 2024 Igalia S.L.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include "WPEEvent.h"
#include <optional>

namespace WPE {

class GestureDetector final {
public:
    void handleEvent(WPEEvent*);
    WPEGesture gesture() const { return m_gesture; }
    void reset();

    struct Position {
        double x;
        double y;
    };
    using Delta = Position;

    std::optional<Position> position() const { return m_position; }
    std::optional<Delta> delta() const { return m_delta; }
    bool dragBegin() const { return m_dragBegin && *m_dragBegin; }

private:
    // FIXME: These ought to be either configurable or derived from system
    //        properties, such as screen size and pixel density.
    static constexpr uint32_t dragActivationThresholdPx { 8 };

    WPEGesture m_gesture { WPE_GESTURE_NONE };
    std::optional<uint32_t> m_sequenceId;
    std::optional<Position> m_position;
    std::optional<Position> m_nextDeltaReferencePosition;
    std::optional<Delta> m_delta;
    std::optional<bool> m_dragBegin;
};

} // namespace WPE
