% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viridis.R
\name{viridis}
\alias{viridis}
\alias{viridisMap}
\alias{magma}
\alias{inferno}
\alias{plasma}
\alias{cividis}
\alias{rocket}
\alias{mako}
\alias{turbo}
\title{Viridis Color Palettes}
\usage{
viridis(n, alpha = 1, begin = 0, end = 1, direction = 1, option = "D")

viridisMap(n = 256, alpha = 1, begin = 0, end = 1, direction = 1, option = "D")

magma(n, alpha = 1, begin = 0, end = 1, direction = 1)

inferno(n, alpha = 1, begin = 0, end = 1, direction = 1)

plasma(n, alpha = 1, begin = 0, end = 1, direction = 1)

cividis(n, alpha = 1, begin = 0, end = 1, direction = 1)

rocket(n, alpha = 1, begin = 0, end = 1, direction = 1)

mako(n, alpha = 1, begin = 0, end = 1, direction = 1)

turbo(n, alpha = 1, begin = 0, end = 1, direction = 1)
}
\arguments{
\item{n}{The number of colors (\eqn{\ge 1}) to be in the palette.}

\item{alpha}{The alpha transparency, a number in [0,1], see argument alpha in
\code{\link[grDevices]{hsv}}.}

\item{begin}{The (corrected) hue in [0,1] at which the color map begins.}

\item{end}{The (corrected) hue in [0,1] at which the color map ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are ordered from darkest to lightest. If -1, the order of colors is
reversed.}

\item{option}{A character string indicating the color map option to use.
Eight options are available:
\itemize{
 \item "magma" (or "A")
 \item "inferno" (or "B")
 \item "plasma" (or "C")
 \item "viridis" (or "D")
 \item "cividis" (or "E")
 \item "rocket" (or "F")
 \item "mako" (or "G")
 \item "turbo" (or "H")
}}
}
\value{
\code{viridis} returns a character vector, \code{cv}, of color hex
 codes. This can be used either to create a user-defined color palette for
 subsequent graphics by \code{palette(cv)}, a \code{col =} specification in
 graphics functions or in \code{par}.

\code{viridisMap} returns a \code{n} lines data frame containing the
 red (\code{R}), green (\code{G}), blue (\code{B}) and alpha (\code{alpha})
 channels of \code{n} equally spaced colors along the selected color map.
 \code{n = 256} by default.
}
\description{
This function creates a vector of \code{n} equally spaced colors
 along the selected color map.
}
\details{
\if{html}{Here are the color scales:

  \out{<div style="text-align: center">}\figure{viridis-scales.png}{options: style="width:750px;max-width:75\%;"}\out{</div>}

  }
\if{latex}{Here are the color scales:

  \out{\begin{center}}\figure{viridis-scales.png}\out{\end{center}}
  }

\code{magma()}, \code{plasma()}, \code{inferno()}, \code{cividis()},
 \code{rocket()}, \code{mako()}, and \code{turbo()} are convenience functions
 for the other color map options, which are useful when the scale must be
 passed as a function name.

Semi-transparent colors (\eqn{0 < alpha < 1}) are supported only on some
 devices: see \code{\link[grDevices]{rgb}}.
}
\examples{
library(ggplot2)
library(hexbin)

dat <- data.frame(x = rnorm(10000), y = rnorm(10000))

ggplot(dat, aes(x = x, y = y)) +
  geom_hex() + coord_fixed() +
  scale_fill_gradientn(colours = viridis(256, option = "D"))

# using code from RColorBrewer to demo the palette
n = 200
image(
  1:n, 1, as.matrix(1:n),
  col = viridis(n, option = "D"),
  xlab = "viridis n", ylab = "", xaxt = "n", yaxt = "n", bty = "n"
)
}
\author{
Simon Garnier: \email{garnier@njit.edu} / \href{https://twitter.com/sjmgarnier}{@sjmgarnier}
}
