% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{local_options}
\alias{local_options}
\alias{with_options}
\alias{push_options}
\alias{peek_options}
\alias{peek_option}
\title{Change global options}
\usage{
local_options(..., .frame = caller_env())

with_options(.expr, ...)

push_options(...)

peek_options(...)

peek_option(name)
}
\arguments{
\item{...}{For \code{local_options()} and \code{push_options()}, named
values defining new option values. For \code{peek_options()}, strings
or character vectors of option names.}

\item{.frame}{The environment of a stack frame which defines the
scope of the temporary options. When the frame returns, the
options are set back to their original values.}

\item{.expr}{An expression to evaluate with temporary options.}

\item{name}{An option name as string.}
}
\value{
For \code{local_options()} and \code{push_options()}, the old option
values. \code{peek_option()} returns the current value of an option
while the plural \code{peek_options()} returns a list of current
option values.
}
\description{
\itemize{
\item \code{local_options()} changes options for the duration of a stack
frame (by default the current one). Options are set back to their
old values when the frame returns.
\item \code{with_options()} changes options while an expression is
evaluated. Options are restored when the expression returns.
\item \code{push_options()} adds or changes options permanently.
\item \code{peek_option()} and \code{peek_options()} return option values. The
former returns the option directly while the latter returns a
list.
}
}
\section{Life cycle}{


These functions are experimental.
}

\examples{
# Store and retrieve a global option:
push_options(my_option = 10)
peek_option("my_option")

# Change the option temporarily:
with_options(my_option = 100, peek_option("my_option"))
peek_option("my_option")

# The scoped variant is useful within functions:
fn <- function() {
  local_options(my_option = 100)
  peek_option("my_option")
}
fn()
peek_option("my_option")

# The plural peek returns a named list:
peek_options("my_option")
peek_options("my_option", "digits")
}
\keyword{experimental}
