#!/bin/sh
# Copyright 2017 The Chromium Authors
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

dirs=$(find components-chromium -type d | grep -v 'components-chromium/polymer')

gn_files=''

for dir in $dirs; do
  files=$(\ls $dir/*.js 2>/dev/null)
  if [ "$files" ]; then
    echo "Analyzing $dir"
    gn_file="$dir/BUILD.gn"
    content=$(../../../tools/polymer/generate_gn_v3.py $files);
    if [ "$content" ]; then
      echo "Writing $gn_file"
      echo "$content" > "$gn_file"
      gn_files="$gn_files $gn_file"
    elif [ -f "$gn_file" ]; then
      echo "Removing $gn_file"
      rm "$gn_file"
    fi
    echo
  fi
done

# Copy components-chromium/polymer BUILD.gn file manually, since it is not
# auto-generated by generate_gn_v3.py.
cp ./BUILD_polymer.gn "components-chromium/polymer/BUILD.gn"

git cl format $gn_files
